/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.ant.gui.configuration;

import ch.e2e.ant.gui.configuration.AntProjectFactory;
import ch.e2e.dom.DomUtilities;
import ch.e2e.io.FileUtilities;
import ch.e2e.resource.Properties;
import ch.e2e.util.StringTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DefaultAntProjectFactory
extends AntProjectFactory {
    private Hashtable<String, AntDocument> antDocuments = new Hashtable();

    @Override
    public void registerAntDocument(String antfile, Document document) {
        if (!this.antDocuments.containsKey(antfile)) {
            AntDocument antDocument = new AntDocument();
            antDocument.document = document;
            this.antDocuments.put(antfile, antDocument);
        }
    }

    @Override
    public Project getProject(String antfile, Properties properties, File basedir) throws IOException, TransformerException {
        AntDocument antDocument = this.antDocuments.get(antfile);
        if (antDocument == null) {
            antDocument = this.getAntDocument(antfile, properties, basedir);
            this.antDocuments.put(antfile, antDocument);
        }
        Project project = null;
        if (antDocument != null) {
            if (antDocument.buildFile == null || !antDocument.buildFile.exists()) {
                if (antDocument.document != null) {
                    Element root = antDocument.document.getDocumentElement();
                    boolean basedirSet = this.checkBasedirProperties(root, properties, antDocument);
                    if (basedirSet && basedir != null) {
                        AntDocument antDocument2 = antDocument;
                        antDocument2.changed = antDocument2.changed | this.compareBasedir(root, new File(antfile), basedir, properties);
                    } else if (!basedirSet) {
                        antDocument.changed = true;
                        this.setBasedir(basedir, new File(antfile), root);
                    }
                    antDocument.buildFile = this.createBuildFile(antDocument.document);
                }
            } else if (basedir != null) {
                this.checkBasedir(basedir, antDocument, properties);
            }
            project = new Project();
            project.setProperty("ant.file", antDocument.buildFile.getAbsolutePath());
            this.addProperties(project, properties);
            project.init();
            this.addTaskdefs(project);
            this.addTypedefs(project);
            ProjectHelper.getProjectHelper().parse(project, (Object)antDocument.buildFile);
        }
        return project;
    }

    private void checkBasedir(File basedir, AntDocument antDocument, Properties properties) throws IOException, TransformerException {
        Element root = antDocument.document.getDocumentElement();
        String projectBasedir = root.getAttribute("basedir");
        File realBasedir = new File(StringTools.replaceProperties((String)projectBasedir, (Map)properties));
        if (!basedir.equals(realBasedir)) {
            root.setAttribute("basedir", FileUtilities.getAbsolutePath((File)basedir));
        }
        DomUtilities.serialize((File)antDocument.buildFile, (Document)antDocument.document, (boolean)true);
    }

    private void addTaskdefs(Project project) {
        ArrayList<String> taskdefResources = DefaultAntProjectFactory.getTaskdefResources();
        for (String resource : taskdefResources) {
            try {
                ResourceBundle properties = ResourceBundle.getBundle(resource);
                Enumeration<String> keys = properties.getKeys();
                while (keys.hasMoreElements()) {
                    String name = keys.nextElement();
                    String classname = properties.getString(name);
                    try {
                        project.addTaskDefinition(name, Class.forName(classname));
                    }
                    catch (Throwable e) {
                        System.out.println("WARNING: " + e.getMessage());
                    }
                }
            }
            catch (MissingResourceException properties) {
            }
        }
        HashMap<String, String> taskdefs = DefaultAntProjectFactory.getTaskdefs();
        Iterator<String> iterator = taskdefs.keySet().iterator();
        while (iterator.hasNext()) {
            String o;
            String name = o = iterator.next();
            String classname = taskdefs.get(name);
            try {
                project.addTaskDefinition(name, Class.forName(classname));
            }
            catch (ClassNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private void addTypedefs(Project project) {
        ArrayList<String> typedefResources = DefaultAntProjectFactory.getTypedefResources();
        Iterator<String> iterator = typedefResources.iterator();
        while (iterator.hasNext()) {
            String typedefResource;
            String resource = typedefResource = iterator.next();
            try {
                ResourceBundle properties = ResourceBundle.getBundle(resource);
                Enumeration<String> keys = properties.getKeys();
                while (keys.hasMoreElements()) {
                    String name = keys.nextElement();
                    String classname = properties.getString(name);
                    try {
                        project.addDataTypeDefinition(name, Class.forName(classname));
                    }
                    catch (ClassNotFoundException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
            }
            catch (MissingResourceException properties) {
            }
        }
        HashMap typedefs = DefaultAntProjectFactory.getTypedefs();
        for (Object o : typedefs.keySet()) {
            String name = (String)o;
            String classname = (String)typedefs.get(name);
            try {
                project.addDataTypeDefinition(name, Class.forName(classname));
            }
            catch (ClassNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private AntDocument getAntDocument(String antfile, Properties properties, File basedir) throws TransformerException, IOException {
        AntDocument antDocument;
        File buildFile = new File(antfile);
        if (!buildFile.exists() || basedir != null) {
            antDocument = this.getAntDocument(buildFile, antfile);
            if (antDocument.document != null) {
                Element root = antDocument.document.getDocumentElement();
                boolean basedirSet = this.checkBasedirProperties(root, properties, antDocument);
                if (basedirSet && basedir != null) {
                    AntDocument antDocument2 = antDocument;
                    antDocument2.changed = antDocument2.changed | this.compareBasedir(root, buildFile, basedir, properties);
                } else if (!basedirSet) {
                    antDocument.changed = true;
                    this.setBasedir(basedir, buildFile, root);
                }
                if (antDocument.changed) {
                    buildFile = this.createBuildFile(antDocument.document);
                }
            }
        } else {
            antDocument = new AntDocument();
        }
        antDocument.buildFile = buildFile;
        return antDocument;
    }

    private void setBasedir(File basedir, File buildFile, Element root) {
        String absolutePath = basedir == null ? FileUtilities.getAbsolutePath((File)buildFile.getParentFile()) : FileUtilities.getAbsolutePath((File)basedir);
        root.setAttribute("basedir", absolutePath);
    }

    private boolean checkBasedirProperties(Element root, Properties properties, AntDocument antDocument) {
        String realBasedir;
        String projectBasedir;
        boolean basedirSet = root.hasAttribute("basedir");
        if (basedirSet && !(projectBasedir = root.getAttribute("basedir")).equals(realBasedir = StringTools.replaceProperties((String)projectBasedir, (Map)properties))) {
            root.setAttribute("basedir", realBasedir);
            antDocument.changed = true;
        }
        return basedirSet;
    }

    private File createBuildFile(Document document) throws IOException, TransformerException {
        File buildFile = File.createTempFile("build", ".xml");
        buildFile.deleteOnExit();
        if (!buildFile.getParentFile().exists()) {
            buildFile.getParentFile().mkdirs();
        }
        DomUtilities.serialize((File)buildFile, (Document)document, (boolean)true);
        return buildFile;
    }

    private boolean compareBasedir(Element root, File buildFile, File basedir, Properties properties) {
        boolean documentChanged = false;
        String basedirStr = StringTools.replaceProperties((String)root.getAttribute("basedir"), (Map)properties);
        File documentBasedir = new File(basedirStr);
        if (!documentBasedir.isAbsolute()) {
            documentBasedir = buildFile.exists() ? new File(buildFile.getParentFile(), basedirStr) : new File(new File(""), basedirStr);
        }
        if (!basedir.equals(documentBasedir)) {
            root.setAttribute("basedir", FileUtilities.getAbsolutePath((File)basedir));
            documentChanged = true;
        }
        return documentChanged;
    }

    private AntDocument getAntDocument(File buildFile, String antfile) {
        AntDocument antDocument = null;
        try {
            if (buildFile.exists()) {
                antDocument = new AntDocument();
                antDocument.document = DomUtilities.parse((File)buildFile, (boolean)false, (boolean)false);
            } else {
                antDocument = this.getAntDocumentFromClasspath(antfile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return antDocument;
    }

    private AntDocument getAntDocumentFromClasspath(String antfile) throws ParserConfigurationException, SAXException, IOException {
        AntDocument antDocument = new AntDocument();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream buildFileIn = classLoader == null ? ClassLoader.getSystemResourceAsStream(antfile) : classLoader.getResourceAsStream(antfile);
        if (buildFileIn != null) {
            antDocument.document = DomUtilities.parse((InputStream)buildFileIn, (boolean)false, (boolean)false);
            antDocument.changed = true;
        }
        return antDocument;
    }

    private class AntDocument {
        private Document document;
        private File buildFile;
        private boolean changed = false;

        private AntDocument() {
        }
    }
}

