/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.testcase.parameter;

import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.ParameterContainer;
import ch.e2e.builder.trace.testcase.parameter.ParameterDefinitionHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class RecordParameter
extends Parameter
implements ParameterContainer {
    List<Parameter> items = new ArrayList<Parameter>();
    List<String> names = new ArrayList<String>();
    private String namespace;
    private String prefix;
    private String typeName;
    private boolean nil;
    private boolean recursive = false;

    public RecordParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        this(parameterElement, type, arrayItem, parent, definitionHolder, false);
    }

    public RecordParameter(Element parameterElement, int type, boolean arrayItem, RecordParameter parent, ParameterDefinitionHolder definitionHolder, boolean namespaceAware) {
        super(parameterElement, type, arrayItem, parent, definitionHolder);
        this.namespace = parameterElement.getAttribute("namespace");
        this.prefix = definitionHolder.getNamespacesManager().getPrefix(this.namespace);
        this.nil = namespaceAware ? Boolean.valueOf(parameterElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil")) : Boolean.valueOf(parameterElement.getAttribute("nil"));
    }

    RecordParameter(String name, int type, boolean arrayItem, String namespace, RecordParameter parent, ParameterDefinitionHolder definitionHolder) {
        super(name, type, arrayItem, parent, definitionHolder);
        this.namespace = namespace;
        this.prefix = definitionHolder.getNamespacesManager().getPrefix(namespace);
        this.nil = true;
    }

    public Set<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>();
        String namespace = this.getNamespace();
        if (namespace != null) {
            namespaces.add(namespace);
        }
        for (Parameter item : this.items) {
            if (!(item instanceof RecordParameter)) continue;
            namespaces.addAll(((RecordParameter)item).getNamespaces());
        }
        return namespaces;
    }

    @Override
    public String getDisplayValue() {
        return this.nil ? "null" : null;
    }

    @Override
    public boolean hasItems() {
        return !this.nil;
    }

    @Override
    public Object getChild(int index) {
        return this.items.get(index);
    }

    @Override
    public int getChildCount() {
        return this.items.size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.items.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return this.items.size() == 0;
    }

    @Override
    public Element createEmptyParameter(Document document) {
        Element parameterElement = document.createElement(this.getName());
        parameterElement.setAttribute("namespace", this.namespace);
        parameterElement.setAttribute("prefix", this.prefix);
        parameterElement.setAttribute("type", this.getOriginalType());
        parameterElement.setAttribute("nil", "true");
        this.addExtendedAttributes(parameterElement);
        return parameterElement;
    }

    protected void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public boolean isNull() {
        return this.nil;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    protected void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void create() {
        this.nil = false;
        RecordParameter parameter = (RecordParameter)this.getDefinitionHolder().findDefinition(this.getPath());
        int length = parameter.getChildCount();
        for (int i = 0; i < length; ++i) {
            boolean add;
            Parameter item = ((Parameter)parameter.getChild(i)).createEmptyParameter(this);
            int index = this.names.indexOf(item.getName());
            if (index == -1) {
                add = true;
            } else {
                Parameter existingItem = this.items.get(index);
                boolean bl = add = !existingItem.getTypeName().equals(item.getTypeName());
            }
            if (!add) continue;
            this.addItem(item);
        }
    }

    @Override
    String[] getPath() {
        if (this.isRecursive()) {
            RecordParameter p;
            for (p = this.getParent(); p != null && (p.isRecursive() || p.isArray() || !p.getOriginalType().equals(this.getOriginalType())); p = p.getParent()) {
            }
            if (p == null) {
                throw new IllegalStateException();
            }
            return p.getPath();
        }
        return super.getPath();
    }

    @Override
    public void setValue(Object value) {
        this.changed = false;
        if (value == null) {
            this.nil = true;
            this.items.clear();
            this.names.clear();
            this.setDisplayValue(value);
            this.changed = true;
        } else {
            super.setValue(value);
        }
    }

    @Override
    public boolean importValue(Object value) {
        this.setValue(value);
        return true;
    }

    @Override
    public Parameter getParameter(String name) {
        return this.items.get(this.names.indexOf(name));
    }

    @Override
    public boolean isChanged() {
        boolean changed = this.changed;
        int length = this.items.size();
        for (int i = 0; i < length && !changed; ++i) {
            changed = this.items.get(i).isChanged();
        }
        return changed;
    }

    public void removeItem(Parameter parameter) {
        this.items.remove(parameter);
        this.names.remove(parameter.getName());
    }

    void addItem(Parameter item) {
        this.items.add(item);
        this.names.add(item.getName());
    }

    void addItem(int index, Parameter item) {
        this.items.add(index, item);
        this.names.add(index, item.getName());
    }

    void setNil(boolean nil) {
        this.nil = nil;
    }

    String getOriginalType() {
        return this.getTypeName();
    }

    void addExtendedAttributes(Element element) {
    }

    String getNamespace() {
        return this.namespace;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    @Override
    public Element createParameterElement(Document document) {
        String name = this.getName();
        if (this.isArrayItem() && name.startsWith("item")) {
            name = "item";
        }
        Element parameter = document.createElement(name);
        parameter.setAttribute("type", this.getTypeName());
        if (this.isRecursive()) {
            parameter.setAttribute("recursive", "true");
        }
        if (this.isNull()) {
            parameter.setAttribute("nil", "true");
        } else {
            for (Parameter item : this.items) {
                parameter.appendChild(item.createParameterElement(document));
            }
        }
        parameter.setAttribute("prefix", this.prefix);
        parameter.setAttribute("namespace", this.namespace);
        return parameter;
    }

    @Override
    public boolean differsFrom(Parameter other) {
        int childCount = this.getChildCount();
        boolean differs = childCount != other.getChildCount() || super.differsFrom(other);
        for (int i = 0; !differs && i < childCount; ++i) {
            differs = this.items.get(i).differsFrom(((RecordParameter)other).items.get(i));
        }
        return differs;
    }
}

