/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.gui;

import ch.e2e.builder.base.gui.Property;
import ch.e2e.builder.base.gui.StringConstants;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class ResourceTableModel
extends DefaultTableModel
implements StringConstants {
    private List<Property> properties;

    public void setProperties(Map<Object, Object> properties) {
        this.properties = new ArrayList<Property>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.properties.add(new Property((String)entry.getKey(), entry.getValue().toString()));
        }
        Collections.sort(this.properties);
    }

    public void addProperty(Property property) {
        this.properties.add(property);
        Collections.sort(this.properties);
        this.fireTableDataChanged();
    }

    @Override
    public void removeRow(int row) {
        this.properties.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.properties != null) {
            Property property = this.properties.get(row);
            switch (column) {
                case 0: {
                    property.setKey((String)aValue);
                    break;
                }
                case 1: {
                    property.setValue((String)aValue);
                }
            }
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.properties == null) {
            result = super.getValueAt(row, column);
        } else if (row <= this.properties.size()) {
            Property property = this.properties.get(row);
            switch (column) {
                case 0: {
                    result = property.getKey();
                    break;
                }
                case 1: {
                    result = property.getValue();
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int column) {
        String result = null;
        switch (column) {
            case 0: {
                result = E2EBuilderTranslator.getTranslation((String)"resource.editor.table.title.key");
                break;
            }
            case 1: {
                result = E2EBuilderTranslator.getTranslation((String)"resource.editor.table.title.value");
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        return this.properties == null ? 0 : this.properties.size();
    }
}

