/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.application.abstracts;

import ch.e2e.builder.base.application.abstracts.AddMenuItemEvent;
import ch.e2e.builder.base.application.abstracts.AddMenuSeparatorEvent;
import ch.e2e.builder.base.application.abstracts.ModuleReleasedEvent;
import ch.e2e.builder.base.application.abstracts.ModuleShownEvent;
import ch.e2e.builder.base.application.abstracts.RegisterMenuEventEvent;
import ch.e2e.builder.base.application.abstracts.SelectMenuItemEvent;
import ch.e2e.builder.base.application.abstracts.SetMenuEnabledEvent;
import ch.e2e.builder.base.application.abstracts.SetMenuItemEnabledEvent;
import ch.e2e.builder.base.licensing.CheckLicenseEvent;
import ch.e2e.builder.base.licensing.LicenseValidator;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.swing.event.MenuEventObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.Icon;

public abstract class MenuObserver {
    protected Hashtable<String, ArrayList<MenuExecuter>> executerLists = new Hashtable();

    public MenuObserver() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject e) {
                AddMenuItemEvent event = (AddMenuItemEvent)e;
                MenuObserver.this.addMenuItem(event.getModule(), event.getMenuTree(), event.getIcon(), event.getEvent(), event.getIndex());
            }
        }, AddMenuItemEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject e) {
                AddMenuSeparatorEvent event = (AddMenuSeparatorEvent)e;
                MenuObserver.this.addMenuSeparator(event.getModule(), event.getMenuTree());
            }
        }, AddMenuSeparatorEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject e) {
                SetMenuEnabledEvent event = (SetMenuEnabledEvent)e;
                MenuObserver.this.setMenuEnabled(event.getModule(), event.getMenu(), event.isEnabled());
            }
        }, SetMenuEnabledEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject e) {
                SelectMenuItemEvent event = (SelectMenuItemEvent)e;
                MenuObserver.this.setItemSelected(event.getModule(), event.getMenuTree(), event.isSelected());
            }
        }, SelectMenuItemEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject e) {
                SetMenuItemEnabledEvent event = (SetMenuItemEnabledEvent)e;
                MenuObserver.this.setItemEnabled(event.getModule(), event.getMenuTree(), event.isEnabled());
            }
        }, SetMenuItemEnabledEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject e) {
                RegisterMenuEventEvent event = (RegisterMenuEventEvent)e;
                MenuObserver.this.registerMenuEvent(event.getModule(), event.getMenuKey(), event.getExecuter());
            }
        }, RegisterMenuEventEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                MenuObserver.this.doOnShow(((ModuleShownEvent)event).getModule());
            }
        }, ModuleShownEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                MenuObserver.this.doOnRelease(((ModuleReleasedEvent)event).getModule());
            }
        }, ModuleReleasedEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                MenuObserver.this.checkLicense();
            }
        }, CheckLicenseEvent.class);
    }

    protected abstract void setMenuEnabled(E2EBuilderModule var1, String var2, boolean var3);

    protected abstract void setItemEnabled(E2EBuilderModule var1, String[] var2, boolean var3);

    protected abstract void setItemSelected(E2EBuilderModule var1, String[] var2, boolean var3);

    protected abstract void checkLicense(LicenseValidator var1);

    protected abstract void addMenuItem(E2EBuilderModule var1, String[] var2, Icon var3, MenuEventObject var4, int var5);

    protected abstract void registerMenuEvent(E2EBuilderModule var1, String var2, EventExecuter var3);

    protected abstract void addMenuSeparator(E2EBuilderModule var1, String[] var2);

    protected void doOnShow(E2EBuilderModule module) {
        ArrayList<MenuExecuter> executers = this.executerLists.get(module.getName());
        if (executers != null) {
            for (MenuExecuter executer : executers) {
                EventController.register((EventExecuter)executer.executer, executer.event.getClass());
            }
        }
    }

    protected void doOnRelease(E2EBuilderModule module) {
        ArrayList<MenuExecuter> executers = this.executerLists.get(module.getName());
        if (executers != null) {
            for (MenuExecuter executer : executers) {
                EventController.unregister((EventExecuter)executer.executer, executer.event.getClass());
            }
        }
    }

    private void checkLicense() {
        this.checkLicense(LicenseValidator.getInstance());
    }

    protected class ToggledItem {
        public String[] itemNames;
        public boolean state;

        public ToggledItem(String[] itemNames, boolean state) {
            this.itemNames = itemNames;
            this.state = state;
        }
    }

    protected class RegisteredMenuExecuter {
        public String moduleName;
        public String menuKey;
        public EventExecuter executer;

        public RegisteredMenuExecuter(String moduleName, String menuKey, EventExecuter executer) {
            this.moduleName = moduleName;
            this.menuKey = menuKey;
            this.executer = executer;
        }
    }

    protected class Separator {
        public String moduleName;
        public String[] menuNames;

        public Separator(String moduleName, String[] menuNames) {
            this.moduleName = moduleName;
            this.menuNames = menuNames;
        }
    }

    protected class MenuElement {
        public String moduleName;
        public String[] itemNames;
        public Icon icon;
        public MenuEventObject event;
        public int index;

        public MenuElement(String moduleName, String[] itemNames, Icon icon, MenuEventObject event, int index) {
            this.moduleName = moduleName;
            this.itemNames = itemNames;
            this.icon = icon;
            this.event = event;
            this.index = index;
        }
    }

    protected class MenuExecuter {
        protected EventExecuter executer;
        protected MenuEventObject event;

        public MenuExecuter(MenuEventObject event, EventExecuter executer) {
            this.event = event;
            this.executer = executer;
        }
    }
}

