/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.ldap.wrapper;

import ch.e2e.bridge.server.CyclicDependencyException;
import ch.e2e.bridge.server.Wrapper;
import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.ldap.parameter.LDAPDirEntry;
import ch.e2e.bridge.server.ldap.wrapper.LDAPAttributeWrapper;
import ch.e2e.bridge.server.session.Session;
import java.util.ArrayList;
import javax.naming.directory.Attribute;

public class LDAPDirEntryWrapper
extends Wrapper {
    private static final Class originalClass = LDAPDirEntry.class;
    private boolean fill = false;
    private ArrayList<Attribute> attributes;

    public LDAPDirEntryWrapper(RecordItem recordItem, Session session) {
        super(recordItem, session);
    }

    public LDAPDirEntryWrapper(Session session) {
        super(session);
    }

    @Override
    public void fill(Object object) {
        if (object != null) {
            if (this.fill) {
                throw new CyclicDependencyException(originalClass);
            }
            this.fill = true;
            LDAPDirEntry dirEntry = (LDAPDirEntry)object;
            this.setDn(dirEntry.getDn());
            this.setAttributes(dirEntry.getAttributes());
            this.fill = false;
        }
    }

    @Override
    public Object createObject() {
        return new LDAPDirEntry(this.getDn(), this.getAttributes());
    }

    @Override
    protected String getFullQualifiedModelName() {
        return "urn:Base_Components.Add_Ons.LDAP.LDAPEntry";
    }

    private String getDn() {
        StringItem stringItem = this.getRecordItem().getStringItem(0);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setDn(String dn) {
        this.setValue(0, dn);
    }

    private ArrayList<Attribute> getAttributes() {
        if (this.attributes == null) {
            ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(1);
            this.attributes = (ArrayList)arrayItem.fillArrayClass(ArrayList.class, LDAPAttributeWrapper.class);
        }
        return this.attributes;
    }

    private void setAttributes(ArrayList<Attribute> attributes) {
        this.attributes = attributes;
        ArrayItem arrayItem = this.getRecordItem().getArrayItemCreateIfNotExists(1);
        arrayItem.setValues(attributes, LDAPAttributeWrapper.class);
    }
}

