/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.dataitem.BlobItem;
import ch.e2e.bridge.server.dataitem.Item;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.impl.BaseSynchronAction;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapter;
import ch.e2e.bridge.server.jms.impl.JMSAddOnHelper;
import ch.e2e.bridge.server.jms.impl.MessageReceiver;
import ch.e2e.bridge.server.jms.parameter.JMSMessageType;
import ch.e2e.bridge.server.jms.parameter.JMSReceiveParameter;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import ch.e2e.bridge.server.jms.parameter.JMSWrapperException;
import ch.e2e.bridge.server.jms.wrapper.JMSBytesMessageWrapper;
import ch.e2e.bridge.server.jms.wrapper.JMSReceiveParameterWrapper;
import ch.e2e.bridge.server.jms.wrapper.JMSTextMessageWrapper;
import ch.e2e.bridge.server.session.Session;
import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;
import javax.jms.Message;

public class ReceiveMessageAction
extends BaseSynchronAction {
    private JMSReceiveParameter receiveParameter;

    public ReceiveMessageAction(JMSMessageType messageType, JMSSessionParameter sessionParameter, JMSReceiveParameter receiveParameter) {
        super(messageType, sessionParameter);
        this.receiveParameter = receiveParameter;
    }

    @Override
    protected boolean execute(RecordItem inputItem, RecordItem outputItem, JMSSessionParameter sessionParameter) throws Exception {
        JMSReceiveParameter localReceiveParameter;
        sessionParameter.getSession().logEnter(3L, true, "JAVA", "ReceiveMessageAction.execute", sessionParameter.getConnectionInfo().getURL());
        if (this.receiveParameter == null) {
            localReceiveParameter = (JMSReceiveParameter)sessionParameter.getSession().createObject((RecordItem)inputItem.getItem(1L), JMSReceiveParameterWrapper.class);
        } else {
            localReceiveParameter = this.receiveParameter;
            localReceiveParameter.merge((RecordItem)inputItem.getItem(1L));
        }
        Message resultMessage = this.receiveMessage(localReceiveParameter, sessionParameter);
        if (resultMessage == null) {
            throw new JMSWrapperException("No message received");
        }
        JMSLogger.getInstance().debug("2", "JMS message received" + resultMessage.toString());
        Item resultItem = ReceiveMessageAction.createResultItem(sessionParameter.getSession(), resultMessage, this.getMessageType());
        outputItem.addItem(resultItem);
        sessionParameter.getSession().logExit(3L, true, "JAVA", this.receiveDescription(resultMessage), sessionParameter.getConnectionInfo().getURL(), resultMessage.getJMSMessageID());
        return true;
    }

    private String receiveDescription(Message message) throws JMSException {
        String transactionId = message.getStringProperty("xTransactionId");
        String senderHost = message.getStringProperty("xSenderHost");
        String senderService = message.getStringProperty("xSenderService");
        String correlationId = message.getJMSCorrelationID();
        return String.format("ReceiveMessageAction.execute|%s|%s|%s|%s", ReceiveMessageAction.toDescriptionPart(transactionId), ReceiveMessageAction.toDescriptionPart(senderHost), ReceiveMessageAction.toDescriptionPart(senderService), ReceiveMessageAction.toDescriptionPart(correlationId));
    }

    private static String toDescriptionPart(String text) {
        return text == null || text.isEmpty() ? "-" : text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveMessage(JMSReceiveParameter input, JMSSessionParameter sessionParameter) throws Exception {
        Message result;
        block8: {
            byte[] byArray;
            Session session;
            String destinationName = input.getDestinationName();
            ConnectionAdapter connection = this.borrowConnection(sessionParameter);
            MessageReceiver receiver = null;
            try {
                receiver = connection.getReceiver(sessionParameter.getSession().getSessionId());
            }
            finally {
                this.returnConnection(sessionParameter, connection);
            }
            result = null;
            if (receiver == null) break block8;
            sessionParameter.getSession().dumpIOEntry(sessionParameter.getConnectionInfo().getURL(), input.toString(), new byte[0]);
            try {
                result = receiver.receive(destinationName, input.getSelector(), input.getMillisecondsToWait());
                session = sessionParameter.getSession();
                byArray = result == null ? new byte[]{} : result.toString().getBytes();
            }
            catch (JMSException e) {
                try {
                    connection.removeJMSSession(sessionParameter.getSession().getSessionId());
                    throw e;
                }
                catch (Throwable throwable) {
                    sessionParameter.getSession().dumpIOExit(result == null ? new byte[]{} : result.toString().getBytes());
                    throw throwable;
                }
            }
            session.dumpIOExit(byArray);
            JMSLogger.getInstance().debug("2", "JMS message received: " + result);
        }
        return result;
    }

    public static Item createResultItem(Session session, Message resultMessage, int messageType) throws JMSException, UnsupportedEncodingException {
        Item resultItem = null;
        if (messageType == 3) {
            JMSTextMessageWrapper jmsTextMessageWrapper = new JMSTextMessageWrapper(session);
            jmsTextMessageWrapper.assignHeaderFromMessage(resultMessage);
            jmsTextMessageWrapper.assignBodyFromMessage(resultMessage);
            resultItem = jmsTextMessageWrapper.getRecordItem();
        } else if (messageType == 1) {
            StringItem resultStringItem = ItemFactory.createStringItem(session);
            resultStringItem.setValueFromString(JMSAddOnHelper.getText(resultMessage));
            resultItem = resultStringItem;
        } else if (messageType == 4) {
            JMSBytesMessageWrapper jmsBytesMessageWrapper = new JMSBytesMessageWrapper(session);
            jmsBytesMessageWrapper.assignHeaderFromMessage(resultMessage);
            jmsBytesMessageWrapper.assignBodyFromMessage(resultMessage);
            resultItem = jmsBytesMessageWrapper.getRecordItem();
        } else if (messageType == 2) {
            BlobItem resultBlobItem = ItemFactory.createBlobItem(session);
            resultBlobItem.setValueFromByteArray(JMSAddOnHelper.getBytes(resultMessage));
            resultItem = resultBlobItem;
        }
        return resultItem;
    }
}

