/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.testsuite;

import ch.e2e.builder.regtest.model.TreePathElement;
import ch.e2e.builder.regtest.testsuite.TreeTestSuite;
import ch.e2e.test.OptionContainer;
import ch.e2e.test.TestType;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TestSuiteOptions
implements TreePathElement {
    public static final int TESTSUITE_OPTIONS = 500;
    private TreeTestSuite parent;
    private Map<TestType, OptionContainer> options;
    private Set<TestType> keys;

    public TestSuiteOptions(TreeTestSuite parent, Map<TestType, OptionContainer> options) {
        this.parent = parent;
        this.options = options;
        this.keys = new TreeSet<TestType>(options.keySet());
    }

    public TreeTestSuite getParent() {
        return this.parent;
    }

    public Set<TestType> getKeys() {
        return this.keys;
    }

    public int size() {
        return this.keys.size();
    }

    public OptionContainer get(TestType key) {
        return this.options.get(key);
    }

    public void put(TestType key, OptionContainer value) {
        this.keys.add(key);
        this.options.put(key, value);
    }

    public void remove(OptionContainer optionContainer) {
        this.keys.remove(optionContainer.getType());
        this.options.remove(optionContainer.getType());
    }

    public Object getChild(int index) {
        return this.options.get(this.keys.toArray(new TestType[this.keys.size()])[index]);
    }

    public int getChildCount() {
        return this.keys.size();
    }

    public int getIndexOfChild(Object child) {
        return 0;
    }

    public boolean isLeaf() {
        return this.options.size() == 0;
    }

    public int getType() {
        return 500;
    }

    @Override
    public Object getTreeParent() {
        return this.getParent();
    }

    @Override
    public boolean isDescendant(TreePathElement element) {
        if (element != null) {
            Object parent = element.getTreeParent();
            while (parent instanceof TreePathElement) {
                if (this.equals(parent)) {
                    return true;
                }
                parent = ((TreePathElement)parent).getTreeParent();
            }
        }
        return false;
    }

    public String toString() {
        return "Options";
    }
}

