/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.application.E2EBuilder;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.base.resource.E2EBuilderTranslator;
import ch.e2e.builder.regtest.event.NameChangedEvent;
import ch.e2e.builder.regtest.event.NameChangedListener;
import ch.e2e.builder.regtest.gui.swing.OptionComponent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedEvent;
import ch.e2e.builder.regtest.gui.swing.OptionInputChangedListener;
import ch.e2e.builder.regtest.gui.swing.OptionPanel;
import ch.e2e.test.ResultCompare;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JPanel;

public class TestPreferencesPanel
extends JPanel {
    private OptionPanel options;
    private ResultCompare compare;
    private NameChangedListener nameListener;

    public TestPreferencesPanel(Dialog parent, E2EBuilderModule module) {
        this.createGui(parent, module);
    }

    public void persist(boolean forced) {
        this.options.persist(forced);
    }

    public HashMap<String, OptionComponent> setResultCompare(ResultCompare compare, boolean readOnly, boolean setDefaultValue) {
        this.compare = compare;
        HashMap<String, OptionComponent> result = this.options.setOptions(compare.getOptions().values(), compare.getAdvancedOptions().values(), readOnly, setDefaultValue);
        OptionComponent nameComponent = result.get("key.option.result.compare.name");
        if (nameComponent != null) {
            nameComponent.addOptionChangedListener(new OptionInputChangedListener(){

                @Override
                public void optionChanged(OptionInputChangedEvent event) {
                    if (TestPreferencesPanel.this.nameListener != null) {
                        String newName = event.getValue().toString();
                        TestPreferencesPanel.this.nameListener.nameChanged(new NameChangedEvent(TestPreferencesPanel.this, newName));
                        TestPreferencesPanel.this.compare.setName(newName);
                    }
                }
            });
        }
        return result;
    }

    public void setNameChangedListener(NameChangedListener nameListener) {
        this.nameListener = nameListener;
    }

    private void createGui(Dialog parent, E2EBuilderModule module) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 5, 2, 5);
        c.anchor = 18;
        c.fill = 2;
        this.options = new OptionPanel(parent, E2EBuilder.getInstance().getE2EBuilderLogo(), E2EBuilderTranslator.getTranslator((String)module.getName()));
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.options, c);
    }
}

