/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.regtest.gui;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.regtest.event.TestUnitFinishedEvent;
import ch.e2e.builder.regtest.event.TestUnitStartEvent;
import ch.e2e.builder.regtest.gui.DiffPane;
import ch.e2e.builder.regtest.gui.ErrorTreeView;
import ch.e2e.builder.regtest.gui.HierarchyView;
import ch.e2e.event.EventController;
import ch.e2e.event.EventExecuter;
import ch.e2e.test.E2ETestcase;
import ch.e2e.test.TestSelectedEvent;
import com.jidesoft.swing.JideTabbedPane;
import java.util.EventObject;
import javax.swing.event.TreeSelectionListener;

public class SelectedTestView
extends JideTabbedPane {
    private HierarchyView hierarchyView;
    private ErrorTreeView errorTreeView;
    private boolean running = false;
    private boolean runCalled = false;

    public SelectedTestView(E2EBuilderModule module, TreeSelectionListener treeListener, DiffPane diffPane) {
        this.createGui(module, treeListener, diffPane);
        this.addEventhandler();
    }

    private void createGui(E2EBuilderModule module, TreeSelectionListener treeListener, DiffPane diffPane) {
        this.hierarchyView = new HierarchyView(module, treeListener);
        this.addTab(module.getTranslation("test.view.hierarchy.tab"), this.hierarchyView);
        this.errorTreeView = new ErrorTreeView(module, diffPane);
        this.addTab(module.getTranslation("test.view.error.tab"), this.errorTreeView);
    }

    private void addEventhandler() {
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                SelectedTestView.this.testUnitStarting((TestUnitStartEvent)event);
            }
        }, TestUnitStartEvent.class);
        EventController.register((EventExecuter)new EventExecuter(){

            public void execute(EventObject event) {
                SelectedTestView.this.testUnitFinished((TestUnitFinishedEvent)event);
            }
        }, TestUnitFinishedEvent.class);
    }

    private void testUnitFinished(TestUnitFinishedEvent event) {
        this.running = false;
        this.setEnabledAt(0, true);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled && !this.running && this.runCalled) {
            this.runCalled = false;
            this.errorTreeView.fireTestcaseSelected();
        }
    }

    public void testUnitStarting(TestUnitStartEvent event) {
        this.running = true;
        this.runCalled = true;
        this.setEnabled(true);
        this.errorTreeView.setEnabled(true);
        this.setSelectedIndex(1);
        this.setEnabledAt(0, false);
    }

    public void testSelected(TestSelectedEvent event) {
        this.hierarchyView.testSelected(event);
        this.errorTreeView.testSelected(event);
    }

    public void clear() {
        this.hierarchyView.clear();
        this.errorTreeView.clear();
    }

    public void refresh(E2ETestcase testcase) {
        this.hierarchyView.refresh(testcase);
        this.errorTreeView.refresh(testcase);
    }
}

