/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.util;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public abstract class ActionKeysManager {
    private Map<String, KeyBinding> bindings = new HashMap<String, KeyBinding>();
    private Map<String, Action> actionsByName = new HashMap<String, Action>();

    public void loadInputMap(InputMap map) {
        for (KeyBinding b : this.bindings.values()) {
            map.put(b.key, b.actionName);
        }
    }

    public Action getActionByName(String actionName) {
        return this.actionsByName.get(actionName);
    }

    public void setActions(Action[] actions) {
        for (Action a : actions) {
            String name = (String)a.getValue("Name");
            if (name == null) continue;
            this.actionsByName.put(name, a);
        }
        for (Map.Entry entry : this.bindings.entrySet()) {
            Action a = this.actionsByName.get(entry.getKey());
            if (a == null) continue;
            KeyBinding b = (KeyBinding)entry.getValue();
            if (b.key != null) {
                a.putValue("AcceleratorKey", b.key);
            }
            if (b.mnemonicKey == null) continue;
            a.putValue("MnemonicKey", b.mnemonicKey);
        }
    }

    protected void addBinding(KeyStroke key, Integer mnemonicKey, String actionName) {
        this.bindings.put(actionName, new KeyBinding(key, mnemonicKey, actionName));
    }

    private class KeyBinding {
        KeyStroke key;
        Integer mnemonicKey;
        String actionName;

        KeyBinding(KeyStroke key, Integer mnemonicKey, String actionName) {
            this.key = key;
            this.mnemonicKey = mnemonicKey;
            this.actionName = actionName;
        }
    }
}

