/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.swing.ModalDialog;
import ch.e2e.swing.MouseOverButton;
import ch.e2e.swing.QuestionDialog;
import ch.e2e.swing.event.DirectoryActionEvent;
import ch.e2e.swing.event.DirectoryActionListener;
import ch.e2e.swing.filechooser.BigDirectoryButtonPanel;
import ch.e2e.swing.filechooser.DirectoryComboBox;
import ch.e2e.swing.filechooser.DirectoryTree;
import ch.e2e.swing.filechooser.FileChooserIcons;
import ch.e2e.swing.filechooser.FileList;
import ch.e2e.swing.filechooser.NewDirectoryDialog;
import ch.e2e.swing.filechooser.SmallDirectoryButtonPanel;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.model.DirectoryTreeModelExtension;
import ch.e2e.swing.model.FileListModelExtension;
import ch.e2e.swing.util.FileChooserFilter;
import ch.e2e.util.StringTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;

public abstract class FileDialog
extends ModalDialog
implements DirectoryActionListener,
FileChooserIcons,
ListSelectionListener {
    public static int MULTIPLE_SELECTION = 2;
    public static int SINGLE_SELECTION = 0;
    protected DirectoryComboBox directoryComboBox;
    protected DirectoryTree directoryTree;
    protected BigDirectoryButtonPanel bigButtons;
    protected SmallDirectoryButtonPanel smallButtons;
    protected FileList fileList;
    protected AllFilesFilter allFilesFilter = new AllFilesFilter();
    protected FileListModelExtension listModelExtension;
    private NewDirectoryDialog newDirectoryDialog;
    private QuestionDialog questionDialog;
    private JLabel directoryComboBoxLabel;
    private JSplitPane treeAndList;

    public FileDialog(JDialog owner, String title, String internalTitle, String subtitle) {
        super(owner, title, internalTitle, subtitle, 3);
        this.initialize();
    }

    public FileDialog(Frame owner, String title, String internalTitle, String subtitle) {
        super(owner, title, internalTitle, subtitle, 3);
        this.initialize();
    }

    public FileDialog(JDialog owner, String title, String internalTitle, String subtitle, Icon icon) {
        super((Dialog)owner, title, internalTitle, subtitle, icon, 3);
        this.initialize();
    }

    public FileDialog(Frame owner, String title, String internalTitle, String subtitle, Icon icon) {
        super(owner, title, internalTitle, subtitle, icon, 3);
        this.initialize();
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.directoryComboBoxLabel != null && !this.getLocale().equals(locale)) {
            String key = this.getDirectoryComboBoxLabel();
            this.directoryComboBoxLabel.setText(translator.getTranslation(key, key));
        }
    }

    public void resetSelection() {
        this.fileList.setSelectedIndices(new int[0]);
    }

    public File getSelectedDirectory() {
        return this.directoryComboBox.getSelectedDirectory().getDir();
    }

    @Override
    public void deleteDirectory(DirectoryActionEvent event) {
        String question;
        if (this.questionDialog == null) {
            this.questionDialog = new QuestionDialog(this, 0);
            this.questionDialog.setLocale(this.getLocale());
            this.questionDialog.setQuestionForeground(new Color(102, 0, 0));
            this.questionDialog.setQuestionFont(new Font("Dialog", 1, 12));
            this.questionDialog.setQuestionLineHeight(23);
        }
        String translation = translator.getTranslation("delete.directory.internaltitle");
        String absolutePath = event.getDirectory().getDir().getAbsolutePath();
        String internalTitle = StringTools.replaceProperty((String)translation, (String)"file", (String)absolutePath);
        boolean answer = this.questionDialog.doQuestion(internalTitle, "", question = StringTools.replaceProperty((String)(translation = translator.getTranslation("delete.directory.question")), (String)"file", (String)absolutePath));
        if (answer) {
            this.directoryComboBox.setSelectedDirectory(event.getDirectory().getParent());
            event.getDirectory().getDir().delete();
            this.reload();
        }
    }

    protected File createNewDirectory(File parent) {
        File newDirectory;
        if (this.newDirectoryDialog == null) {
            this.newDirectoryDialog = new NewDirectoryDialog(this);
            this.newDirectoryDialog.setLocale(this.getLocale());
        }
        if ((newDirectory = this.newDirectoryDialog.getNewDirectory(parent)) != null && !newDirectory.exists()) {
            newDirectory.mkdirs();
            this.directoryTree.refresh();
        }
        return newDirectory;
    }

    @Override
    public int showDialog() {
        Directory.getRoot().reset();
        if (this.treeAndList != null) {
            this.treeAndList.resetToPreferredSizes();
        }
        int result = super.showDialog();
        Directory.getRoot().reset();
        return result;
    }

    public void doOk() {
        this.okDialog();
    }

    public void doCancel() {
        this.cancelDialog();
    }

    public void setFileListModelExtension(FileListModelExtension listModelExtension) {
        this.listModelExtension = listModelExtension;
        this.fileList.setModelExtension(listModelExtension);
    }

    public void setTreeModelExtension(DirectoryTreeModelExtension treeModelExtension) {
        this.directoryTree.setModelExtension(treeModelExtension);
    }

    public MouseOverButton addSmallButton(Icon icon, ActionListener action) {
        return this.smallButtons.addButton(icon, action);
    }

    public MouseOverButton addSmallButton(Icon icon, File directory) {
        return this.smallButtons.addButton(icon, directory);
    }

    public MouseOverButton addBigButton(Icon icon, ActionListener action) {
        return this.bigButtons.addButton(icon, action);
    }

    public MouseOverButton addBigButton(Icon icon, File directory) {
        return this.bigButtons.addButton(icon, directory);
    }

    public int getDividerLocation() {
        return this.treeAndList.getDividerLocation();
    }

    public void setDividerLocation(int dividerLocation) {
        this.treeAndList.setDividerLocation(dividerLocation);
    }

    protected abstract String getDirectoryComboBoxLabel();

    protected DirectoryTree addTree(GridBagConstraints c) {
        this.treeAndList = new JSplitPane(1);
        this.treeAndList.setResizeWeight(0.5);
        this.treeAndList.setDividerSize(3);
        this.treeAndList.setDividerLocation(0.5);
        DirectoryTree directoryTree = new DirectoryTree();
        this.treeAndList.setLeftComponent(directoryTree);
        this.fileList = new FileList();
        this.treeAndList.setRightComponent(this.fileList);
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)this.treeAndList, c);
        return directoryTree;
    }

    protected void addEventHandler() {
        this.addAwtEventHandler();
        this.addBigButtonsEventHandler();
        this.addSmallButtonsEventHandler();
        this.addDirectoryComboBoxEventHandler();
        this.addDirectoryTreeEventHandler();
        this.addFileListEventHandler();
    }

    protected void componentShown() {
        this.directoryTree.scrollPathToVisible();
    }

    protected void reload() {
        this.directoryTree.refresh();
        this.fileList.reload();
    }

    protected GridBagConstraints createGui() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints c = new GridBagConstraints();
        this.addFirstRow(c);
        this.bigButtons = new BigDirectoryButtonPanel();
        c.gridwidth = 1;
        c.gridheight = 0;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.bigButtons, c);
        this.directoryTree = this.addTree(c);
        return c;
    }

    private void initialize() {
        this.createGui();
        this.addEventHandler();
    }

    private void addFirstRow(GridBagConstraints c) {
        JPanel cbAndButtons = new JPanel(new BorderLayout());
        c.anchor = 13;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 5, 5);
        this.directoryComboBoxLabel = new JLabel(translator.getTranslation(this.getDirectoryComboBoxLabel()));
        this.add((Component)this.directoryComboBoxLabel, c);
        this.directoryComboBox = new DirectoryComboBox();
        cbAndButtons.add((Component)this.directoryComboBox, "Center");
        this.smallButtons = new SmallDirectoryButtonPanel(13);
        cbAndButtons.add((Component)this.smallButtons, "East");
        c.fill = 2;
        c.anchor = 17;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 5, 0);
        this.add((Component)cbAndButtons, c);
    }

    private void addDirectoryTreeEventHandler() {
        this.directoryTree.addDirectorySelectedListener(this.directoryComboBox);
        this.directoryTree.addDirectorySelectedListener(this.smallButtons);
        this.directoryTree.addDirectorySelectedListener(this.bigButtons);
        this.directoryTree.addDirectorySelectedListener(this.fileList);
    }

    private void addDirectoryComboBoxEventHandler() {
        this.directoryComboBox.addDirectorySelectedListener(this.bigButtons);
        this.directoryComboBox.addDirectorySelectedListener(this.directoryTree);
        this.directoryComboBox.addDirectorySelectedListener(this.smallButtons);
        this.directoryComboBox.addDirectorySelectedListener(this.fileList);
    }

    private void addSmallButtonsEventHandler() {
        this.smallButtons.addDirectorySelectedListener(this.bigButtons);
        this.smallButtons.addDirectorySelectedListener(this.directoryComboBox);
        this.smallButtons.addDirectorySelectedListener(this.directoryTree);
        this.smallButtons.addDirectoryActionListener(this);
        this.smallButtons.addDirectorySelectedListener(this.fileList);
    }

    private void addBigButtonsEventHandler() {
        this.bigButtons.addDirectorySelectedListener(this.smallButtons);
        this.bigButtons.addDirectorySelectedListener(this.directoryComboBox);
        this.bigButtons.addDirectorySelectedListener(this.directoryTree);
        this.bigButtons.addDirectorySelectedListener(this.fileList);
    }

    private void addFileListEventHandler() {
        this.fileList.addDirectorySelectedListener(this.directoryComboBox);
        this.fileList.addDirectorySelectedListener(this.directoryTree);
        this.fileList.addDirectorySelectedListener(this.bigButtons);
        this.fileList.addDirectorySelectedListener(this.smallButtons);
        this.fileList.addListSelectionListener(this);
    }

    private void addAwtEventHandler() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                FileDialog.this.componentShown();
            }
        });
        this.addWindowListener(new WindowAdapter(){
            private boolean first = true;

            @Override
            public void windowActivated(WindowEvent event) {
                if (this.first) {
                    this.first = false;
                } else {
                    FileDialog.this.reload();
                }
            }
        });
    }

    @Override
    public int getMinimumWidth() {
        int defaultMinimumWidth = 2 * (this.getOwner().getBounds().width / 5);
        return Math.max(defaultMinimumWidth, super.getMinimumWidth());
    }

    static {
        translator.addMap("ch.e2e.swing.filechooser.filechooser");
    }

    protected class AllFilesFilter
    extends FileChooserFilter {
        protected AllFilesFilter() {
        }

        @Override
        public boolean acceptFile(File file) {
            return true;
        }

        @Override
        public String getDescription() {
            return translator.getTranslation("allfiles.filter");
        }
    }
}

