/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.swing.filechooser;

import ch.e2e.gui.event.InputFieldEvent;
import ch.e2e.gui.event.InputFieldListener;
import ch.e2e.swing.MouseOverButton;
import ch.e2e.swing.event.DirectoryActionEvent;
import ch.e2e.swing.filechooser.FileDialog;
import ch.e2e.swing.filechooser.FileFilterComboBox;
import ch.e2e.swing.filechooser.FileTextField;
import ch.e2e.swing.filechooser.FilenameField;
import ch.e2e.swing.model.Directory;
import ch.e2e.swing.util.FileChooserFilter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;

public class FileChooser
extends FileDialog
implements InputFieldListener {
    protected FileTextField fileTextField;
    protected FileFilterComboBox filterComboBox;
    protected File selectedFile;
    private MouseOverButton showFoldersButton;
    private JLabel filename;
    private JLabel fileType;

    public FileChooser(JFrame owner, String title, String internalTitle, String subtitle) {
        super((Frame)owner, title, internalTitle, subtitle);
    }

    public FileChooser(JDialog owner, String title, String internalTitle, String subtitle) {
        super(owner, title, internalTitle, subtitle);
    }

    public FileChooser(JFrame owner, String title, String internalTitle, String subtitle, Icon icon) {
        super((Frame)owner, title, internalTitle, subtitle, icon);
    }

    public FileChooser(JDialog owner, String title, String internalTitle, String subtitle, Icon icon) {
        super(owner, title, internalTitle, subtitle, icon);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.filename != null && !this.getLocale().equals(locale)) {
            String key = "filechooser.filename";
            this.filename.setText(translator.getTranslation(key, key));
            key = "filechooser.filetype";
            this.fileType.setText(translator.getTranslation(key, key));
        }
    }

    @Override
    public void createNewDirectory(DirectoryActionEvent event) {
        File newDirectory = this.createNewDirectory(event.getDirectory().getDir());
        if (newDirectory != null) {
            this.directoryComboBox.setSelectedDirectory(newDirectory);
            this.directoryTree.scrollPathToVisible();
        }
    }

    public File[] selectFiles() {
        return this.selectFiles(new File("").getAbsoluteFile());
    }

    public File[] selectFiles(File startDir) {
        return this.selectFiles(startDir, true);
    }

    public File[] selectFiles(File startDir, boolean includeAllFiles) {
        if (includeAllFiles || this.filterComboBox.getFileFilterCount() == 0) {
            this.filterComboBox.addFileFilter(this.allFilesFilter);
        }
        this.setOkButtonEnabled(false);
        this.setSelectionMode(MULTIPLE_SELECTION);
        startDir = this.getStartDir(startDir);
        this.directoryComboBox.setSelectedDirectory(startDir);
        this.fileList.setSelectedIndices(new int[0]);
        int ret = this.showDialog();
        if (ret == 1) {
            return this.fileTextField.getFiles();
        }
        return null;
    }

    public File selectFile() {
        return this.selectFile(new File("").getAbsoluteFile());
    }

    public File selectFile(File selectedFile) {
        return this.selectFile(selectedFile, true);
    }

    public File selectFile(File selectedFile, boolean includeAllFiles) {
        this.doStartup(selectedFile, includeAllFiles);
        int ret = this.showDialog();
        if (ret == 1) {
            return this.fileTextField.getFiles().length == 0 ? null : this.fileTextField.getFiles()[0];
        }
        return null;
    }

    public FileChooserFilter getSelectedFileFilter() {
        return (FileChooserFilter)this.filterComboBox.getSelectedItem();
    }

    @Override
    public void inputFieldChanged(InputFieldEvent event) {
        this.setOkButtonEnabled(this.fileTextField.getText().length() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (this.fileList.getSelectedValues().length > 0) {
            if (this.fileList.getSelectedValues()[0] instanceof Directory) {
                Directory dir = (Directory)this.fileList.getSelectedValues()[0];
                this.setOkButtonEnabled(this.listModelExtension == null || this.listModelExtension.isSelectable(dir.getDir()));
            } else {
                File file = (File)this.fileList.getSelectedValues()[0];
                this.setOkButtonEnabled(this.listModelExtension == null || this.listModelExtension.isSelectable(file));
            }
        }
    }

    public void setFileFilter(FileChooserFilter[] fileFilter) {
        if (fileFilter.length == 0) {
            this.filterComboBox.setFileFilter(new FileChooserFilter[]{this.allFilesFilter});
        } else {
            this.filterComboBox.setFileFilter(fileFilter);
        }
        this.filterComboBox.setSelectedIndex(0);
    }

    public void setSelectionMode(int selectionMode) {
        this.fileList.setSelectionMode(selectionMode);
        ((FilenameField)this.fileTextField).setSelectionMode(selectionMode);
    }

    @Override
    protected boolean doOnOk() {
        boolean result;
        if (this.fileList.getSelectedValues().length > 0 && this.fileList.getSelectedValues()[0] instanceof Directory) {
            Directory dir = (Directory)this.fileList.getSelectedValues()[0];
            this.directoryComboBox.setSelectedDirectory(dir);
            this.setOkButtonEnabled(false);
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    protected void doStartup(File selectedFile, boolean includeAllFiles) {
        if (includeAllFiles || this.filterComboBox.getFileFilterCount() == 0) {
            this.filterComboBox.addFileFilter(this.allFilesFilter);
        }
        this.setSelectionMode(SINGLE_SELECTION);
        File startDir = this.getStartDir(selectedFile);
        this.directoryComboBox.setSelectedDirectory(startDir);
        if ((selectedFile.isFile() || !selectedFile.exists()) && startDir.equals(selectedFile.getParentFile())) {
            this.selectedFile = selectedFile;
            this.fileList.setSelectedFiles(new File[]{selectedFile});
            this.setOkButtonEnabled(true);
        } else {
            this.selectedFile = null;
            this.fileList.setSelectedIndices(new int[0]);
            this.setOkButtonEnabled(false);
        }
    }

    @Override
    protected GridBagConstraints createGui() {
        GridBagConstraints c = super.createGui();
        this.fileTextField = this.addFileTextField(c);
        this.fileTextField.addInputFieldListener(this);
        this.showFoldersButton = this.addSmallButton((Icon)showFoldersIcon, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileChooser.this.doShowFoldersAction();
            }
        });
        this.showFoldersButton.setPressed(true, true);
        return c;
    }

    @Override
    protected String getDirectoryComboBoxLabel() {
        return "filechooser.selectfrom";
    }

    protected FileTextField addFileTextField(GridBagConstraints c) {
        JPanel filterPanel = new JPanel(new GridBagLayout());
        String key = "filechooser.filename";
        this.filename = new JLabel(translator.getTranslation(key, key));
        c.insets = new Insets(5, 0, 0, 5);
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 0.4;
        filterPanel.add((Component)this.filename, c);
        FilenameField fileTextField = new FilenameField();
        c.weightx = 0.7;
        c.fill = 2;
        c.anchor = 17;
        filterPanel.add((Component)fileTextField, c);
        c.weightx = 0.5;
        c.gridwidth = 0;
        filterPanel.add((Component)new JLabel(""), c);
        key = "filechooser.filetype";
        this.fileType = new JLabel(translator.getTranslation(key, key));
        c.gridwidth = 1;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 0.4;
        filterPanel.add((Component)this.fileType, c);
        this.filterComboBox = new FileFilterComboBox();
        c.weightx = 0.7;
        c.fill = 2;
        c.anchor = 17;
        filterPanel.add((Component)this.filterComboBox, c);
        c.weightx = 0.5;
        c.gridwidth = 0;
        filterPanel.add((Component)new JLabel(""), c);
        c.anchor = 10;
        c.weighty = 0.0;
        this.add((Component)filterPanel, c);
        return fileTextField;
    }

    @Override
    protected void addEventHandler() {
        super.addEventHandler();
        this.fileList.addFileSelectedListener((FilenameField)this.fileTextField);
        this.fileList.addDirectorySelectedListener(this.fileTextField);
        ((FilenameField)this.fileTextField).addFileSelectedListener(this.fileList);
        this.filterComboBox.addFileFilterListener(this.fileList);
        this.fileList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileChooser.this.okDialog();
            }
        });
        this.fileTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileChooser.this.okDialog();
            }
        });
        this.directoryTree.addDirectorySelectedListener(this.fileTextField);
        this.directoryComboBox.addDirectorySelectedListener(this.fileTextField);
        this.smallButtons.addDirectorySelectedListener(this.fileTextField);
        this.bigButtons.addDirectorySelectedListener(this.fileTextField);
    }

    @Override
    protected void componentShown() {
        super.componentShown();
        this.filterComboBox.setSelectedIndex(0);
        ((FilenameField)this.fileTextField).setFiles(new File[]{this.selectedFile});
    }

    private void doShowFoldersAction() {
        boolean pressed = !this.showFoldersButton.isPressed();
        this.showFoldersButton.setPressed(pressed, true);
        this.fileList.setIncludeDirectories(pressed);
    }

    private File getStartDir(File selectedFile) {
        File startDir = selectedFile.isFile() ? selectedFile.getParentFile() : selectedFile;
        for (startDir = startDir.getAbsoluteFile(); startDir != null && !startDir.exists(); startDir = startDir.getParentFile()) {
        }
        if (startDir == null) {
            startDir = new File("");
        }
        return startDir;
    }
}

