/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.base.message;

import ch.e2e.resource.ImageLoader;
import ch.e2e.resource.Properties;
import ch.e2e.swing.MessageType;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;

public class MessageTypesPool {
    private static MessageTypesPool pool = new MessageTypesPool();
    private MessageType defaultType;
    private Hashtable<String, MessageType> messageTypes = new Hashtable();
    private Hashtable<String, Hashtable<String, MessageType>> moduleTables = new Hashtable();

    private MessageTypesPool() {
        this.defaultType = new MessageType();
        this.defaultType.type = "default";
    }

    public static MessageType getMessageType(String moduleName, String type) {
        MessageType messageType = null;
        if (moduleName != null) {
            Hashtable<String, MessageType> moduleMessageTypes = MessageTypesPool.pool.moduleTables.get(moduleName);
            if (moduleMessageTypes != null && type != null) {
                messageType = moduleMessageTypes.get(type);
            }
            if (messageType == null && type != null) {
                messageType = MessageTypesPool.pool.messageTypes.get(type);
            }
        }
        return messageType == null ? MessageTypesPool.pool.defaultType : messageType;
    }

    public static void registerMessageTypes(String moduleName, Properties types) {
        Hashtable<String, MessageType> moduleMessageTypes = new Hashtable<String, MessageType>();
        MessageTypesPool.pool.moduleTables.put(moduleName, moduleMessageTypes);
        pool.addProperties(types, moduleMessageTypes);
    }

    private void addProperties(Properties types, Hashtable<String, MessageType> typeTable) {
        Enumeration keys = types.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            int length = key.length();
            if (key.endsWith("_icon") || key.endsWith(".icon")) {
                this.registerMessageTypeIcon(key.substring(0, length - 5), types.getString(key), typeTable);
                continue;
            }
            if (key.endsWith("_foreground") || key.endsWith(".foreground")) {
                this.registerMessageTypeForeground(key.substring(0, length - 11), types.getString(key), typeTable);
                continue;
            }
            if (key.endsWith("_foreground_selected") || key.endsWith(".foreground_selected")) {
                this.registerMessageTypeSelectedForeground(key.substring(0, length - 20), types.getString(key), typeTable);
                continue;
            }
            if (key.endsWith("_background") || key.endsWith(".background")) {
                this.registerMessageTypeBackground(key.substring(0, length - 11), types.getString(key), typeTable);
                continue;
            }
            if (!key.endsWith("_background_selected") && !key.endsWith(".background_selected")) continue;
            this.registerMessageTypeSelectedBackground(key.substring(0, length - 20), types.getString(key), typeTable);
        }
    }

    private MessageType getMessageType(String type, Hashtable<String, MessageType> map) {
        MessageType messageType = map.get(type);
        if (messageType == null) {
            messageType = new MessageType();
            messageType.type = type;
            map.put(type, messageType);
        }
        return messageType;
    }

    private void registerMessageTypeIcon(String type, String iconPath, Hashtable<String, MessageType> map) {
        this.getMessageType((String)type, map).icon = ImageLoader.loadIcon((String)iconPath, (boolean)true, (ClassLoader)this.getClass().getClassLoader());
    }

    private void registerMessageTypeForeground(String type, String color, Hashtable<String, MessageType> map) {
        try {
            this.getMessageType((String)type, map).foreground = new Color(Integer.parseInt(color.substring(1), 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerMessageTypeSelectedForeground(String type, String color, Hashtable<String, MessageType> map) {
        try {
            this.getMessageType((String)type, map).selectedForeground = new Color(Integer.parseInt(color.substring(1), 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerMessageTypeBackground(String type, String color, Hashtable<String, MessageType> map) {
        try {
            this.getMessageType((String)type, map).background = new Color(Integer.parseInt(color.substring(1), 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerMessageTypeSelectedBackground(String type, String color, Hashtable<String, MessageType> map) {
        try {
            this.getMessageType((String)type, map).selectedBackground = new Color(Integer.parseInt(color.substring(1), 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Properties defaultTypes = new Properties("ch.e2e.builder.base.properties.messagetypes", MessageTypesPool.class.getClassLoader());
        pool.addProperties(defaultTypes, MessageTypesPool.pool.messageTypes);
    }
}

