/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.document.importer.resource;

import ch.e2e.builder.compiler.document.importer.resource.ArchivedFile;
import ch.e2e.builder.compiler.uml.BridgeStereotype;
import ch.e2e.builder.compiler.uml.Comment;
import ch.e2e.builder.compiler.uml.Helpers;
import ch.e2e.builder.compiler.uml.NoSuchPropertyException;
import ch.e2e.builder.compiler.uml.Property;
import ch.e2e.builder.compiler.uml.UmlElement;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.spi.CharsetProvider;
import java.util.Iterator;

public class Resource
extends UmlElement {
    private static ResourceCharsetProvider charsetProvider = new ResourceCharsetProvider();
    private File resourceFile;
    private boolean deploy = true;
    private String fileName;
    private String extension;

    public Resource(ArchivedFile resourceFile, BridgeStereotype resourceType, Helpers helpers) {
        this(resourceFile.getPath(), resourceFile, resourceType, helpers);
    }

    public Resource(File resourceFile, BridgeStereotype resourceType, Helpers helpers) {
        this(resourceFile.getName(), resourceFile, resourceType, helpers);
    }

    public Resource(String name, File resourceFile, BridgeStereotype resourceType, Helpers helpers) {
        super(name, new Comment("", helpers), resourceType, helpers);
        this.resourceFile = resourceFile;
        this.createFileName();
        this.deploy = resourceType.getProperty("deploy") == null || (Boolean)resourceType.getProperty("deploy").getValue() != false;
    }

    public Charset getCharset() {
        String charset = (String)this.getPropertyValueQuietly("charset");
        return charset == null ? null : charsetProvider.charsetForName(charset);
    }

    public void setCharset(Object charset) {
        this.setPropertyValueQuietly("charset", charset.toString());
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getExtension() {
        return this.extension;
    }

    public File getResourceFile() {
        return this.resourceFile;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean isDeploy() {
        return this.deploy;
    }

    public void setDeploy(boolean deploy) {
        this.deploy = deploy;
    }

    @Override
    public Object getPropertyValueQuietly(String propertyName) {
        Object value;
        block2: {
            value = null;
            try {
                value = this.getProperty(propertyName).getValue();
            }
            catch (NoSuchPropertyException e) {
                Property property = this.getStereotype().getProperty(propertyName);
                if (property == null) break block2;
                value = property.getValue();
            }
        }
        return value;
    }

    @Override
    public Object getPropertyValue(String propertyName) throws NoSuchPropertyException {
        Object value;
        try {
            value = this.getProperty(propertyName).getValue();
        }
        catch (NoSuchPropertyException e) {
            Property property = this.getStereotype().getProperty(propertyName);
            if (property == null) {
                throw new NoSuchPropertyException(this.getName(), propertyName);
            }
            value = property.getValue();
        }
        return value;
    }

    @Override
    public Property getProperty(String propertyName) throws NoSuchPropertyException {
        Property property;
        block2: {
            try {
                property = super.getProperty(propertyName);
            }
            catch (NoSuchPropertyException e) {
                property = this.getStereotype().getProperty(propertyName);
                if (property != null) break block2;
                throw new NoSuchPropertyException(this.getName(), propertyName);
            }
        }
        return property;
    }

    public boolean canExtract() {
        return false;
    }

    private void createFileName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            this.fileName = name;
            this.extension = "";
        } else {
            this.fileName = name.substring(0, index);
            this.extension = name.length() > index ? name.substring(index) : "";
        }
    }

    private static class ResourceCharset
    extends Charset {
        protected ResourceCharset(String canonicalName) {
            super(canonicalName, new String[]{canonicalName});
        }

        @Override
        public boolean contains(Charset cs) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return null;
        }

        @Override
        public CharsetEncoder newEncoder() {
            return null;
        }
    }

    private static class ResourceCharsetProvider
    extends CharsetProvider {
        private ResourceCharsetProvider() {
        }

        @Override
        public Iterator<Charset> charsets() {
            return Charset.availableCharsets().values().iterator();
        }

        @Override
        public Charset charsetForName(String charsetName) {
            Charset result = null;
            Iterator<Charset> charsets = this.charsets();
            block0: while (charsets.hasNext() && result == null) {
                Charset next = charsets.next();
                if (next.name().equalsIgnoreCase(charsetName)) {
                    result = next;
                    continue;
                }
                for (String s : next.aliases()) {
                    if (!s.equalsIgnoreCase(charsetName)) continue;
                    result = next;
                    continue block0;
                }
            }
            if (result == null) {
                result = new ResourceCharset(charsetName);
            }
            return result;
        }
    }
}

