/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.types.Logging;
import ch.e2e.dom.DomUtilities;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TabfileContainer
extends File {
    public static final long serialVersionUID = 1L;

    public TabfileContainer(File parent, String child) {
        super(parent, child);
    }

    public TabfileContainer(File file) {
        super(file.getAbsolutePath());
    }

    public int getTraceOption() {
        int trace = -1;
        if (this.exists()) {
            try {
                Document tables = this.getTabfileTables();
                String traceStr = tables.getDocumentElement().getAttribute("trace");
                trace = Integer.parseInt(traceStr);
            }
            catch (Exception e) {
                Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                Logging.logger.throwing(this.getClass().getName(), "getTraceOption", e);
            }
        }
        return trace;
    }

    public boolean getStatemachineManual() {
        boolean statemachineManual = false;
        if (this.exists()) {
            try {
                Document tables = this.getTabfileTables();
                statemachineManual = DomUtilities.getBoolean((Element)tables.getDocumentElement(), (String)"statemachineManual", (boolean)false);
            }
            catch (Exception e) {
                Logging.logger.severe("Caught a " + e.getClass().getName() + ": " + e.getMessage());
                Logging.logger.throwing(this.getClass().getName(), "getStatemachineManual", e);
            }
        }
        return statemachineManual;
    }

    private Document getTabfileTables() throws IOException, SAXException, ParserConfigurationException {
        return DomUtilities.parse((File)this, (boolean)false, (boolean)false);
    }
}

