/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.types;

import ch.e2e.builder.compiler.build.action.DeployBuildAction;
import ch.e2e.builder.compiler.build.types.HeaderField;
import ch.e2e.builder.compiler.build.types.Parameter;
import ch.e2e.builder.compiler.build.types.Upload;
import ch.e2e.builder.compiler.error.DeployErrorHandler;
import ch.e2e.builder.compiler.net.Login;
import java.util.ArrayList;

public abstract class Deploy {
    private ArrayList<Upload> uploads = new ArrayList();
    private ArrayList<Parameter> parameter = new ArrayList();
    private ArrayList<HeaderField> headerFields = new ArrayList();
    private Login login;
    private DeployErrorHandler errorHandler;

    public Deploy(DeployBuildAction action) {
        this.login = action.getLogin();
        this.errorHandler = action.getErrorHandler();
        this.createHeaderFields();
        this.createParameter(action.isStartup(), action.isOverride(), action.isOverrideSettings());
    }

    public Login getLogin() {
        return this.login;
    }

    public ArrayList<HeaderField> getHeaderFields() {
        return this.headerFields;
    }

    public ArrayList<Parameter> getParameter() {
        return this.parameter;
    }

    public ArrayList<Upload> getUploads() {
        return this.uploads;
    }

    public DeployErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private void createParameter(boolean startup, boolean override, boolean overrideSettings) {
        Parameter param = new Parameter("input_overwrite", String.valueOf(override));
        this.parameter.add(param);
        param = new Parameter("action_UPLOAD", "UPLOAD");
        this.parameter.add(param);
        param = new Parameter("input_startup", String.valueOf(startup));
        this.parameter.add(param);
        param = new Parameter("input_overwrite_settings", String.valueOf(overrideSettings));
        this.parameter.add(param);
    }

    private void createHeaderFields() {
        HeaderField xBridge = new HeaderField("X-Bridge", "return-xml");
        this.headerFields.add(xBridge);
    }
}

