/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2xmi.libraries;

import ch.e2e.builder.compiler.build.tasks.constants.Files;
import ch.e2e.builder.compiler.build.tasks.model.BuildLibraryTask;
import ch.e2e.builder.compiler.build.tasks.model.libraries.LibrariesHelper;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularHelper;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularXsltTask;
import ch.e2e.builder.compiler.build.tasks.model.model2xmi.form.FormHelper;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LibraryDescriptorTask
extends AngularXsltTask {
    private Set<String> libraryFormsSourceSet;

    public static Boolean select(String id) {
        return id.startsWith("library/") && id.endsWith("library.descriptor.json");
    }

    public LibraryDescriptorTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    private Set<String> getLibraryRepositorySources() {
        HashSet<String> sources = new HashSet<String>(){
            {
                this.add(BuildLibraryTask.TASK_ID);
            }
        };
        if (this.getLibraryFormsSourceSet().size() > 0) {
            sources.add(Files.library__PROJECT_build_npm(AngularHelper.getAngularLibName(this.getProjectName())));
        }
        return sources;
    }

    private String getBuildID() {
        return this.getLibraryRepositorySources().stream().map(id -> this.getSourceManager().getSource((String)id).getHash()).collect(Collectors.joining("-"));
    }

    @Override
    protected String getDestinationFileExtension() {
        return ".json";
    }

    @Override
    protected String getTransformerId() {
        return "model.xmi.library.descriptor";
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        Set<String> result = super.getBeforeSourceSet();
        result.addAll(FormHelper.getFormJsonDocumentSourceSet(this.getSourceManager()));
        return result;
    }

    private Set<String> getLibraryFormsSourceSet() {
        if (this.libraryFormsSourceSet == null) {
            this.libraryFormsSourceSet = FormHelper.getLibraryForms(this.getSourceManager()).stream().map(Files::form__FORM_form_xml).collect(Collectors.toSet());
        }
        return this.libraryFormsSourceSet;
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.addAll(LibrariesHelper.getDescriptorsSourceSet(this.getSourceManager(), false));
        result.addAll(this.getLibraryFormsSourceSet());
        result.addAll(this.getLibraryRepositorySources());
        return result;
    }

    @Override
    protected Boolean isLib() {
        return true;
    }

    @Override
    protected Map<String, Object> getTransformParameters() {
        Map<String, Object> map = super.getTransformParameters();
        map.put("buildID", this.getBuildID());
        return map;
    }
}

