/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.model2angular;

import ch.e2e.builder.compiler.build.tasks.XSLTTask;
import ch.e2e.builder.compiler.build.tasks.constants.Folders;
import ch.e2e.builder.compiler.build.tasks.model.model2angular.AngularHelper;
import ch.e2e.builder.compiler.build.tasks.source.JsonDocumentSource;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import ch.e2e.builder.compiler.document.json.xuml.XumlProject;
import java.util.Map;
import java.util.Set;

public abstract class AngularXsltTask
extends XSLTTask {
    public AngularXsltTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    protected Set<String> getSourceSet() {
        Set<String> result = super.getSourceSet();
        result.add("project.xml");
        return result;
    }

    @Override
    protected Map<String, Object> getTransformParameters() {
        Map<String, Object> parameters = super.getTransformParameters();
        parameters.put("angularLib", this.isLib());
        parameters.put("angular_project_name", this.getAngularProjectName());
        parameters.put("angular_project_src_lib_path", this.getSourceLibPath());
        parameters.put("destination_in_angular_project_src_lib_path", this.getDestinationInSourceLibPath());
        return parameters;
    }

    protected Boolean isLib() {
        return this.getId().startsWith("angular-lib");
    }

    protected String getProjectName() {
        return ((JsonDocumentSource)this.getSourceManager().getSource("project.xml")).getJsonDocument(XumlProject.class).getName();
    }

    protected String getAngularProjectName() {
        if (this.isLib().booleanValue()) {
            return AngularHelper.getAngularLibName(this.getProjectName());
        }
        return AngularHelper.getMainProjectName(this.getProjectName());
    }

    protected String getSourceLibPath() {
        if (this.isLib().booleanValue()) {
            return Folders.angularLib_projects_PROJECT__src_lib(AngularHelper.getAngularLibName(this.getProjectName()));
        }
        return Folders.angular_projects_PROJECT_src_app(AngularHelper.getMainProjectName(this.getProjectName()));
    }

    protected String getDestinationInSourceLibPath() {
        try {
            return this.getDestinationFolder().substring(this.getSourceLibPath().length() + 1);
        }
        catch (Exception e) {
            return "";
        }
    }
}

