/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model.dev;

import ch.e2e.builder.compiler.serviceRepository.types.events.DeployContainerResponse;
import ch.e2e.builder.compiler.utils.EnvUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;

public class DevUtils {
    private static final Boolean DEV_ENV_ENABLED = EnvUtils.get("XUML_COMPILER_SERVICE_DEV_CONTAINER_ENABLED", false);
    private static final String DEV_ENV = "dev_env";
    private static final String DEV_ENV_LOCAL = "local";
    private static final String DEV_ENV_CONTAINER = "container";
    private static final String DEV_ENV_VAGRANT = "vagrant";
    private static final String LOCAL_DEV_SERVICE_PATH = "local_dev_service_path";
    private static final String ANGULAR_SERVE_TASK_LOCAL_DEV_WORKSPACE_PATH = "AngularServeTask_local_dev_workspace_path";
    private static final String ANGULAR_SERVE_TASK_PORT_RANGE_MIN = "AngularServeTask_local_dev_port_range_min";
    private static final String ANGULAR_SERVE_TASK_PORT_RANGE_MAX = "AngularServeTask_local_dev_port_range_max";
    private static final String CONTAINER_DEV_BASE_NAME = "angular-dev";
    public static final Map<String, DeployContainerResponse> STARTED_DEV_SERVICES = new HashMap<String, DeployContainerResponse>();

    public static boolean isDevEnvEnabled() {
        return DEV_ENV_ENABLED;
    }

    public static boolean isLocalDevEnv() {
        return DEV_ENV_LOCAL.equalsIgnoreCase(DevUtils.getAngularDevType());
    }

    public static boolean isContainerDevEnv() {
        return DEV_ENV_CONTAINER.equalsIgnoreCase(DevUtils.getAngularDevType());
    }

    public static boolean isVagrantDevEnv() {
        return DEV_ENV_VAGRANT.equalsIgnoreCase(DevUtils.getAngularDevType());
    }

    private static String getAngularDevType() {
        return EnvUtils.get(DEV_ENV, DEV_ENV_CONTAINER);
    }

    public static String getContainerDevName(String projectId) {
        return String.format("%s-%s", CONTAINER_DEV_BASE_NAME, projectId);
    }

    public static String getDevServicePath(String projectId, int port) {
        String hostname = DevUtils.getContainerDevName(projectId);
        if (DevUtils.isLocalDevEnv()) {
            hostname = "localhost";
        }
        if (DevUtils.isVagrantDevEnv()) {
            hostname = "vagrantguest";
        }
        return String.format("http://%s:%s", hostname, port);
    }

    public static Path getLocalDevFolderPath() {
        return Paths.get(EnvUtils.get(ANGULAR_SERVE_TASK_LOCAL_DEV_WORKSPACE_PATH, "tmp/dev"), new String[0]);
    }

    public static Path getLocalDevServiceFolderPath() {
        return Paths.get(EnvUtils.get(LOCAL_DEV_SERVICE_PATH, "../../xuml-development-service"), new String[0]);
    }

    public static ServerSocket getSocketOnFreePort() throws IOException {
        return DevUtils.getSocketOnFreePortFromRange(EnvUtils.get(ANGULAR_SERVE_TASK_PORT_RANGE_MIN, 49152), EnvUtils.get(ANGULAR_SERVE_TASK_PORT_RANGE_MAX, 65535));
    }

    private static ServerSocket getSocketOnFreePortFromRange(int start, int end) throws IOException {
        return IntStream.rangeClosed(start, end).mapToObj(port -> {
            try {
                return new ServerSocket(port);
            }
            catch (IOException iOException) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IOException("No free port found"));
    }
}

