/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.compiler.build.tasks.model;

import ch.e2e.builder.compiler.build.tasks.model.ZipTask;
import ch.e2e.builder.compiler.build.tasks.source.SourceManager;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class ProjectZipTask
extends ZipTask {
    public static String TASK_ID = "project.zip";
    private static final String[] FILES_TO_FILTER_OUT = new String[]{TASK_ID, TASK_ID + ".hash", TASK_ID + ".errors"};

    public static Boolean select(String id) {
        return id.equals(TASK_ID);
    }

    public ProjectZipTask(SourceManager sourceManager, String id) {
        super(sourceManager, id);
    }

    @Override
    public boolean isUpToDate() {
        return false;
    }

    @Override
    protected Set<String> getBeforeSourceSet() {
        return new HashSet<String>();
    }

    @Override
    protected Set<String> getSourceSet() {
        return new HashSet<String>();
    }

    @Override
    protected Set<String> getSourcesToCheck() {
        return new HashSet<String>();
    }

    @Override
    protected Path[] getInputFolderPaths() {
        return new Path[]{this.getSourceManager().getProjectFolder().toPath()};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doFilter(Path path) {
        if (!super.doFilter(path)) return false;
        if (!Stream.of(FILES_TO_FILTER_OUT).noneMatch(path.getFileName().toString()::equals)) return false;
        return true;
    }
}

