/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom2;

import java.util.HashMap;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.jdom2.JDOM2NodeWrapper;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tree.iter.AxisIterator;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;

public class JDOM2DocumentWrapper
extends GenericTreeInfo {
    protected Configuration config;
    protected long documentNumber;
    private HashMap<String, Element> idIndex;
    private HashMap<String, Object> userData;

    public JDOM2DocumentWrapper(Document doc, Configuration config) {
        super(config);
        this.setRootNode(this.wrap(doc));
        this.setSystemId(doc.getBaseURI());
    }

    public JDOM2NodeWrapper wrap(Object node) {
        return JDOM2NodeWrapper.makeWrapper(node, this);
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        Element element;
        if (this.idIndex == null) {
            NodeInfo node;
            this.idIndex = new HashMap(100);
            AxisIterator iter = this.getRootNode().iterateAxis((byte)4, NodeKindTest.ELEMENT);
            while ((node = iter.next()) != null) {
                Element element2 = (Element)((JDOM2NodeWrapper)node).node;
                List attributes = element2.getAttributes();
                for (Object attribute : attributes) {
                    Attribute att = (Attribute)attribute;
                    if (att.getAttributeType() != Attribute.ID_TYPE) continue;
                    this.idIndex.put(att.getValue(), element2);
                }
            }
        }
        return (element = this.idIndex.get(id)) == null ? null : this.wrap(element);
    }
}

