/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.watch;

import ch.e2e.builder.base.gui.E2EBuilderDialog;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.BlobViewerDialog;
import ch.e2e.builder.trace.gui.DateViewerDialog;
import ch.e2e.builder.trace.gui.TextDialog;
import ch.e2e.builder.trace.gui.TextEditor;
import ch.e2e.builder.trace.gui.TextViewer;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.watch.ActionScriptWatchDocument;
import ch.e2e.builder.trace.gui.watch.WatchPane;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.TestcaseWatch;
import ch.e2e.builder.trace.testcase.uml.TypeMapper;
import ch.e2e.event.EventController;
import ch.e2e.io.ZipUtilities;
import ch.e2e.swing.FloatingFrame;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableBar;
import com.jidesoft.swing.TextComponentSearchable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ActionScriptWatch
extends E2EBuilderDialog {
    public static final String ENTRY_NAME = "script";
    private static final String TITLE = "watches.actionScript.title";
    private static final String INTERNAL_TITLE = "watches.actionScript.internalTitle";
    private static final String SUBTITLE = "watches.actionScript.subtitle";
    private static final Dimension DEFAULT_SIZE = new Dimension(480, 360);
    private JEditorPane scriptPane;
    private FloatingFrame popup;
    private TextDialog valueViewer;
    private WatchPane complexValuePane = null;
    private Testcase testcase;
    private final E2EBuilderModule owner;
    private static final Pattern PATTERN = Pattern.compile("<a href=\"(SCRIPTIO_[A-Z]+[0-9]+|file:[^>]*)\">(.*?)</a>");

    public ActionScriptWatch(E2EBuilderModule owner) {
        super(owner.getTranslation(TITLE), owner.getTranslation(INTERNAL_TITLE), owner.getTranslation(SUBTITLE), 1);
        this.owner = owner;
        this.testcase = null;
        this.createGui();
    }

    public void setTestcase(Testcase testcase) {
        this.testcase = testcase;
    }

    public void setActionScript(String actionScript) {
        if (actionScript == null) {
            this.scriptPane.setText(null);
        } else {
            List<Link> links = this.findLinks(actionScript);
            this.scriptPane.setText(this.resolveLinks(actionScript, links));
            this.getDocument().decorateLinks(links);
        }
    }

    protected boolean doOnOk() {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        }
        return super.doOnOk();
    }

    private void createGui() {
        this.valueViewer = new TextDialog((Dialog)((Object)this), (TextEditor)new TextViewer(this.owner), this.owner.getTranslation("text.viewer.title"), 0);
        this.add(this.createScriptPanel());
        this.createPopup();
        this.pack();
    }

    private JPanel createScriptPanel() {
        this.scriptPane = new JEditorPane();
        this.scriptPane.setEditorKit(new StyledEditorKit(){

            @Override
            public Document createDefaultDocument() {
                return new ActionScriptWatchDocument();
            }
        });
        this.scriptPane.setEditable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.scriptPane, 20, 30), "Center");
        panel.add((Component)this.createSearchableBar(), "South");
        return panel;
    }

    private SearchableBar createSearchableBar() {
        TextComponentSearchable searchable = new TextComponentSearchable(this.scriptPane){

            public void installHighlightsRemover() {
                this._component.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (!((SearchableBar)this.getSearchableProvider()).isHighlightAll()) {
                            this.removeAllHighlights();
                        }
                    }
                });
            }

            public void uninstallHighlightsRemover() {
            }
        };
        SearchableBar searchableBar = new SearchableBar((Searchable)searchable, true);
        searchableBar.setVisibleButtons(-2);
        return searchableBar;
    }

    private void createPopup() {
        this.popup = new FloatingFrame((Dialog)((Object)this), "", true);
        this.popup.setBackground(Color.WHITE);
        this.popup.setOpaque(true);
        this.popup.setResizable(true);
        this.popup.setTitleVisible(false);
        this.popup.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.scriptPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String link = ActionScriptWatch.this.getLink(e.getPoint());
                if (link != null && link.length() > 0) {
                    JComponent comp = ActionScriptWatch.this.resolveLink(link);
                    if (comp != null) {
                        ActionScriptWatch.this.showPopup(e, comp);
                    }
                } else {
                    ActionScriptWatch.this.popup.setVisible(false);
                }
            }
        });
    }

    private JComponent resolveLink(String link) {
        JComponent result = null;
        if (link.startsWith("file:")) {
            EventController.fire((EventObject)new OpenLinkEvent((Object)this, link));
        } else {
            try {
                org.w3c.dom.Document document = ZipUtilities.getZippedDocumentFromFile((File)this.testcase.getIOFile(), (String)link);
                if (document != null) {
                    Element element = document.getDocumentElement();
                    String type = ((Element)element.getFirstChild()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    if (!TypeMapper.isSimpleType((String)TypeMapper.bridgeType2XSD((String)type))) {
                        result = this.getComplexValuePane((Element)element.getFirstChild());
                    } else {
                        TestcaseWatch watch = new TestcaseWatch(null, -1, (Element)element.getFirstChild());
                        if (watch.isBlob()) {
                            BlobViewerDialog.getDialog(this.owner).show((byte[])watch.getValue());
                        } else if (watch.isDateTime()) {
                            DateViewerDialog.getDialog(this.owner).show(watch.getValueAsString());
                        } else {
                            this.valueViewer.showText(watch.getValueAsString(), watch.isTruncated());
                        }
                    }
                }
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        return result;
    }

    private void showPopup(MouseEvent event, JComponent comp) {
        this.popup.removeAll();
        this.popup.add((Component)comp);
        this.popup.pack();
        this.popup.getParent().getLocationOnScreen();
        Point cursorPos = event.getPoint();
        Point onScreenPos = event.getComponent().getLocationOnScreen();
        int x = cursorPos.x + onScreenPos.x;
        int y = cursorPos.y + onScreenPos.y;
        this.popup.setLocation(x, y);
        this.popup.setVisible(true);
    }

    private JComponent getComplexValuePane(Element element) {
        TestcaseWatch watch = new TestcaseWatch(null, -1, element);
        if (this.complexValuePane == null) {
            this.complexValuePane = new WatchPane(this.owner, (Dialog)((Object)this), (TestcaseParameter)watch);
        } else {
            this.complexValuePane.setWatch((TestcaseParameter)watch);
        }
        return this.complexValuePane;
    }

    private String getLink(Point mousePosition) {
        int pos = this.scriptPane.viewToModel(mousePosition);
        AttributeSet attributes = this.getDocument().getCharacterElement(pos).getAttributes();
        return (String)attributes.getAttribute("link");
    }

    private ActionScriptWatchDocument getDocument() {
        return (ActionScriptWatchDocument)((Object)this.scriptPane.getDocument());
    }

    public Dimension getPreferredSize() {
        return DEFAULT_SIZE;
    }

    private List<Link> findLinks(String script) {
        ArrayList<Link> links = new ArrayList<Link>();
        Matcher m = PATTERN.matcher(script);
        while (m.find()) {
            links.add(new Link(m.group(2), m.group(1), m.start(), m.start(2) - m.start()));
        }
        return links;
    }

    private String resolveLinks(String script, List<Link> links) {
        StringBuilder sb = new StringBuilder(script);
        int offset = 0;
        Iterator<Link> iterator = links.iterator();
        while (iterator.hasNext()) {
            Link link;
            Link link2 = link = iterator.next();
            link2.position = link2.position - offset;
            sb.delete(link.position, link.position + link.cutLength);
            sb.delete(link.position + link.length, link.position + link.length + 4);
            offset += link.cutLength + 4;
        }
        return sb.toString();
    }

    public static class Link {
        private int position;
        private final int cutLength;
        private final int length;
        private final String data;

        Link(String name, String data, int position, int cutLength) {
            this.data = data;
            this.position = position;
            this.cutLength = cutLength;
            this.length = name.length();
        }

        public int getPosition() {
            return this.position;
        }

        public String getData() {
            return this.data;
        }

        public int getLength() {
            return this.length;
        }
    }
}

