/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.uml.activity;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.OpenLinkEvent;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.uml.AbstractCellAction;
import ch.e2e.builder.trace.gui.uml.CellWithContextMenu;
import ch.e2e.builder.trace.gui.uml.ContextMenu;
import ch.e2e.builder.trace.gui.uml.UmlGraphConstants;
import ch.e2e.builder.trace.testcase.uml.Pin;
import ch.e2e.builder.trace.testcase.uml.UmlObject;
import ch.e2e.event.EventController;
import ch.e2e.swing.MouseOverList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jgraph.graph.DefaultGraphCell;

public abstract class PinCell
extends DefaultGraphCell
implements CellWithContextMenu {
    private static PinContextMenu contextMenu;
    private E2EBuilderModule module;
    private PinListModel pinListModel;

    public PinCell(Object userObject, E2EBuilderModule module) {
        super(userObject);
        this.module = module;
        this.pinListModel = new PinListModel((List)userObject);
        UmlGraphConstants.setBorderColor((Map)this.attributes, (Color)Color.BLACK);
        UmlGraphConstants.setOpaque((Map)this.attributes, (boolean)true);
    }

    @Override
    public E2EBuilderModule getModule() {
        return this.module;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public PinContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new PinContextMenu(this);
        }
        contextMenu.setCell(this);
        return contextMenu;
    }

    public AbstractCellAction<PinCell> getDefaultAction() {
        return this.getContextMenu().getDefaultAction();
    }

    @Override
    public boolean isContextMenuAlwaysTriggered() {
        return false;
    }

    public String toString() {
        return null;
    }

    private static class PinListModel
    implements ListModel {
        private List<? extends Pin> pins;

        private PinListModel(List<? extends Pin> pins) {
            this.pins = pins == null ? Collections.emptyList() : pins;
        }

        @Override
        public int getSize() {
            return this.pins.size();
        }

        public Object getElementAt(int index) {
            return this.pins.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private static class PinContextMenu
    extends ContextMenu<PinCell> {
        private MouseOverList showPinInTreeList;
        private MouseOverList showPinValueList;

        public PinContextMenu(PinCell cell) {
            super(cell);
            this.createMenu();
        }

        @Override
        public void setCell(PinCell cell) {
            this.showPinInTreeList.setModel((ListModel)cell.pinListModel);
            this.showPinValueList.setModel((ListModel)cell.pinListModel);
            super.setCell(cell);
            boolean enabled = cell.pinListModel.getSize() > 0;
            this.setItemEnabled(this.getTranslation("uml.diagram.action.show.in.tree"), enabled);
            this.setItemEnabled(this.getTranslation("uml.diagram.action.show.pin.value"), enabled);
        }

        private void createMenu() {
            this.showPinInTreeList = new MouseOverList((ListModel)((PinCell)this.getCell()).pinListModel);
            this.showPinInTreeList.setSelectionMode(0);
            this.showPinInTreeList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Pin pin = (Pin)showPinInTreeList.getSelectedValue();
                    if (pin != null) {
                        EventController.fire((EventObject)new SelectInTreeEvent(this.getCell(), (UmlObject)pin));
                        this.setVisible(false);
                        showPinInTreeList.clearSelection();
                    }
                }
            });
            JMenu pinMenu = new JMenu(this.getTranslation("uml.diagram.action.show.in.tree"));
            pinMenu.add((Component)this.showPinInTreeList);
            this.add(pinMenu);
            this.showPinValueList = new MouseOverList((ListModel)((PinCell)this.getCell()).pinListModel);
            this.showPinValueList.setSelectionMode(0);
            this.showPinValueList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Pin pin = (Pin)showPinValueList.getSelectedValue();
                    if (pin != null) {
                        EventController.fire((EventObject)new OpenLinkEvent(this.getCell(), "file:///addToWatches?entry=" + pin.getInternalIOKey()));
                        this.setVisible(false);
                        showPinValueList.clearSelection();
                    }
                }
            });
            pinMenu = new JMenu(this.getTranslation("uml.diagram.action.show.pin.value"));
            pinMenu.add((Component)this.showPinValueList);
            this.add(pinMenu);
        }
    }
}

