/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.testcase;

import ch.e2e.builder.base.gui.ModulePopupMenu;
import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.gui.event.SelectInTreeEvent;
import ch.e2e.builder.trace.gui.model.TestcaseRequestModel;
import ch.e2e.builder.trace.gui.parameter.BigDecimalEditor;
import ch.e2e.builder.trace.gui.parameter.BigIntegerEditor;
import ch.e2e.builder.trace.gui.parameter.BlobEditor;
import ch.e2e.builder.trace.gui.parameter.BooleanEditor;
import ch.e2e.builder.trace.gui.parameter.DateTimeCellEditor;
import ch.e2e.builder.trace.gui.parameter.StringEditor;
import ch.e2e.builder.trace.gui.testcase.PreferencesPanel;
import ch.e2e.builder.trace.gui.tree.ParameterRenderer;
import ch.e2e.builder.trace.gui.watch.WatchRenderer;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AdapterOutput;
import ch.e2e.builder.trace.testcase.AdapterOutputContainer;
import ch.e2e.builder.trace.testcase.AdapterOutputContainerList;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseParameter;
import ch.e2e.builder.trace.testcase.parameter.BigDecimalParameter;
import ch.e2e.builder.trace.testcase.parameter.BigIntegerParameter;
import ch.e2e.builder.trace.testcase.parameter.BlobParameter;
import ch.e2e.builder.trace.testcase.parameter.BooleanParameter;
import ch.e2e.builder.trace.testcase.parameter.DateTimeParameter;
import ch.e2e.builder.trace.testcase.parameter.Parameter;
import ch.e2e.builder.trace.testcase.parameter.StringParameter;
import ch.e2e.event.EventController;
import ch.e2e.resource.ImageLoader;
import ch.e2e.swing.Tree;
import ch.e2e.swing.TreeObject;
import ch.e2e.swing.model.AbstractTreeModel;
import ch.e2e.swing.renderer.CellEditor;
import ch.e2e.swing.renderer.CheckBoxTreeCellComponent;
import ch.e2e.swing.renderer.CheckBoxTreeCellRenderer;
import ch.e2e.swing.renderer.EditorContainer;
import ch.e2e.swing.renderer.RendererPreferences;
import ch.e2e.swing.renderer.TreeCellRendererDelegator;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class MockBackendsPanel
extends PreferencesPanel
implements TreeModelListener {
    private final E2EBuilderModule module;
    private final InternalPanel view;
    private MockBackendsModel treeModel;
    private MockBackendsTree tree;
    private boolean save = false;

    public MockBackendsPanel(E2EBuilderModule module) {
        super(new BorderLayout());
        this.module = module;
        this.treeModel = new MockBackendsModel(module);
        this.treeModel.addTreeModelListener(this);
        this.tree = new MockBackendsTree(this.treeModel, module);
        this.tree.getCellEditor().addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                MockBackendsPanel.this.save = true;
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.view = new InternalPanel(this.tree, module.getTranslation("mock.backends.info.needs.repository.import"));
        this.add(new JScrollPane(this.view));
    }

    public E2EBuilderModule getModule() {
        return this.module;
    }

    public void setTestcase(AbstractSynchronousTestcase testcase) {
        super.setTestcase((Testcase)testcase);
        if (testcase == null) {
            this.view.show("info");
        } else if (testcase.hasAdapterTemplates()) {
            this.view.show("tree");
            this.treeModel.setRoot((Testcase)testcase);
        }
        this.save = false;
    }

    public void setAdapterOutputContainers(AdapterOutputContainerList adapterOutputContainers) {
        this.treeModel.setAdapterOutputContainers(adapterOutputContainers);
    }

    public void select(AdapterOutputContainer container) {
        TreePath path = new TreePath(this.treeModel.getRoot()).pathByAddingChild(container);
        this.tree.setSelectionPath(path);
        this.tree.expandPath(path);
        this.tree.scrollPathToVisible(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fillTestcase(Testcase testcase) {
        boolean changed = false;
        if (this.save || !this.treeModel.adapterOutputContainers.isReadOutputsFile()) {
            try {
                changed = this.requestChanged(testcase);
                this.treeModel.adapterOutputContainers.save();
                testcase.getRequest().getNamespacesManager().save(testcase.getHome());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.save = false;
            }
        }
        return changed;
    }

    private boolean requestChanged(Testcase testcase) {
        boolean changed = false;
        AdapterOutputContainerList containers = new AdapterOutputContainerList((AbstractSynchronousTestcase)testcase);
        int size = containers.size();
        for (int i = 0; !changed && i < size; ++i) {
            AdapterOutputContainer container = (AdapterOutputContainer)containers.get(i);
            AdapterOutputContainer newContainer = (AdapterOutputContainer)this.treeModel.adapterOutputContainers.get(i);
            changed = newContainer == null || container.isUse() != newContainer.isUse() || newContainer.isUse() && container.differsFrom(newContainer);
        }
        return changed;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.save = true;
    }

    @Override
    public void treeNodesInserted(final TreeModelEvent e) {
        this.save = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MockBackendsPanel.this.tree.expandPath(e.getTreePath());
            }
        });
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.save = true;
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.save = true;
    }

    private static class InternalPanel
    extends JPanel {
        public static final String TREE = "tree";
        public static final String INFO = "info";

        public InternalPanel(Tree tree, String msg) {
            CardLayout cards = new CardLayout();
            this.setLayout(cards);
            this.add((Component)tree, TREE);
            JTextArea text = new JTextArea(msg);
            text.setEditable(false);
            text.setOpaque(false);
            this.add((Component)text, INFO);
        }

        public void show(String name) {
            ((CardLayout)this.getLayout()).show(this, name);
        }
    }

    private static class AdapterOutputPopupMenu
    extends ModulePopupMenu {
        private final MockBackendsModel treeModel;
        private AdapterOutput adapterOutput;
        private TreePath treePath;
        private JMenuItem copyItem;
        private JMenuItem deleteItem;
        private JMenuItem moveUpItem;
        private JMenuItem moveDownItem;

        public AdapterOutputPopupMenu(MockBackendsModel treeModel, E2EBuilderModule module) {
            super(module);
            this.treeModel = treeModel;
            this.addItems();
        }

        public void setAdapterOutput(AdapterOutput adapterOutput, TreePath treePath) {
            this.adapterOutput = adapterOutput;
            this.treePath = treePath;
            AdapterOutputContainer container = adapterOutput.getContainer();
            int index = this.treeModel.getIndexOfChild(container, adapterOutput);
            this.moveUpItem.setEnabled(index > 0);
            this.moveDownItem.setEnabled(index < container.getChildCount() - 1);
        }

        private void addItems() {
            this.copyItem = this.getModule().createMenuItem("tree.mock.backends.popup.menu.copy");
            this.add(this.copyItem);
            this.copyItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdapterOutputContainer adapterOutputContainer = adapterOutput.getContainer();
                    AdapterOutput copiedAdapterOutput = adapterOutputContainer.copyAndAddAdapterOutput(adapterOutput);
                    int index = adapterOutputContainer.getIndexOfChild((Object)copiedAdapterOutput);
                    treeModel.nodeInserted(treePath.getParentPath(), index, copiedAdapterOutput);
                }
            });
            this.deleteItem = this.getModule().createMenuItem("tree.mock.backends.popup.menu.delete");
            this.add(this.deleteItem);
            this.deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdapterOutputContainer adapterOutputContainer = adapterOutput.getContainer();
                    int index = adapterOutputContainer.getIndexOfChild((Object)adapterOutput);
                    if (adapterOutputContainer.removeAdapterOutput(adapterOutput) != null) {
                        treeModel.nodeRemoved(treePath.getParentPath(), index, adapterOutput);
                    }
                }
            });
            this.addSeparator();
            this.moveUpItem = this.getModule().createMenuItem("tree.mock.backends.popup.menu.move.up");
            this.moveUpItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdapterOutputContainer container = adapterOutput.getContainer();
                    int index = container.getIndexOfChild((Object)adapterOutput);
                    if (index > 0) {
                        container.removeAdapterOutput(adapterOutput);
                        TreePath parentPath = treePath.getParentPath();
                        container.addAdapterOutput(index - 1, adapterOutput);
                        treeModel.nodesChanged(parentPath, new int[]{index, index - 1}, new Object[]{container.getChild(index), container.getChild(index - 1)});
                    }
                }
            });
            this.add(this.moveUpItem);
            this.moveDownItem = this.getModule().createMenuItem("tree.mock.backends.popup.menu.move.down");
            this.moveDownItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdapterOutputContainer container = adapterOutput.getContainer();
                    int index = container.getIndexOfChild((Object)adapterOutput);
                    if (index < container.getChildCount() - 1) {
                        container.removeAdapterOutput(adapterOutput);
                        TreePath parentPath = treePath.getParentPath();
                        container.addAdapterOutput(index + 1, adapterOutput);
                        treeModel.nodesChanged(parentPath, new int[]{index, index + 1}, new Object[]{container.getChild(index), container.getChild(index + 1)});
                    }
                }
            });
            this.add(this.moveDownItem);
        }
    }

    private static class AdapterOutputContainerPopupMenu
    extends ModulePopupMenu {
        private final MockBackendsModel treeModel;
        private AdapterOutputContainer adapterOutputContainer;
        private TreePath treePath;

        public AdapterOutputContainerPopupMenu(MockBackendsModel treeModel, E2EBuilderModule module) {
            super(module);
            this.treeModel = treeModel;
            this.addItems();
        }

        public void setAdapterOutputContainer(AdapterOutputContainer adapterOutputContainer, TreePath treePath) {
            this.adapterOutputContainer = adapterOutputContainer;
            this.treePath = treePath;
        }

        private void addItems() {
            JMenuItem createItem = this.getModule().createMenuItem("tree.mock.backends.popup.menu.create");
            this.add(createItem);
            createItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int childCount = adapterOutputContainer.getChildCount();
                    AdapterOutput adapterOutput = adapterOutputContainer.addAdapterOutput();
                    treeModel.nodeInserted(treePath, childCount, adapterOutput);
                }
            });
            JMenuItem selectItem = this.getModule().createMenuItem("Show in tree");
            this.add(selectItem);
            selectItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventController.fire((EventObject)new SelectInTreeEvent((Object)this, adapterOutputContainer.getId()));
                }
            });
        }
    }

    private static class AdapterOutputRenderer
    extends DefaultTreeCellRenderer {
        private static final String ADAPTER_ICON = "ch/e2e/builder/trace/images/adapter.icon.gif";

        private AdapterOutputRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ImageIcon icon = ImageLoader.loadIcon((String)ADAPTER_ICON, (boolean)true);
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            return this;
        }
    }

    private class SelectionDelegator
    implements CheckBoxTreeCellComponent.SelectionDelegator {
        private MockBackendsTree tree;

        public SelectionDelegator(MockBackendsTree tree) {
            this.tree = tree;
        }

        public void setSelected(Object object, boolean selected) {
            AdapterOutputContainer container = (AdapterOutputContainer)object;
            container.setUse(selected);
            TreePath path = this.tree.getSelectionPath();
            if (path != null) {
                if (selected && container.isLeaf()) {
                    AdapterOutput adapterOutput = container.addAdapterOutput();
                    ((AbstractTreeModel)this.tree.getModel()).nodeInserted(path, 0, (Object)adapterOutput);
                } else {
                    int index = MockBackendsPanel.this.treeModel.adapterOutputContainers.indexOf((Object)container);
                    MockBackendsPanel.this.treeModel.nodeChanged(path.getParentPath(), index, container);
                }
            }
        }

        public boolean isSelected(Object object) {
            return ((AdapterOutputContainer)object).isUse();
        }
    }

    private static class MockBackendsTreeCellRenderer
    extends TreeCellRendererDelegator {
        private MockBackendsTreeCellRenderer(RendererPreferences preferences, CheckBoxTreeCellComponent.SelectionDelegator selectionDelegator) {
            super((TreeCellRenderer)new WatchRenderer(preferences));
            AdapterOutputRenderer adapterOutputRenderer = new AdapterOutputRenderer();
            this.addRenderer(AdapterOutputContainer.class, (TreeCellRenderer)new CheckBoxTreeCellComponent((TreeCellRenderer)adapterOutputRenderer, selectionDelegator));
            this.addRenderer(AdapterOutput.class, adapterOutputRenderer);
        }
    }

    private class MockBackendsModel
    extends TestcaseRequestModel {
        private final AdapterOutputContainerPopupMenu adapterOutputContainerPopup;
        private final AdapterOutputPopupMenu adapterOutputPopup;
        private AdapterOutputContainerList adapterOutputContainers;

        public MockBackendsModel(E2EBuilderModule module) {
            super(module);
            this.adapterOutputContainerPopup = new AdapterOutputContainerPopupMenu(this, module);
            this.adapterOutputPopup = new AdapterOutputPopupMenu(this, module);
        }

        public void setAdapterOutputContainers(AdapterOutputContainerList adapterOutputContainers) {
            this.adapterOutputContainers = adapterOutputContainers;
            this.nodeStructureChanged(new TreePath(this.getRoot()));
        }

        @Override
        public Object getChild(Object parent, int index) {
            Object child = parent == this.getRoot() ? this.adapterOutputContainers.get(index) : (parent instanceof TreeObject ? ((TreeObject)parent).getChild(index) : super.getChild(parent, index));
            return child;
        }

        @Override
        public int getChildCount(Object parent) {
            int count = parent == this.getRoot() ? this.adapterOutputContainers.size() : (parent instanceof TreeObject ? ((TreeObject)parent).getChildCount() : super.getChildCount(parent));
            return count;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            if (path.getLastPathComponent() instanceof Parameter) {
                super.valueForPathChanged(path, newValue);
            }
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            int index = parent == this.getRoot() ? this.adapterOutputContainers.indexOf(child) : (parent instanceof TreeObject ? ((TreeObject)parent).getIndexOfChild(child) : super.getIndexOfChild(parent, child));
            return index;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        @Override
        public boolean isEditable(Object node) {
            return node instanceof AdapterOutputContainer || super.isEditable(node);
        }

        @Override
        public JPopupMenu getPopupMenu(TreePath[] paths) {
            Object popup = null;
            if (paths.length == 1) {
                Object object = paths[0].getLastPathComponent();
                if (object instanceof AdapterOutputContainer) {
                    popup = this.adapterOutputContainerPopup;
                    this.adapterOutputContainerPopup.setAdapterOutputContainer((AdapterOutputContainer)object, paths[0]);
                } else if (object instanceof AdapterOutput) {
                    popup = this.adapterOutputPopup;
                    this.adapterOutputPopup.setAdapterOutput((AdapterOutput)object, paths[0]);
                } else {
                    popup = super.getPopupMenu(paths);
                }
            }
            return popup;
        }
    }

    private class MockBackendsRenderer
    extends ParameterRenderer {
        private Component editorComponent;

        public MockBackendsRenderer(RendererPreferences preferences) {
            super(preferences);
        }

        @Override
        public void addEditor(Component editorComponent) {
            this.editorComponent = editorComponent;
            super.addEditor(editorComponent);
        }

        @Override
        public void removeEditor(Component editorComponent) {
            this.editorComponent = null;
            super.removeEditor(editorComponent);
        }

        @Override
        public Component getContainerComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            if (value instanceof TestcaseParameter) {
                return super.getContainerComponent(tree, value, selected, expanded, leaf, row);
            }
            if (this.editorComponent != null) {
                return this.editorComponent;
            }
            return new JLabel();
        }
    }

    private class MockBackendsTree
    extends Tree {
        private final E2EBuilderModule module;

        public MockBackendsTree(AbstractTreeModel treeModel, E2EBuilderModule module) {
            super(treeModel);
            this.module = module;
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.getSelectionModel().setSelectionMode(2);
            this.setEditable(true);
            this.setInvokesStopCellEditing(true);
            RendererPreferences preferences = new RendererPreferences(treeModel);
            CellEditor editor = new CellEditor((Tree)this, preferences);
            editor.setEditorContainer((EditorContainer)new MockBackendsRenderer(preferences));
            this.setCellEditor((TreeCellEditor)editor);
            final SelectionDelegator selectionDelegator = new SelectionDelegator(this);
            this.setCellRenderer((TreeCellRenderer)((Object)new MockBackendsTreeCellRenderer(preferences, selectionDelegator)));
            this.setEditor(AdapterOutputContainer.class, (TreeCellEditor)new CheckBoxTreeCellComponent((TreeCellRenderer)new AdapterOutputRenderer(), (CheckBoxTreeCellComponent.SelectionDelegator)selectionDelegator));
            this.setEditor(BooleanParameter.class, new BooleanEditor(this.module));
            this.setEditor(BigIntegerParameter.class, new BigIntegerEditor(this.module));
            this.setEditor(BigDecimalParameter.class, new BigDecimalEditor(this.module));
            this.setEditor(BlobParameter.class, new BlobEditor(this.module));
            this.setEditor(DateTimeParameter.class, new DateTimeCellEditor(this.module));
            this.setEditor(StringParameter.class, new StringEditor(this.module));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TreePath path = MockBackendsTree.this.getClosestPathForLocation(e.getX(), e.getY());
                    if (path != null) {
                        Object value = path.getLastPathComponent();
                        TreeCellRenderer renderer = ((TreeCellRendererDelegator)MockBackendsTree.this.getCellRenderer()).getRenderer(value.getClass());
                        if (renderer instanceof CheckBoxTreeCellRenderer) {
                            Rectangle bounds = MockBackendsTree.this.getPathBounds(path);
                            if (((CheckBoxTreeCellRenderer)renderer).isInCheckBox(e.getX() - bounds.x, e.getY() - bounds.y)) {
                                selectionDelegator.setSelected(value, !selectionDelegator.isSelected(value));
                            }
                        }
                    }
                }
            });
        }
    }
}

