/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.trace.gui.parameter;

import ch.e2e.builder.base.module.E2EBuilderModule;
import ch.e2e.builder.trace.testcase.parameter.FloatParameter;
import ch.e2e.swing.InputDoubleField;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.tree.TreeCellEditor;

public class FloatEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private static final int MIN_FRACTION_DIGITS = 0;
    private static final int MAX_FRACTION_DIGITS = 32;
    private static final int COLUMNS = 30;
    private InputDoubleField realEditor;
    private char decimalSeparator;
    private int defaultFractionDigits;
    private E2EBuilderModule module;

    public FloatEditor(E2EBuilderModule module) {
        this.module = module;
        this.realEditor = new InputDoubleField(Double.MIN_VALUE, Double.MAX_VALUE);
        this.realEditor.setBackground(Color.WHITE);
        this.realEditor.setOpaque(true);
        this.realEditor.setColumns(30);
        this.realEditor.setMaximumFractionDigits(32);
        this.realEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloatEditor.this.stopCellEditing();
            }
        });
        this.decimalSeparator = this.realEditor.getDecimalSeparator();
        this.defaultFractionDigits = this.realEditor.getFractionDigits();
    }

    @Override
    public Object getCellEditorValue() {
        return this.realEditor.getContent();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (value instanceof FloatParameter) {
            FloatParameter actualParameter = (FloatParameter)value;
            this.realEditor.setMinimumFractionDigits(0);
            this.realEditor.setContent(actualParameter.getValue());
        }
        return this.realEditor;
    }

    private int getFractionDigits(FloatParameter parameter) {
        String value = parameter.toString();
        int index = value.indexOf(this.decimalSeparator);
        return index == -1 ? this.defaultFractionDigits : value.length() - index - 1;
    }
}

