/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.builder.traceviewer.testcase;

import ch.e2e.builder.base.io.UniqueIdService;
import ch.e2e.builder.base.io.WrongIDFileVersionException;
import ch.e2e.builder.base.project.E2EBuilderProject;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcase;
import ch.e2e.builder.trace.testcase.AbstractSynchronousTestcaseRoot;
import ch.e2e.builder.trace.testcase.AbstractWSDLFolder;
import ch.e2e.builder.trace.testcase.Testcase;
import ch.e2e.builder.trace.testcase.TestcaseObject;
import ch.e2e.builder.traceviewer.testcase.WSDLFolder;
import ch.e2e.io.FileUtilities;
import ch.e2e.io.FilesNotDeletedException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SynchronousTestcaseRoot
extends AbstractSynchronousTestcaseRoot {
    public SynchronousTestcaseRoot(String name) {
        super(name);
    }

    public void projectChanged(E2EBuilderProject project) {
        this.clear();
        try {
            this.readWSDLFolders();
        }
        catch (WrongIDFileVersionException e) {
            e.printStackTrace();
        }
    }

    public void refresh() throws FilesNotDeletedException, WrongIDFileVersionException {
        this.clear();
        this.readWSDLFolders();
    }

    public AbstractWSDLFolder getWSDLFolder(String name, File home, File idFile) {
        return new WSDLFolder(name, home, idFile);
    }

    public ArrayList<String> getAllExistingWsdlFolder() {
        return new ArrayList<String>(this.getChildren().keySet());
    }

    public void saveTestcases() {
        for (Testcase testcase : this.getAllTestcases()) {
            AbstractSynchronousTestcase t = (AbstractSynchronousTestcase)testcase;
            t.saveRequest();
        }
    }

    private void refreshWSDLFolders() throws FilesNotDeletedException, WrongIDFileVersionException {
        ArrayList undeletedFiles = new ArrayList();
        ArrayList<File> allFolders = new ArrayList<File>(Arrays.asList(FileUtilities.getAllDirectories((File)this.getHome())));
        File wsdlIds = new File(this.getHome(), ".wsdl.folder.ids");
        HashMap ids = UniqueIdService.loadUniqueIds((File)wsdlIds);
        for (String name : ids.keySet()) {
            File wsdlFolder = new File(this.getHome(), (String)ids.get(name));
            File idFile = new File(wsdlFolder, ".synchronous.id");
            if (!idFile.exists()) continue;
            allFolders.remove(wsdlFolder);
            if (this.exists(name)) {
                try {
                    ((WSDLFolder)this.get(name)).reloadChildren(idFile);
                }
                catch (FilesNotDeletedException e) {
                    undeletedFiles.addAll(e.getFiles());
                }
                continue;
            }
            WSDLFolder newFolder = new WSDLFolder(name, wsdlFolder, idFile);
            if (newFolder.getChildCount() == 0) {
                System.out.println("The WSDL folder " + name + " is empty.");
                continue;
            }
            this.add((TestcaseObject)newFolder);
        }
        for (File wsdlDirectory : allFolders) {
            String folderName = wsdlDirectory.getName();
            if (!this.exists(folderName)) continue;
            try {
                this.delete((TestcaseObject)this.getChildren().get(folderName));
            }
            catch (FilesNotDeletedException e) {
                undeletedFiles.addAll(e.getFiles());
            }
        }
        if (!undeletedFiles.isEmpty()) {
            throw new FilesNotDeletedException(undeletedFiles);
        }
    }

    private void readWSDLFolders() throws WrongIDFileVersionException {
        File wsdlIds = new File(this.getHome(), ".wsdl.folder.ids");
        if (wsdlIds.exists()) {
            HashMap ids = UniqueIdService.loadUniqueIds((File)wsdlIds);
            for (String name : ids.keySet()) {
                File wsdlFolder = new File(this.getHome(), (String)ids.get(name));
                File idFile = new File(wsdlFolder, ".synchronous.id");
                if (!idFile.exists()) continue;
                WSDLFolder newFolder = new WSDLFolder(name, wsdlFolder, idFile);
                if (newFolder.getChildCount() == 0) {
                    System.out.println("The WSDL folder " + name + " is empty.");
                    continue;
                }
                this.add((TestcaseObject)newFolder);
            }
        } else {
            this.createWSDLFolderIds(wsdlIds);
        }
    }
}

