/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.template;

import ch.e2e.xuml.template.ResourceTemplate;
import ch.e2e.xuml.utils.OperatingSystemInfo;
import java.io.File;
import java.io.InputStream;

public class PlatformSpecificResourceTemplate
extends ResourceTemplate {
    private final String platform;

    public PlatformSpecificResourceTemplate(String resourceName, File targetFile, String platform) {
        super(resourceName, targetFile);
        this.platform = platform;
    }

    public PlatformSpecificResourceTemplate(String resourceName, File targetFile, String platform, ClassLoader classLoader) {
        super(resourceName, targetFile, classLoader);
        this.platform = platform;
    }

    @Override
    protected InputStream getResourceAsStream() {
        InputStream is = this.getResourceAsStream(this.platform);
        if (is == null) {
            is = this.getResourceAsStream(OperatingSystemInfo.getOsName().toString());
        }
        if (is == null) {
            is = super.getResourceAsStream();
        }
        return is;
    }

    private InputStream getResourceAsStream(String platformSpecificSuffix) {
        String resourceName = platformSpecificSuffix.isEmpty() ? this.getResourceName() : this.getResourceName() + "." + platformSpecificSuffix;
        return this.getClassLoader().getResourceAsStream(resourceName);
    }
}

