/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.xuml.settings.model;

import ch.e2e.crypto.CryptographyFactory;
import ch.e2e.crypto.Decrypt;
import ch.e2e.crypto.Encrypt;
import ch.e2e.dom.DomUtilities;
import ch.e2e.xuml.settings.SettingsException;
import ch.e2e.xuml.settings.model.Setting;
import ch.e2e.xuml.settings.model.SettingChange;
import ch.e2e.xuml.settings.utils.OverridesConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SettingChangesFactory {
    private static final String OVERRIDES_FILENAME = "overrides.xml";
    public static final String CHANGED_SETTINGS_FILENAME = "changedSettings.xml";
    private static final String TAG_DEFAULT = "default";
    private final File changedSettingsFile;

    public static Map<String, SettingChange> getSettingChanges(File serviceHomeDir) throws SettingsException {
        SettingChangesFactory factory = new SettingChangesFactory(serviceHomeDir);
        InputStream settingChangesStream = null;
        try {
            settingChangesStream = factory.getSettingChangesStream();
            Map<String, SettingChange> map = SettingChangesFactory.getSettingChanges(settingChangesStream);
            return map;
        }
        catch (IOException e) {
            throw new SettingsException(e);
        }
        finally {
            if (settingChangesStream != null) {
                try {
                    settingChangesStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Map<String, SettingChange> getSettingChanges(InputStream input) throws SettingsException {
        try {
            Document changedSettingsDoc = DomUtilities.parse((InputStream)SettingChangesFactory.getDecryptedInputStream(input), (boolean)false, (boolean)false, (boolean)false);
            return SettingChangesFactory.parseChangedSettingsDocument(changedSettingsDoc);
        }
        catch (IOException e) {
            throw new SettingsException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SettingsException(e);
        }
        catch (SAXException e) {
            throw new SettingsException(e);
        }
    }

    public static void serializeChangedSettings(File serviceHomeDir, Iterable<? extends Setting> settings) throws SettingsException {
        Document changedSettingsDoc = SettingChangesFactory.createDocumentStub();
        Element root = changedSettingsDoc.getDocumentElement();
        for (Setting setting : settings) {
            if (!setting.isChanged()) continue;
            SettingChange settingChange = new SettingChange(setting.getId(), setting.getValue(), setting.getReplacedValue());
            Element element = settingChange.toXml(changedSettingsDoc);
            root.appendChild(element);
        }
        try {
            OutputStream out = SettingChangesFactory.getEncryptedOutputStream(new File(serviceHomeDir, CHANGED_SETTINGS_FILENAME));
            DomUtilities.serialize((OutputStream)out, (Document)changedSettingsDoc, (boolean)true, (boolean)true);
        }
        catch (IOException e) {
            throw new SettingsException(e);
        }
        catch (TransformerException e) {
            throw new SettingsException(e);
        }
    }

    private InputStream getSettingChangesStream() throws IOException {
        if (this.existsChangedSettingsFile()) {
            return SettingChangesFactory.getDecryptedInputStream(this.changedSettingsFile);
        }
        return SettingChangesFactory.emptyInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToChangedSettingsFile(File overridesFile) throws IOException, SAXException, TransformerException, ParserConfigurationException {
        InputStream source = null;
        try {
            source = SettingChangesFactory.getDecryptedInputStream(overridesFile);
            Document changedSettingsDoc = new OverridesConverter().convert(source);
            OutputStream target = SettingChangesFactory.getEncryptedOutputStream(this.changedSettingsFile);
            DomUtilities.serialize((OutputStream)target, (Document)changedSettingsDoc, (boolean)true, (boolean)true);
            overridesFile.delete();
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private SettingChangesFactory(File serviceHomeDir) throws SettingsException {
        File overridesFile;
        this.changedSettingsFile = new File(serviceHomeDir, CHANGED_SETTINGS_FILENAME);
        if (!this.changedSettingsFile.exists() && (overridesFile = new File(serviceHomeDir, OVERRIDES_FILENAME)).exists()) {
            try {
                this.convertToChangedSettingsFile(overridesFile);
            }
            catch (IOException e) {
                throw new SettingsException(e);
            }
            catch (SAXException e) {
                throw new SettingsException(e);
            }
            catch (TransformerException e) {
                throw new SettingsException(e);
            }
            catch (ParserConfigurationException e) {
                throw new SettingsException(e);
            }
        }
    }

    private boolean existsChangedSettingsFile() {
        return this.changedSettingsFile.exists();
    }

    private static Map<String, SettingChange> parseChangedSettingsDocument(Document changedSettingsDoc) {
        NodeList elements = changedSettingsDoc.getElementsByTagName(TAG_DEFAULT);
        int nElements = elements.getLength();
        HashMap<String, SettingChange> settingChanges = new HashMap<String, SettingChange>(nElements);
        for (int i = 0; i < nElements; ++i) {
            SettingChange settingChange = new SettingChange((Element)elements.item(i));
            settingChanges.put(settingChange.getId(), settingChange);
        }
        return Collections.unmodifiableMap(settingChanges);
    }

    private static InputStream getDecryptedInputStream(File file) throws IOException {
        Decrypt decrypt = CryptographyFactory.getDecryption((String)"e2ecrypt01");
        return decrypt.getCipherInputStream(file);
    }

    private static InputStream getDecryptedInputStream(InputStream stream) throws IOException {
        Decrypt decrypt = CryptographyFactory.getDecryption((String)"e2ecrypt01");
        return decrypt.getCipherInputStream(stream);
    }

    private static OutputStream getEncryptedOutputStream(File file) throws IOException {
        Encrypt encrypt = CryptographyFactory.getEncryption((String)"e2ecrypt01");
        return encrypt.getCipherOutputStream(file);
    }

    private static Document createDocumentStub() {
        Document changedSettingsDoc = DomUtilities.newDocument((String)"overrides");
        changedSettingsDoc.getDocumentElement().setAttribute("version", "2.0");
        return changedSettingsDoc;
    }

    public static InputStream emptyInputStream() {
        return new EmptyInputStream();
    }

    private static class EmptyInputStream
    extends ByteArrayInputStream {
        private static final byte[] BYTES = EmptyInputStream.bytes();

        private EmptyInputStream() {
            super(BYTES);
        }

        private static byte[] bytes() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                DomUtilities.serialize((OutputStream)out, (Document)SettingChangesFactory.createDocumentStub(), (boolean)false);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            return out.toByteArray();
        }
    }
}

