package com.scheer.pas.large;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class ImageHandlingTest {

    private String imageId;

    @BeforeEach
    void setUp() {
        imageId = ImageHandling.newImage(new byte[0]);
    }

    @AfterEach
    void tearDown() {
        ImageHandling.releaseImage(imageId);
    }

    @Test
    void testNewImage() {
        assertNotNull(imageId);
    }

    @Test
    void testReleaseImage() {
        ImageHandling.releaseImage(imageId);
        assertThrows(IllegalStateException.class, () -> ImageHandling.getImageSize(imageId));
    }

    @Test
    void testGetImageSize() {
        assertEquals(-1, ImageHandling.getImageSize(imageId));
    }

    @Test
    void testGetImageWidth() {
        assertEquals(-1, ImageHandling.getImageWidth(imageId));
    }
    @Test
    void testGetImageHeight() {
        assertEquals(-1, ImageHandling.getImageHeight(imageId));
    }

    @Test
    void testProcessImage() {
        // ToDo: Implement test
    }
}
