package com.scheer.pas.large;

/**
 * Represents an image object with metadata and raw data.
 * The class encapsulates the image's size, width, height, and data, providing read-only access.
 */
public class Image {

    private final byte[] data;

    private final int size;
    private final int width;
    private final int height;

    /**
     * Constructs an Image object with the specified image data.
     * The image metadata such as size, width, and height are extracted
     * from the provided data during initialization.
     *
     * @param data the byte array containing the raw image data
     */
    public Image(byte[] data) {
        this.data = data;

        // get these values from the image data
        this.size = -1;
        this.width = -1;
        this.height = -1;
    }

    /**
     * Retrieves the size of the image.
     *
     * @return the size of the image in bytes
     */
    int getSize() {
        return size;
    }

    /**
     * Retrieves the width of the image.
     *
     * @return the width of the image
     */
    int getWidth() {
        return width;
    }

    /**
     * Retrieves the height of the image.
     *
     * @return the height of the image
     */
    int getHeight() {
        return height;
    }

    /**
     * Retrieves the raw data of the image.
     *
     * @return a byte array containing the raw image data
     */
    byte[] getData() {
        return data;
    }

}
