# Getting started with the Java xLib DevKit

The Java xLib DevKit supports you with the task to create an xUML library out of Java code.

## Java Development

- **Java SDK** needs to be set to a Java 11 SDK because gradle has to be run with Java 11.
- **Language level** should be set to version 8 because the jar files generated have to be Java 8 compatible.
- Configure your build properties in **local.properties** (see below for more details).

Find more about some development particularities in our documentation on [Java Development: Some Development Particularities](https://doc.scheer-pas.com/designer/?contextKey=java-xlib-devkit-particularities&version=latest).

## Build  Tasks (gradle)

- **build:** Triggers the complete build process.<br/>Use this script if you want to build the complete library from the source code. It assembles and tests the project (unit tests), generates a ZIP file, and sends it to your PAS system to get the xlib file in return.<br/>The xlib file is stored to **build/distributions**.
- **buildXlib:** Triggers the build process without performing the unit tests.<br/>Use this script if you do not need to perform the unit tests.
- **clean:** Triggers a cleaning of the build cache.<br/>Some stages are cached during the build process. A new xUML project ID will be used. Use this script if you are experiencing build errors you cannot find a reason for.

You can configure the gradle build in file **gradle.properties**. All these properties can be overwritten in file **local.properties**. This file is not checked in to Git. The file __local.properties_ is a template for file _local.properties_.

Find a detailed description of all configuration options in our documentation on [Java Development: Build Tasks](https://doc.scheer-pas.com/designer/?contextKey=java-xlib-build-tasks&version=latest).

## Documentation Reference
* [Sharing Designer Content](https://doc.scheer-pas.com/designer/?contextKey=sharing-designer-content&version=latest) pp.
* [Developing Designer Libraries Using Java](https://doc.scheer-pas.com/designer/?contextKey=java-xlib-devkit&version=latest) pp.