/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.ldap;

import ch.e2e.bridge.server.JavaAddOn;
import ch.e2e.bridge.server.Request;
import ch.e2e.bridge.server.RequestElement;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.ldap.Action;
import ch.e2e.bridge.server.ldap.GetAttributesAction;
import ch.e2e.bridge.server.ldap.LdapLogger;
import ch.e2e.bridge.server.session.Session;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;

public class LDAPAddOn
extends JavaAddOn {
    private Hashtable<Object, Object> environment;
    private Action action;

    public LDAPAddOn(String name) {
        super(name);
    }

    @Override
    protected void initialize(String name, Request request, ArrayList<String> initializeErrors) {
        RequestElement configuration = request.getAdditionalConfiguration();
        this.setEnvironment(configuration);
        this.setAction(configuration);
    }

    @Override
    public boolean execute(RecordItem inputItem, RecordItem outputItem, Session session) throws Exception {
        boolean result = false;
        if (this.action != null) {
            result = this.action.execute(inputItem, outputItem, session);
        }
        return result;
    }

    private void setEnvironment(RequestElement additionalConfiguration) {
        this.environment = new Hashtable();
        this.readConnection(additionalConfiguration);
        this.readSecurity(additionalConfiguration);
        this.environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAction(RequestElement requestElement) {
        try {
            InitialLdapContext context = new InitialLdapContext(this.environment, null);
            RequestElement actionElement = requestElement.getRequestElement("Action");
            String actionName = actionElement.getAttribute("name");
            if ("getAttributes".equals(actionName)) {
                this.action = new GetAttributesAction(context);
                return;
            }
            if (!"lookup".equals(actionName)) return;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private void readConnection(RequestElement additionalConfiguration) {
        RequestElement connectionElement = additionalConfiguration.getRequestElement("Connection");
        String protocol = connectionElement.getAttribute("protocol");
        String host = connectionElement.getAttribute("host");
        String port = connectionElement.getAttribute("port");
        String root = connectionElement.getAttribute("root");
        String providerUrl = protocol + "://" + host;
        if (port != null && port.length() != 0) {
            providerUrl = providerUrl + ":" + port;
        }
        providerUrl = providerUrl + "/";
        if (root != null && root.length() != 0) {
            providerUrl = providerUrl + root;
        }
        this.environment.put("java.naming.provider.url", providerUrl);
    }

    private void readSecurity(RequestElement additionalConfiguration) {
        RequestElement securityElement = additionalConfiguration.getRequestElement("Security");
        String authentication = securityElement.getAttribute("authentication");
        if (authentication.equals("simple")) {
            this.environment.put("java.naming.security.authentication", authentication);
            this.environment.put("java.naming.security.principal", securityElement.getAttribute("principal"));
            this.environment.put("java.naming.security.credentials", securityElement.getAttribute("credentials"));
        }
    }

    @Override
    protected void printStackTrace(Throwable t, String code) {
        LdapLogger.getInstance().debug(code, t);
    }
}

