/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.wrapper;

import ch.e2e.bridge.server.CyclicDependencyException;
import ch.e2e.bridge.server.Wrapper;
import ch.e2e.bridge.server.dataitem.IntegerItem;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.dataitem.StringItem;
import ch.e2e.bridge.server.jms.parameter.JMSReceiveParameter;
import ch.e2e.bridge.server.session.Session;

public class JMSReceiveParameterWrapper
extends Wrapper {
    private Class originalClass = JMSReceiveParameter.class;
    private boolean fill = false;

    public JMSReceiveParameterWrapper(Session session) {
        super(session);
    }

    public JMSReceiveParameterWrapper(RecordItem recordItem, Session session) {
        super(recordItem, session);
    }

    @Override
    public void fill(Object object) {
        if (this.fill) {
            throw new CyclicDependencyException(this.originalClass);
        }
        this.fill = true;
        JMSReceiveParameter value = (JMSReceiveParameter)object;
        this.setDestinationName(value.getDestinationName());
        this.setSelector(value.getSelector());
        this.setMillisecondsToWait(value.getMillisecondsToWait());
        this.fill = false;
    }

    @Override
    public Object createObject() {
        JMSReceiveParameter result = new JMSReceiveParameter();
        result.setDestinationName(this.getDestinationName());
        result.setSelector(this.getSelector());
        result.setMillisecondsToWait(this.getMillisecondsToWait());
        return result;
    }

    @Override
    protected String getFullQualifiedModelName() {
        return "urn:Base_Components.Add_Ons.JMS.JMSReceiveParameter";
    }

    private String getDestinationName() {
        StringItem stringItem = this.getRecordItem().getStringItem(0);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setDestinationName(String value) {
        this.setValue(0, value);
    }

    private String getSelector() {
        StringItem stringItem = this.getRecordItem().getStringItem(1);
        return stringItem == null ? null : stringItem.getValueAsString();
    }

    private void setSelector(String value) {
        this.setValue(1, value);
    }

    private long getMillisecondsToWait() {
        IntegerItem integerItem = this.getRecordItem().getIntegerItem(2);
        return integerItem == null ? -1L : integerItem.getValueAsLong();
    }

    private void setMillisecondsToWait(long millisecondsToWait) {
        this.setValue(2, millisecondsToWait);
    }
}

