/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.parameter;

import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.jms.ConnectionInfo;
import ch.e2e.bridge.server.session.Session;
import java.util.HashMap;
import java.util.Map;

public class JMSSessionParameter
implements Cloneable {
    private Map<String, String> properties;
    private boolean automaticReconnect = false;
    private ConnectionInfo connectionInfo = new ConnectionInfo();
    private Session session;
    private String id;

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.connectionInfo.setConnectionFactoryClassname(connectionFactoryClass);
        this.id = null;
    }

    public String getConnectionFactoryClass() {
        return this.connectionInfo.getConnectionFactoryClassname();
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
        this.id = null;
    }

    public Map<String, String> getProperties() {
        return this.properties == null ? new HashMap() : this.properties;
    }

    public boolean isAutomaticReconnect() {
        return this.automaticReconnect;
    }

    public void setAutomaticReconnect(boolean automaticReconnect) {
        this.automaticReconnect = automaticReconnect;
        this.id = null;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void mergeConnectionInfo(RecordItem item) {
        if (this.connectionInfo.merge(item)) {
            this.connectionInfo.resetId();
            this.id = null;
        }
    }

    public Object clone() {
        JMSSessionParameter parameter = new JMSSessionParameter();
        parameter.connectionInfo = (ConnectionInfo)this.connectionInfo.clone();
        parameter.automaticReconnect = this.automaticReconnect;
        parameter.properties = this.properties;
        parameter.session = null;
        parameter.id = this.id;
        return parameter;
    }

    public boolean equals(JMSSessionParameter sessionParameter) {
        return this.connectionInfo.equals(sessionParameter.connectionInfo) && this.getId().equals(sessionParameter.getId());
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof JMSSessionParameter && this.equals((JMSSessionParameter)obj);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    private String getId() {
        if (this.id == null) {
            StringBuilder idBuilder = new StringBuilder(this.connectionInfo.toString());
            idBuilder.append(this.automaticReconnect);
            if (this.properties != null) {
                for (String key : this.properties.keySet()) {
                    idBuilder.append(key).append(this.properties.get(key));
                }
            }
            this.id = idBuilder.toString();
        }
        return this.id;
    }
}

