/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.RequestInfo;
import javax.jms.JMSException;
import javax.jms.Message;

public class JMSRequestInfo
implements RequestInfo {
    private final String transactionId;
    private final String correlationId;
    private final String senderHost;
    private final String senderService;

    public static JMSRequestInfo from(Message message) {
        return new JMSRequestInfo(message);
    }

    private JMSRequestInfo(Message message) {
        this.transactionId = this.getStringProperty("xTransactionId", message);
        this.correlationId = this.get(() -> ((Message)message).getJMSMessageID());
        this.senderHost = this.getStringProperty("xSenderHost", message);
        this.senderService = this.getStringProperty("xSenderService", message);
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public String getSenderHost() {
        return this.senderHost;
    }

    @Override
    public String getSenderService() {
        return this.senderService;
    }

    private String getStringProperty(String name, Message message) {
        try {
            return message.getStringProperty(name);
        }
        catch (JMSException e) {
            return null;
        }
    }

    private String get(Getter getter) {
        try {
            return getter.get();
        }
        catch (JMSException e) {
            return null;
        }
    }

    @FunctionalInterface
    private static interface Getter {
        public String get() throws JMSException;
    }
}

