/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.BridgeError;
import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.Callback;
import ch.e2e.bridge.server.JavaVirtualMachine;
import ch.e2e.bridge.server.dataitem.ArrayItem;
import ch.e2e.bridge.server.dataitem.Item;
import ch.e2e.bridge.server.dataitem.ItemFactory;
import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.impl.JMSMessageListenerPool;
import ch.e2e.bridge.server.jms.impl.JMSRequestInfo;
import ch.e2e.bridge.server.jms.impl.ReceiveMessageAction;
import ch.e2e.bridge.server.session.Session;
import ch.e2e.bridge.server.session.SessionPool;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class JMSMessageListener
implements MessageListener {
    private String destination;
    private String selector;
    private final String callback;
    private final int messageType;
    private final JMSMessageListenerPool listenerPool;
    private MessageConsumer consumer;
    private javax.jms.Session session;
    private boolean processingMessage = false;
    private long tstamp = -1L;
    private long id;

    protected JMSMessageListener(String destination, String selector, String callback, int messageType, int index, JMSMessageListenerPool listenerPool) {
        this.destination = destination;
        this.selector = selector;
        this.callback = callback;
        this.messageType = messageType;
        this.listenerPool = listenerPool;
        this.id = System.currentTimeMillis() + (long)index;
    }

    public void onMessage(Message message) {
        this.invoke(message);
    }

    public void close() throws Exception {
        this.stop();
    }

    public void setConsumer(MessageConsumer consumer) {
        this.consumer = consumer;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getSelector() {
        return this.selector;
    }

    public javax.jms.Session getSession() {
        return this.session;
    }

    public void setSession(javax.jms.Session session) {
        this.session = session;
    }

    public boolean isProcessingMessage() {
        return this.processingMessage;
    }

    public long getTstamp() {
        return this.tstamp;
    }

    public long getId() {
        return this.id;
    }

    private void invoke(Message message) {
        JMSLogger.getInstance().debug("2", "JMS message received: " + message.toString());
        if (JavaVirtualMachine.shutdown) {
            throw new BridgeException("E2E runtime is shutting down");
        }
        this.processingMessage = true;
        this.listenerPool.borrowObject(this);
        boolean failed = true;
        SessionPool xumlSessionPool = SessionPool.getInstance();
        Session session = xumlSessionPool.createSession();
        try {
            RecordItem inputItem = ItemFactory.createRecordItem(session, null);
            RecordItem outputItem = ItemFactory.createRecordItem(session, null);
            ArrayItem errorItem = ItemFactory.createArrayItem(session);
            Item result = ReceiveMessageAction.createResultItem(session, message, this.messageType);
            inputItem.setItem(0L, result, true);
            Callback.invoke(this.callback, inputItem, outputItem, errorItem, JMSRequestInfo.from(message));
            if (Callback.failed(errorItem)) {
                BridgeError error = Callback.getBridgeError(session, errorItem);
                JMSLogger.getInstance().debug("7", String.format("invoke failed with [%s][%s][%s][%s]", error.getCategory(), error.getDomain(), error.getCode(), error.getDescription()));
                if (error.equals("JAVAADSM", "8")) {
                    this.stop();
                    throw new BridgeException("E2E runtime is shutting down");
                }
                this.rollback();
            } else {
                failed = false;
                this.commit();
            }
            this.tstamp = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.tstamp = -1L;
            throw new BridgeException("processing received JMS message failed", e);
        }
        finally {
            if (failed) {
                xumlSessionPool.rollbackSession(session.getSessionId());
            } else {
                xumlSessionPool.commitSession(session.getSessionId());
            }
            this.processingMessage = false;
            this.listenerPool.returnObject(this);
        }
    }

    private void commit() {
        try {
            if (this.session != null && this.session.getTransacted()) {
                this.session.commit();
                JMSLogger.getInstance().debug("4", "JMS session comitted");
            }
        }
        catch (Exception e) {
            throw new BridgeException("Commiting JMS session failed", e, "JMS7");
        }
    }

    private void rollback() throws JMSException {
        if (this.session != null && this.session.getTransacted()) {
            this.session.rollback();
            JMSLogger.getInstance().debug("5", "JMS session rollback");
        }
    }

    public void stop() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
    }
}

