/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.JavaVirtualMachine;
import ch.e2e.bridge.server.jms.ConnectionInfo;
import ch.e2e.bridge.server.jms.JMSInitialContext;
import ch.e2e.bridge.server.jms.JMSLogger;
import ch.e2e.bridge.server.jms.PoolConfig;
import ch.e2e.bridge.server.jms.impl.JMSAddOnHelper;
import ch.e2e.bridge.server.jms.impl.JMSMessageListener;
import ch.e2e.bridge.server.jms.impl.JMSSessionFactory;
import ch.e2e.bridge.server.jms.impl.JavaBeanHelper;
import ch.e2e.bridge.server.jms.impl.MessageReceiver;
import ch.e2e.bridge.server.jms.impl.MessageSender;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import ch.e2e.bridge.server.jms.parameter.JMSWrapperException;
import ch.e2e.bridge.server.session.SessionObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ConnectionAdapter
implements ExceptionListener,
SessionObject {
    private static boolean firstTry = true;
    private Map<String, Session> sessions = new HashMap<String, Session>();
    private ArrayList<Session> defaultSessions = new ArrayList();
    private Map<String, MessageReceiver> receivers = new HashMap<String, MessageReceiver>();
    private Map<String, MessageSender> senders = new HashMap<String, MessageSender>();
    private ArrayList<JMSMessageListener> messageListeners = new ArrayList();
    private Connection connection;
    private JMSSessionParameter sessionParameter;
    private static final int TIME_BETWEEN_RECONNECT_TRIES_IN_MILLI_SECONDS = 1000;
    private JMSInitialContext initialContext;
    private GenericObjectPool<Session> sessionPool;
    private final JMSSessionFactory sessionFactory;

    public ConnectionAdapter(JMSSessionParameter sessionParameter, PoolConfig sessionPoolConfig) {
        this.sessionParameter = sessionParameter;
        this.sessionFactory = new JMSSessionFactory(sessionParameter);
        this.sessionPool = new GenericObjectPool((PoolableObjectFactory)this.sessionFactory);
        JMSLogger.getInstance().debug("16", "ConnectionAdapter(28.06. 13:15).<init>: Initializing SessionPool with " + sessionPoolConfig);
        this.sessionPool.setMaxActive(sessionPoolConfig.getMaxTotal());
        this.sessionPool.setMinIdle(sessionPoolConfig.getMinIdle());
        this.sessionPool.setMaxIdle(sessionPoolConfig.getMaxIdle());
        this.sessionPool.setMinEvictableIdleTimeMillis((long)sessionPoolConfig.getMinEvictableIdleTimeMillis());
        this.sessionPool.setTimeBetweenEvictionRunsMillis((long)sessionPoolConfig.getTimeBetweenEvictionRunsMillis());
        this.sessionPool.setNumTestsPerEvictionRun(sessionPoolConfig.getNumTestsPerEvictionRun());
        this.sessionPool.setMaxWait(sessionPoolConfig.getMaxWaitSec() > 0L ? sessionPoolConfig.getMaxWaitSec() * 1000L : sessionPoolConfig.getMaxWaitSec());
    }

    public JMSInitialContext getInitialContext() {
        return this.initialContext;
    }

    public MessageReceiver getReceiver(String sessionId) throws Exception {
        MessageReceiver receiver = this.receivers.get(sessionId);
        if (receiver == null) {
            receiver = new MessageReceiver(this.getSession(sessionId), this);
            this.receivers.put(sessionId, receiver);
        }
        return receiver;
    }

    public MessageSender getSender(String sessionId) throws Exception {
        MessageSender sender = this.senders.get(sessionId);
        if (sender == null) {
            sender = new MessageSender(this.getSession(sessionId), this);
            this.senders.put(sessionId, sender);
        }
        return sender;
    }

    public void removeJMSSession(String sessionId) {
        this.clearReceiverAndSender(sessionId);
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            try {
                this.sessionPool.invalidateObject((Object)session);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sessions.remove(sessionId);
        }
    }

    private void setProperties(JMSSessionParameter sessionParameter, ConnectionFactory connectionFactory) throws JMSWrapperException {
        try {
            JavaBeanHelper.setProperties(sessionParameter.getProperties(), connectionFactory);
            JavaBeanHelper.setProperties(sessionParameter.getConnectionInfo().getProperties(), connectionFactory);
        }
        catch (Exception e) {
            throw new JMSWrapperException(String.format("Class '%s' does not support property '%s", connectionFactory.getClass().getName(), e.getMessage()));
        }
    }

    public Session getSession(String sessionId) throws Exception {
        Session session;
        if (this.connection == null) {
            this.connect();
        }
        if ((session = this.sessions.get(sessionId)) == null) {
            try {
                session = (Session)this.sessionPool.borrowObject();
            }
            catch (NoSuchElementException e) {
                throw new BridgeException(e, "TIMEOUT_BORROW_SESSION");
            }
            this.sessions.put(sessionId, session);
        }
        return session;
    }

    public void close() throws Exception {
        try {
            this.sessionPool.clear();
            this.sessionPool.close();
            for (Session session : this.defaultSessions) {
                JMSLogger.getInstance().debug("12", String.format("ConnectionAdapter.close: Closing session [%s].", session));
                session.close();
            }
            if (this.connection != null) {
                JMSLogger.getInstance().debug("14", String.format("ConnectionAdapter.close: Closing connection [%s].", this));
                this.connection.close();
            }
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.setExceptionListener(null);
                }
            }
            catch (Exception exception) {}
            this.connection = null;
            this.initialContext.close();
        }
    }

    public void onException(JMSException jmsException) {
        this.sessionPool.clear();
        this.sessions.clear();
        this.defaultSessions.clear();
        this.reconnect((Exception)((Object)jmsException));
    }

    private void reconnect(Exception ex) {
        if (!JavaVirtualMachine.shutdown && this.sessionParameter != null && this.sessionParameter.isAutomaticReconnect()) {
            JMSLogger.getInstance().error("JMS9", "ConnectionAdapter.reconnect: lost JMS connection (will try to reconnect every 1000 milliseconds). Reason: " + ex.toString());
            this.printStackTraceOnce(ex);
            while (!JavaVirtualMachine.shutdown) {
                try {
                    this.connect();
                    if (!JavaVirtualMachine.shutdown) {
                        JMSLogger.getInstance().info("9", "ConnectionAdapter.reconnect: JMS reconnected successfully");
                        for (JMSMessageListener messageListener : this.messageListeners) {
                            this.appendListener(messageListener);
                        }
                    }
                    break;
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        JMSLogger.getInstance().error("JMS3", "ConnectionAdapter.reconnect: give up JMS reconnect because thread is cancelled");
                        break;
                    }
                }
            }
        } else {
            JMSLogger.getInstance().error("JMS9", String.format("ConnectionAdapter.reconnect: lost JMS connection. Reason: %s\nTrying to reconnect on next JMS action.", ex.toString()));
            this.printStackTraceOnce(ex);
            try {
                this.connection.setExceptionListener(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
            this.sessions.clear();
        }
    }

    private void printStackTraceOnce(Exception ex) {
        if (firstTry) {
            firstTry = false;
            JMSLogger.getInstance().debug("JMS9", ex);
        }
    }

    public boolean isTransacted() {
        return this.sessionParameter.getConnectionInfo().getTransacted();
    }

    public int getAcknowledgeMode() {
        return this.sessionParameter.getConnectionInfo().getAcknowledgeMode();
    }

    public boolean isDestroyable() {
        return this.sessions.size() == 0 && this.defaultSessions.size() == 0;
    }

    private void connect() throws Exception {
        if (!JavaVirtualMachine.shutdown) {
            try {
                this.doConnect();
            }
            catch (Exception e) {
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connection = null;
                }
                throw e;
            }
        }
    }

    private void doConnect() throws NamingException, JMSException {
        this.connection = this.sessionParameter.getConnectionInfo().isNamingConnection() ? this.createNamedConnection(this.sessionParameter.getConnectionInfo()) : this.createConnection();
        this.connection.setExceptionListener((ExceptionListener)this);
        this.connection.start();
        this.sessionFactory.setConnection(this.connection);
    }

    private Connection createConnection() throws JMSException {
        ConnectionFactory connectionFactory;
        try {
            Class<?> connectionFactoryClass = Class.forName(this.sessionParameter.getConnectionFactoryClass(), true, ClassLoader.getSystemClassLoader());
            connectionFactory = (ConnectionFactory)connectionFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw new JMSWrapperException(String.format("Creating class ConnectionFactory '%s' failed: %s", this.sessionParameter.getConnectionFactoryClass(), e.getMessage()));
        }
        this.setProperties(this.sessionParameter, connectionFactory);
        String user = this.sessionParameter.getConnectionInfo().getUser();
        Connection connection = user == null ? connectionFactory.createConnection() : connectionFactory.createConnection(user, this.sessionParameter.getConnectionInfo().getPassword());
        return connection;
    }

    private Connection createNamedConnection(ConnectionInfo connectionInfo) throws NamingException, JMSException {
        JMSLogger.getInstance().debug("JMS14", "Opening connection '" + connectionInfo.getName() + "'");
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("java.naming.factory.initial", connectionInfo.getInitialContextFactory());
        properties.put("java.naming.provider.url", connectionInfo.getURL());
        properties.put("java.naming.security.principal", this.sessionParameter.getConnectionInfo().getUser() == null ? "" : this.sessionParameter.getConnectionInfo().getUser());
        properties.put("java.naming.security.credentials", this.sessionParameter.getConnectionInfo().getPassword() == null ? "" : this.sessionParameter.getConnectionInfo().getPassword());
        properties.putAll(connectionInfo.getProperties());
        properties.putAll(this.sessionParameter.getProperties());
        this.initialContext = new JMSInitialContext(properties);
        try {
            Object cfLookup = this.initialContext.lookup(connectionInfo.getConnectionFactoryName());
            if (!(cfLookup instanceof ConnectionFactory)) {
                throw new BridgeException("Could not create the connection factory.\nPossible reasons:\nWrong username or password\nNot all necessary jarfiles are added to the classpath.", "910");
            }
            ConnectionFactory connectionFactory = (ConnectionFactory)cfLookup;
            String user = this.sessionParameter.getConnectionInfo().getUser();
            Connection connection = user == null ? connectionFactory.createConnection() : connectionFactory.createConnection(user, this.sessionParameter.getConnectionInfo().getPassword());
            return connection;
        }
        catch (JMSException | NamingException jex) {
            this.initialContext.close();
            throw jex;
        }
    }

    @Override
    public void commit(String sessionId) {
        JMSLogger.getInstance().debug("4", "ConnectionAdapter.commit: Committing runtime session " + sessionId);
        this.clearReceiverAndSender(sessionId);
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            try {
                this.commitAndReturn(session);
            }
            finally {
                this.sessions.remove(sessionId);
            }
        }
    }

    @Override
    public void rollback(String sessionId) {
        this.clearReceiverAndSender(sessionId);
        Session session = this.sessions.get(sessionId);
        if (session != null) {
            try {
                this.sessionPool.returnObject((Object)session);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sessions.remove(sessionId);
        }
    }

    private void clearReceiverAndSender(String sessionId) {
        if (this.receivers.containsKey(sessionId)) {
            MessageReceiver receiver = this.receivers.get(sessionId);
            receiver.close();
            this.receivers.remove(sessionId);
        }
        if (this.senders.containsKey(sessionId)) {
            MessageSender sender = this.senders.get(sessionId);
            sender.close();
            this.senders.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitAndReturn(Session session) {
        block17: {
            try {
                if (!session.getTransacted()) break block17;
                try {
                    JMSLogger.getInstance().debug("4", String.format("ConnectionAdapter.commitAndReturn: Committing session [%s].", session));
                    session.commit();
                    JMSLogger.getInstance().debug("4", String.format("ConnectionAdapter.commitAndReturn: JMS session [%s] comitted", session));
                }
                catch (JMSException e) {
                    try {
                        session.rollback();
                    }
                    catch (Exception e2) {
                        JMSLogger.getInstance().debug("4", String.format("ConnectionAdapter.commitAndReturn: Exception during rollback of session [%s]. Removing session.", session));
                    }
                    finally {
                        this.sessionPool.invalidateObject((Object)session);
                    }
                }
                catch (Exception e) {
                    JMSLogger.getInstance().debug("4", String.format("ConnectionAdapter.commitAndReturn: Exception during commit of session [%s].", session));
                    session.rollback();
                    throw e;
                }
            }
            catch (Exception e) {
                throw new BridgeException(String.format("Commiting JMS session [%s] failed", session == null ? "null" : session.toString()), e, "JMS7");
            }
            finally {
                try {
                    this.sessionPool.returnObject((Object)session);
                }
                catch (Exception e) {
                    JMSLogger.getInstance().debug("4", "ConnectionAdapter.commitAndReturn: Exception during return session to pool.");
                }
            }
        }
    }

    public void registerListener(JMSMessageListener listener) throws JMSException, NamingException {
        this.messageListeners.add(listener);
        if (this.connection == null) {
            try {
                this.connect();
                this.appendListener(listener);
            }
            catch (Exception e) {
                this.reconnect(e);
            }
        } else {
            this.appendListener(listener);
        }
    }

    private void appendListener(JMSMessageListener listener) {
        try {
            Session session = this.createListenerSession();
            Destination destination = JMSAddOnHelper.getDestination(listener.getDestination(), session, this.initialContext);
            MessageConsumer consumer = session.createConsumer(destination, listener.getSelector());
            consumer.setMessageListener((MessageListener)listener);
            listener.setConsumer(consumer);
            listener.setSession(session);
        }
        catch (JMSException | NamingException e) {
            JMSLogger.getInstance().error("13", "ConnectionAdapter.appendListener: " + e.getMessage());
        }
    }

    private Session createListenerSession() throws JMSWrapperException {
        try {
            JMSLogger.getInstance().debug("11", "ConnectionAdapter.createListenerSession: Creating new session");
            long time = new Date().getTime();
            Session session = this.connection.createSession(this.sessionParameter.getConnectionInfo().getTransacted(), this.sessionParameter.getConnectionInfo().getAcknowledgeMode());
            this.defaultSessions.add(session);
            JMSLogger.getInstance().debug("11", String.format("ConnectionAdapter.createListenerSession: Creating session took %sms.", new Date().getTime() - time));
            return session;
        }
        catch (Exception e) {
            throw new JMSWrapperException(String.format("Creating session for '%s' failed: %s.", this.sessionParameter.getConnectionInfo().getName(), e.getMessage()));
        }
    }
}

