/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.dataitem.RecordItem;
import ch.e2e.bridge.server.jms.impl.BaseAction;
import ch.e2e.bridge.server.jms.parameter.JMSMessageType;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import ch.e2e.bridge.server.jms.wrapper.JMSSessionParameterWrapper;
import ch.e2e.bridge.server.session.Session;

public abstract class BaseSynchronAction
extends BaseAction {
    public BaseSynchronAction(JMSMessageType messageType, JMSSessionParameter sessionParameter) {
        super(messageType, sessionParameter);
    }

    @Override
    public boolean execute(RecordItem inputItem, RecordItem outputItem, Session session) throws Exception {
        JMSSessionParameter sessionParameter = this.createSessionParameter(inputItem, session);
        return this.execute(inputItem, outputItem, sessionParameter);
    }

    @Override
    public void start() {
    }

    protected abstract boolean execute(RecordItem var1, RecordItem var2, JMSSessionParameter var3) throws Exception;

    protected JMSSessionParameter createSessionParameter(RecordItem inputItem, Session session) {
        JMSSessionParameter localSessionParameter;
        if (this.getSessionParameter() == null) {
            localSessionParameter = (JMSSessionParameter)session.createObject((RecordItem)inputItem.getItem(0L), JMSSessionParameterWrapper.class);
        } else {
            localSessionParameter = (JMSSessionParameter)this.getSessionParameter().clone();
            localSessionParameter.mergeConnectionInfo((RecordItem)inputItem.getItem(2L));
        }
        localSessionParameter.setSession(session);
        return localSessionParameter;
    }
}

