/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server.jms.impl;

import ch.e2e.bridge.server.BridgeException;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapter;
import ch.e2e.bridge.server.jms.impl.ConnectionAdapterPool;
import ch.e2e.bridge.server.jms.impl.IAction;
import ch.e2e.bridge.server.jms.parameter.JMSMessageType;
import ch.e2e.bridge.server.jms.parameter.JMSSessionParameter;
import java.util.NoSuchElementException;

public abstract class BaseAction
implements IAction {
    private JMSSessionParameter sessionParameter;
    private JMSMessageType messageType;

    public BaseAction(JMSMessageType messageType, JMSSessionParameter sessionParameter) {
        this.messageType = messageType;
        this.sessionParameter = sessionParameter;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void stop() throws Exception {
    }

    public JMSSessionParameter getSessionParameter() {
        return this.sessionParameter;
    }

    public int getMessageType() {
        return this.messageType.getMessageType();
    }

    protected ConnectionAdapter borrowConnection(JMSSessionParameter sessionParameter) throws Exception {
        try {
            ConnectionAdapter result = ConnectionAdapterPool.getInstance().borrowObject(sessionParameter);
            sessionParameter.getSession().putSessionObject(result.toString(), result);
            return result;
        }
        catch (NoSuchElementException e) {
            throw new BridgeException(e, "TIMEOUT_BORROW_CONNECTION");
        }
    }

    protected void returnConnection(JMSSessionParameter sessionParameter, ConnectionAdapter connection) throws Exception {
        ConnectionAdapterPool.getInstance().returnObject(sessionParameter, connection);
    }
}

