/*
 * Decompiled with CFR 0.152.
 */
package ch.e2e.bridge.server;

import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestElement {
    private HashMap<String, ArrayList<RequestElement>> requestElements = new HashMap();
    private HashMap<String, String> attributes = new HashMap();
    private String value;

    public RequestElement(Node requestElement) {
        this.readElements(requestElement);
        this.readAttributes(requestElement);
        if (requestElement.hasChildNodes() && requestElement.getFirstChild().getNodeType() == 3) {
            this.value = requestElement.getFirstChild().getNodeValue();
        }
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public RequestElement getRequestElement(String name) {
        RequestElement result = null;
        ArrayList<RequestElement> elements = this.requestElements.get(name);
        if (elements != null) {
            result = elements.get(0);
        }
        return result;
    }

    public ArrayList<RequestElement> getRequestElements(String name) {
        return this.requestElements.get(name);
    }

    public String getValue() {
        return this.value;
    }

    private void readElements(Node requestElement) {
        NodeList children = requestElement.getChildNodes();
        if (children != null) {
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                this.getRequestElementsList(name).add(new RequestElement(child));
            }
        }
    }

    private ArrayList<RequestElement> getRequestElementsList(String name) {
        ArrayList<RequestElement> result = this.requestElements.get(name);
        if (result == null) {
            result = new ArrayList();
            this.requestElements.put(name, result);
        }
        return result;
    }

    private void readAttributes(Node requestElement) {
        NamedNodeMap attributes = requestElement.getAttributes();
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)attributes.item(i);
                this.attributes.put(attr.getName(), attr.getValue());
            }
        }
    }
}

