/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.xlibdoc.util;

import ch.e2e.bridge.server.BridgeJavaCallback;
import ch.e2e.bridge.server.BridgeJavaService;
import ch.e2e.bridge.server.BridgeJavaServiceStartStopInterface;
import com.scheer.xlibdoc.model.Xlib;
import com.scheer.xlibdoc.model.XlibClass;
import com.scheer.xlibdoc.model.XlibMethod;
import com.scheer.xlibdoc.model.XlibParameter;
import com.scheer.xlibdoc.model.XlibProperty;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.util.DocTrees;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner8;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import jdk.javadoc.doclet.DocletEnvironment;

public class XlibElementScanner
extends ElementScanner8<Void, Void> {
    private final DocTrees docTrees;
    private final Types typeUtils;
    private final TypeMirror javaCallbackType;
    private final TypeMirror javaServiceType;
    private final List<String> javaServiceMethodNames;
    private final Xlib xlib = new Xlib();
    private XlibClass currentClass;
    private XlibClass currentInterface;
    private XlibMethod currentMethod;

    public XlibElementScanner(DocletEnvironment environment) {
        Elements elementUtils = environment.getElementUtils();
        this.docTrees = environment.getDocTrees();
        this.typeUtils = environment.getTypeUtils();
        this.javaCallbackType = elementUtils.getTypeElement(BridgeJavaCallback.class.getName()).asType();
        this.javaServiceType = this.typeUtils.erasure(elementUtils.getTypeElement(BridgeJavaService.class.getName()).asType());
        this.javaServiceMethodNames = Stream.concat(Stream.of(BridgeJavaService.class.getMethods()), Stream.of(BridgeJavaServiceStartStopInterface.class.getMethods())).map(Method::getName).collect(Collectors.toList());
    }

    public Xlib getLibrary() {
        return this.xlib;
    }

    @Override
    public Void visitType(TypeElement e, Void unused) {
        this.initVisitType();
        if (XlibElementScanner.isPublicClass(e)) {
            this.currentClass = this.xlib.addClass(new XlibClass(e, this.docTrees.getDocCommentTree(e)));
        } else if (this.isJavaCallback(e)) {
            this.currentInterface = this.xlib.addClass(new XlibClass(e, this.docTrees.getDocCommentTree(e)));
        }
        return (Void)super.visitType(e, unused);
    }

    private static boolean isPublicClass(TypeElement e) {
        return e.getKind() == ElementKind.CLASS && e.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private boolean isJavaCallback(TypeElement e) {
        return e.getKind() == ElementKind.INTERFACE && this.typeUtils.isAssignable(e.asType(), this.javaCallbackType);
    }

    private void initVisitType() {
        this.currentClass = null;
        this.currentInterface = null;
        this.currentMethod = null;
    }

    @Override
    public Void visitExecutable(ExecutableElement e, Void unused) {
        this.initVisitExecutable();
        if (e.getKind() == ElementKind.METHOD) {
            if (this.currentClass != null) {
                if (e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.currentMethod = this.currentClass.addMethod(new XlibMethod(e, this.docTrees.getDocCommentTree(e)));
                } else if (this.isJavaService(e.getEnclosingElement()) && this.isJavaServiceMethod(e)) {
                    this.currentMethod = this.currentClass.addMethod(new XlibMethod(e, this.docTrees.getDocCommentTree(e)));
                }
            } else if (this.currentInterface != null) {
                this.currentMethod = this.currentInterface.addMethod(new XlibMethod(e, this.docTrees.getDocCommentTree(e)));
            }
        }
        return (Void)super.visitExecutable(e, unused);
    }

    private void initVisitExecutable() {
        this.currentMethod = null;
    }

    private boolean isJavaService(Element e) {
        return this.typeUtils.isAssignable(e.asType(), this.javaServiceType);
    }

    private boolean isJavaServiceMethod(ExecutableElement e) {
        return this.javaServiceMethodNames.contains(e.getSimpleName().toString());
    }

    @Override
    public Void visitVariable(VariableElement e, Void unused) {
        if (this.isProperty(e)) {
            if (this.currentClass != null) {
                this.currentClass.addProperty(new XlibProperty(e, this.getDocCommentTree(e)));
            }
        } else if (this.isParameter(e) && this.currentMethod != null) {
            this.currentMethod.addParameter(new XlibParameter(e, this.getParamTree(e)));
        }
        return (Void)super.visitVariable(e, unused);
    }

    private DocCommentTree getDocCommentTree(VariableElement e) {
        return this.docTrees.getDocCommentTree(e);
    }

    private boolean isProperty(VariableElement field) {
        return XlibElementScanner.isPrivateField(field) && this.hasGetterAndSetter(field);
    }

    private static boolean isPrivateField(VariableElement field) {
        return field.getKind() == ElementKind.FIELD && field.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    private boolean hasGetterAndSetter(VariableElement field) {
        return field.getEnclosingElement().getEnclosedElements().stream().filter(this::isPublicMethod).filter(method -> this.isGetterOrSetter((ExecutableElement)method, field)).count() == 2L;
    }

    private boolean isPublicMethod(Element e) {
        return e.getKind() == ElementKind.METHOD && e.getModifiers().contains((Object)Modifier.PUBLIC) && !e.getModifiers().contains((Object)Modifier.STATIC);
    }

    private boolean isGetterOrSetter(ExecutableElement method, VariableElement field) {
        return this.isGetter(method, field) || this.isSetter(method, field);
    }

    private boolean isGetter(ExecutableElement method, VariableElement field) {
        String fieldName = XlibElementScanner.makeFirstCharUppercase(field.getSimpleName().toString());
        return method.getParameters().isEmpty() && method.getReturnType().equals(field.asType()) && (method.getSimpleName().toString().equals("get" + fieldName) || method.getSimpleName().toString().equals("is" + fieldName));
    }

    private boolean isSetter(ExecutableElement method, VariableElement field) {
        String fieldName = XlibElementScanner.makeFirstCharUppercase(field.getSimpleName().toString());
        return method.getParameters().size() == 1 && method.getParameters().get(0).asType().equals(field.asType()) && method.getReturnType().getKind().equals((Object)TypeKind.VOID) && method.getSimpleName().toString().equals("set" + fieldName);
    }

    private static String makeFirstCharUppercase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private boolean isParameter(VariableElement e) {
        return e.getKind() == ElementKind.PARAMETER;
    }

    private ParamTree getParamTree(VariableElement param) {
        DocCommentTree docCommentTree = this.docTrees.getDocCommentTree(param.getEnclosingElement());
        return docCommentTree == null ? null : (ParamTree)docCommentTree.getBlockTags().stream().filter(blockTag -> XlibElementScanner.isMatchingBlockTag(blockTag, param)).findFirst().orElse(null);
    }

    private static boolean isMatchingBlockTag(DocTree blockTag, VariableElement param) {
        return blockTag.getKind().equals((Object)DocTree.Kind.PARAM) && ((ParamTree)blockTag).getName().getName().equals(param.getSimpleName());
    }
}

