/*
 * Decompiled with CFR 0.152.
 */
package com.scheer.xlibdoc.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.scheer.xlibdoc.model.XlibMethod;
import com.scheer.xlibdoc.model.XlibProperty;
import com.scheer.xlibdoc.util.XlibDocTreeScanner;
import com.sun.source.doctree.DocTree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.TypeElement;

public class XlibClass {
    @JsonProperty(required=true)
    private final String qualifiedName;
    @JsonProperty(required=true)
    private final String name;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final List<XlibMethod> methods = new ArrayList<XlibMethod>();
    @JsonProperty
    private final List<XlibProperty> properties = new ArrayList<XlibProperty>();

    public XlibClass(TypeElement e, DocTree docTree) {
        this.name = e.getSimpleName().toString();
        this.qualifiedName = e.getQualifiedName().toString();
        this.description = XlibDocTreeScanner.newScanner(docTree).getDescription();
    }

    public XlibMethod addMethod(XlibMethod method) {
        this.methods.add(method);
        return method;
    }

    public void addProperty(XlibProperty property) {
        this.properties.add(property);
    }
}

