/**
 * Copyright: E2E Technologies Ltd
 * Author: Cyril Schmitt <cschmitt@e2ebridge.com>
 */
"use strict";

var express = require('express');
var fs = require('fs');
var e2eLogger = require('e2e-transaction-logger');

function sapGetCustomer(id, cb){
    // simulate a sap call
    setTimeout(function() {
        cb((Math.random() > 0.5)?'Sap Error':null, {
            id: id,
            name: 'My Customer'
        });
    },Math.floor(Math.random() * 3000));
}

function dbGetCustomerDetail(customer, cb){
    // simulate a DB call
    setTimeout(function() {
        customer.job = 'Best Job';
        cb((Math.random() > 0.5)?'DB Error':null, customer);
    },Math.floor(Math.random() * 1000));
}

var app = express();
app.use(e2eLogger.transactionLoggerMiddleware());

app.get('/hello',function(req, res){

    var io = req.trx.startIO('Read','FILE','Hello.html');
    fs.readFile(__dirname + '/Hello.html',function(err, data){
        io.end('OK');

        res.writeHead(200, {'Content-Type': 'text/html'});
        res.end(data);
    });
});

app.get('/goodbye', function(req, res){
    res.writeHead(200, {'Content-Type': 'text/plain'});
    res.end('Good Bye\n');
});

app.get('/do-something', function(req, res){
    var io = req.trx.startIO('GetCustomer', 'SAP', 'http://sap.e2e.ch:3000/');
    sapGetCustomer(1, function(err, customer){
        if(err){
            io.end(false);
            res.writeHead(500, {'Content-Type': 'application/json'});
            res.end(JSON.stringify(err));
            return;
        }
        io.end();

        io = req.trx.startIO('GetCustomerDetail', 'DB', 'localhost/mongodb/');
        dbGetCustomerDetail(customer, function(err, customerWithDetail){
            if(err){
                io.end(false);
                res.writeHead(200, {'Content-Type': 'application/json'});
                res.end(JSON.stringify(customer));
                return;
            }
            io.end();

            res.writeHead(200, {'Content-Type': 'application/json'});
            res.end(JSON.stringify(customerWithDetail));
        });
    });
});

app.listen(1337, function() {
    console.log('Server running at http://127.0.0.1:1337/');
});