/**
 * Author: Cyril Schmitt <cschmitt@e2ebridge.com>
 * Copyright: E2E Technologies Ltd
 */
"use strict";

var http = require('http');
var fs = require('fs');
var e2eLogger = require('e2e-transaction-logger');

function sapGetCustomer(id, cb){
    // simulate a sap call
    setTimeout(function() {
        cb((Math.random() > 0.5)?'Sap Error':null, {
            id: id,
            name: 'My Customer'
        });
    },Math.floor(Math.random() * 3000));
}

function dbGetCustomerDetail(customer, cb){
    // simulate a DB call
    setTimeout(function() {
        customer.job = 'Best Job';
        cb((Math.random() > 0.5)?'DB Error':null, customer);
    },Math.floor(Math.random() * 1000));
}

function sayHello(req, res, trx, cb){

    var io = trx.startIO('Read','FILE','Hello.html');
    fs.readFile(__dirname + '/Hello.html',function(err, data){
        io.end('OK');

        res.writeHead(200, {'Content-Type': 'text/html'});
        res.end(data);
        cb();
    });
}

function sayGoodBye(req, res, cb){
    res.writeHead(200, {'Content-Type': 'text/plain'});
    res.end('Good Bye\n');
    cb();
}

function doSomething(req, res, trx, cb){
    var io = trx.startIO('GetCustomer', 'SAP', 'http://sap.e2e.ch:3000/');
    sapGetCustomer(1, function(err, customer){
        if(err){
            io.end(false);
            res.writeHead(500, {'Content-Type': 'application/json'});
            res.end(JSON.stringify(err));

            cb(false);
            return;
        }
        io.end();

        io = trx.startIO('GetCustomerDetail', 'DB', 'localhost/mongodb/');
        dbGetCustomerDetail(customer, function(err, customerWithDetail){
            if(err){
                io.end(false);
                res.writeHead(200, {'Content-Type': 'application/json'});
                res.end(JSON.stringify(customer));

                cb();
                return;
            }
            io.end();

            res.writeHead(200, {'Content-Type': 'application/json'});
            res.end(JSON.stringify(customerWithDetail));

            cb();

        });
    });
}

http.createServer(function (req, res) {
    var trx;

    switch(req.url){
        case '/hello':
            trx = e2eLogger.startTransaction('Say Hello');
            sayHello(req, res, trx, function(){
                trx.end();
            });
            break;
        case '/goodbye':
            trx = e2eLogger.startTransaction('Say Good Bye');
            sayGoodBye(req, res, function(){
                trx.end();
            });
            break;
        case '/do-something':
            trx = e2eLogger.startTransaction('Do Something');
            doSomething(req, res, trx, function(success){
                trx.end(success);
            });
            break;
        default:
            res.end();
    }

}).listen(1337, '127.0.0.1');

console.log('Server running at http://127.0.0.1:1337/');
