/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl.listing;

import java.util.Arrays;
import org.apache.ftpserver.command.impl.listing.FileFormater;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.util.DateUtils;

public class LISTFileFormater
implements FileFormater {
    private static final char DELIM = ' ';
    private static final char[] NEWLINE = new char[]{'\r', '\n'};

    public String format(FtpFile file) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPermission(file));
        sb.append(' ');
        sb.append(' ');
        sb.append(' ');
        sb.append(String.valueOf(file.getLinkCount()));
        sb.append(' ');
        sb.append(file.getOwnerName());
        sb.append(' ');
        sb.append(file.getGroupName());
        sb.append(' ');
        sb.append(this.getLength(file));
        sb.append(' ');
        sb.append(this.getLastModified(file));
        sb.append(' ');
        sb.append(file.getName());
        sb.append(NEWLINE);
        return sb.toString();
    }

    private String getLength(FtpFile file) {
        String szStr;
        String initStr = "            ";
        long sz = 0L;
        if (file.isFile()) {
            sz = file.getSize();
        }
        if ((szStr = String.valueOf(sz)).length() > initStr.length()) {
            return szStr;
        }
        return initStr.substring(0, initStr.length() - szStr.length()) + szStr;
    }

    private String getLastModified(FtpFile file) {
        return DateUtils.getUnixDate(file.getLastModified());
    }

    private char[] getPermission(FtpFile file) {
        char[] permission = new char[10];
        Arrays.fill(permission, '-');
        permission[0] = file.isDirectory() ? 100 : 45;
        permission[1] = file.isReadable() ? 114 : 45;
        permission[2] = file.isWritable() ? 119 : 45;
        permission[3] = file.isDirectory() ? 120 : 45;
        return permission;
    }
}

