/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl.listing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.command.impl.listing.FileFilter;
import org.apache.ftpserver.command.impl.listing.FileFormater;
import org.apache.ftpserver.command.impl.listing.ListArgument;
import org.apache.ftpserver.command.impl.listing.RegexFileFilter;
import org.apache.ftpserver.command.impl.listing.VisibleFileFilter;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryLister {
    private String traverseFiles(List<FtpFile> files, FileFilter filter, FileFormater formater) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.traverseFiles(files, filter, formater, true));
        sb.append(this.traverseFiles(files, filter, formater, false));
        return sb.toString();
    }

    private String traverseFiles(List<FtpFile> files, FileFilter filter, FileFormater formater, boolean matchDirs) {
        StringBuffer sb = new StringBuffer();
        for (FtpFile file : files) {
            if (file == null || filter != null && !filter.accept(file) || file.isDirectory() != matchDirs) continue;
            sb.append(formater.format(file));
        }
        return sb.toString();
    }

    public String listFiles(ListArgument argument, FileSystemView fileSystemView, FileFormater formater) throws IOException {
        StringBuffer sb = new StringBuffer();
        List<FtpFile> files = this.listFiles(fileSystemView, argument.getFile());
        if (files != null) {
            FileFilter filter = null;
            if (!argument.hasOption('a')) {
                filter = new VisibleFileFilter();
            }
            if (argument.getPattern() != null) {
                filter = new RegexFileFilter(argument.getPattern(), filter);
            }
            sb.append(this.traverseFiles(files, filter, formater));
        }
        return sb.toString();
    }

    private List<FtpFile> listFiles(FileSystemView fileSystemView, String file) {
        ArrayList<FtpFile> files = null;
        try {
            FtpFile virtualFile = fileSystemView.getFile(file);
            if (virtualFile.isFile()) {
                files = new ArrayList<FtpFile>();
                files.add(virtualFile);
            } else {
                files = virtualFile.listFiles();
            }
        }
        catch (FtpException ex) {
            // empty catch block
        }
        return files;
    }
}

