/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.FWHelper;
import com.ibm.mq.MQC;
import com.ibm.mq.MQCompressor;
import com.ibm.mq.MQConnectionOptions;
import com.ibm.mq.MQConnectionSecurityParameters;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQInternalCommunications;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQOutputStream;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSSLConfigurationOptions;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.Pint;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

final class MQv6InternalCommunications
extends MQInternalCommunications {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQv6InternalCommunications.java, java, j600, j600-101-060328 1.32.1.2 05/11/23 14:06:13";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2004, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String applName = "WebSphere MQ Client for Java";
    private int compFlag = 0;
    private List hdrCompList = null;
    private List msgCompList = null;
    private MQConnectionOptions mqcno = null;
    private boolean FAP8supported = true;

    MQv6InternalCommunications(String string, int n, MQManagedConnectionJ11 mQManagedConnectionJ11, MQConnectionOptions mQConnectionOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "Constructor");
            Trace.trace(1, this, sccsid);
        }
        this.qManager = string;
        this.handle = n;
        this.mqManCon = mQManagedConnectionJ11;
        this.mqcno = mQConnectionOptions;
        this.initialize();
        if (Trace.isOn) {
            Trace.exit(this, "Constructor");
        }
    }

    private void initialize() throws MQException {
        block17: {
            if (Trace.isOn) {
                Trace.entry(this, "initialize");
            }
            this.processProperties();
            this.longUserID = MQSESSION.setStringToLength(this.userID, 64);
            this.userID = MQSESSION.setStringToLength(this.userID, 12);
            if (Trace.isOn()) {
                Trace.trace(2, this, "userID = '" + this.userID + "'");
                Trace.trace(2, this, "longUserID = '" + this.longUserID + "'");
            }
            this.userSecurityID = new byte[40];
            this.thread = Thread.currentThread();
            this.sendBytes = new MQOutputStream();
            this.sendData = new DataOutputStream(this.sendBytes);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws MQException {
                        MQv6InternalCommunications.this.createSocketConnection();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (MQException)privilegedActionException.getException();
            }
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return System.getProperty("com.ibm.mq.tuning.socketGrainTimeout");
                    }
                    catch (AccessControlException accessControlException) {
                        return null;
                    }
                }
            });
            if (string != null) {
                try {
                    this.socketGrainTimeout = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.socketGrainTimeout = 10000;
                    if (!Trace.isOn) break block17;
                    Trace.trace(2, this, "failed to set socketGrainTimeout = '" + string + "', using default = " + 10000);
                }
            }
        }
        try {
            this.connection.setSoTimeout(this.socketTimeOut);
        }
        catch (SocketException socketException) {
            throw new MQInternalException(2, 2195, 48, "SocketException thrown on setSoTimeOut");
        }
        this.establishChannel();
        try {
            this.socketTimeOut = this.heartbeatInterval == 0 ? 0 : (this.heartbeatInterval < 60 ? this.heartbeatInterval * 2000 : this.heartbeatInterval * 1000 + 60000);
            if (Trace.isOn) {
                Trace.trace(2, this, "socketTimeOut negotiated:" + this.socketTimeOut + " GrainTimeout :" + this.socketGrainTimeout);
            }
            if (this.socketTimeOut < this.socketGrainTimeout || this.socketGrainTimeout <= 0) {
                this.connection.setSoTimeout(this.socketTimeOut);
            } else {
                this.connection.setSoTimeout(this.socketGrainTimeout);
            }
        }
        catch (SocketException socketException) {
            throw new MQInternalException(2, 2195, 48, "SocketException thrown on setSoTimeOut");
        }
        this.initialiseExits();
        if (this.FAP8supported) {
            this.channelDefinition.hdrCompList = this.hdrCompList;
            this.channelDefinition.msgCompList = this.msgCompList;
            this.sendExitParms.CurHdrCompression = this.curHdrCompression;
            this.sendExitParms.CurMsgCompression = this.curMsgCompression;
            this.receiveExitParms.CurHdrCompression = this.curHdrCompression;
            this.receiveExitParms.CurMsgCompression = this.curMsgCompression;
            this.securityExitParms.CurHdrCompression = this.curHdrCompression;
            this.securityExitParms.CurMsgCompression = this.curMsgCompression;
        } else {
            this.sendExitParms.fapLevel = 7;
            this.receiveExitParms.fapLevel = 7;
            this.securityExitParms.fapLevel = 7;
        }
        this.suppressSendExit = true;
        this.suppressReceiveExit = true;
        this.sendSecurityFlows();
        this.suppressSendExit = false;
        this.suppressReceiveExit = false;
        this.connectToQueueManager();
        this.ccsidIsAscii = this.isCcsidAscii(this.ccsid);
        if (Trace.isOn) {
            Trace.exit(this, "initialize");
        }
    }

    private final void processProperties() throws MQException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "processProperties");
        }
        this.ccsid = this.mqManCon.getIntegerProperty("CCSID", 819);
        this.channel = this.mqManCon.getStringProperty("channel", "", 20);
        this.hostname = this.mqManCon.getStringProperty("hostname", "");
        if (this.hostname.equals("")) {
            this.hostname = "localhost";
        }
        this.userID = this.mqManCon.getStringProperty("userID", "");
        this.password = this.mqManCon.getStringProperty("password", "", 12);
        this.port = this.mqManCon.getIntegerProperty("port", -1);
        if (this.port == -1) {
            this.port = 1414;
        }
        if ((object = this.mqManCon.getProperty("receiveExit")) instanceof MQReceiveExit) {
            this.receiveExit = (MQReceiveExit)object;
        }
        if ((object = this.mqManCon.getProperty("securityExit")) instanceof MQSecurityExit) {
            this.securityExit = (MQSecurityExit)object;
        }
        if ((object = this.mqManCon.getProperty("sendExit")) instanceof MQSendExit) {
            this.sendExit = (MQSendExit)object;
        }
        if ((object = this.mqManCon.getProperty("XAReq")) instanceof Boolean) {
            this.xaRequired = (Boolean)object;
        }
        if ((object = this.mqManCon.getProperty("Use QM CCSID")) instanceof Boolean) {
            this.shouldAdoptQMgrCcsid = (Boolean)object;
        }
        this.requestSPI = "SPI_ENABLE".equals(this.mqManCon.getStringProperty("SPI"));
        this.sslCipherSuite = this.mqManCon.getStringProperty("SSL Cipher Suite");
        this.sslPeername = this.mqManCon.getStringProperty("SSL Peer Name");
        this.sslSocketFactory = this.mqManCon.getProperty("SSL Socket Factory");
        Boolean bl = (Boolean)this.mqManCon.getProperty("SSL Fips Required");
        if (bl != null) {
            this.sslFipsRequired = bl;
        }
        if ((object = this.mqManCon.getProperty("SSL CertStores")) != null && !(object instanceof Collection)) {
            throw new MQException(2, 2402, (Object)this, 118);
        }
        this.sslCertStores = (Collection)object;
        this.hdrCompList = (Vector)this.mqManCon.getProperty("Header Compression Property");
        this.msgCompList = (Vector)this.mqManCon.getProperty("Message Compression Property");
        Object object2 = this.mqManCon.getProperty("FIREWALL_SETTINGS");
        if (object2 != null) {
            this.fw_localip = FWHelper.decodeLocalAddress(object2);
            this.fw_pstart = FWHelper.decodePort(object2, "START_PORT");
            this.fw_pend = FWHelper.decodePort(object2, "END_PORT");
            if (Trace.isOn) {
                Trace.trace(2, this, "Firewall properties:");
                if (this.fw_localip != null) {
                    Trace.trace(2, this, "  fw_localip: " + this.fw_localip.getHostAddress());
                } else {
                    Trace.trace(2, this, "  fw_localip: null");
                }
                Trace.trace(2, this, "  fw_pstart: " + this.fw_pstart);
                Trace.trace(2, this, "  fw_pend: " + this.fw_pend);
            }
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.tuning.maxTransmissionSize");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        int n = 0;
        if (string != null) {
            n = new Integer(string);
        }
        if (n > 0) {
            if (Trace.isOn) {
                Trace.trace(2, this, "MaxTransmissionSize set to " + string);
            }
            this.maxTransmissionSize = n;
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "Queue Manager = '" + this.qManager + "'");
            Trace.trace(2, this, "Connection handle = " + this.handle);
            Trace.trace(2, this, "CCSID = " + this.ccsid);
            Trace.exit(this, "processProperties");
        }
    }

    private final void buildInitialData(DataOutputStream dataOutputStream) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "buildInitialData");
        }
        dataOutputStream.writeBytes("ID  ");
        dataOutputStream.writeByte(this.fapLevel);
        dataOutputStream.writeByte(this.IDFlags);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(this.maxMessagesPerBatch);
        dataOutputStream.writeInt(this.maxTransmissionSize);
        dataOutputStream.writeInt(this.maxMessageSize);
        dataOutputStream.writeInt(this.sequenceWrapValue);
        dataOutputStream.writeBytes(this.channel);
        dataOutputStream.writeByte(this.IDFlags2);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeShort(this.ccsid);
        dataOutputStream.writeBytes(MQSESSION.setStringToLength(null, 48));
        dataOutputStream.writeInt(this.heartbeatInterval);
        dataOutputStream.writeShort(0);
        if (this.FAP8supported) {
            int n;
            int n2;
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            Iterator iterator = null;
            if (this.hdrCompList == null) {
                this.hdrCompList = new Vector();
            }
            iterator = this.hdrCompList.iterator();
            for (n2 = 0; n2 < 2; ++n2) {
                if (iterator != null && iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    dataOutputStream.writeByte((byte)n);
                    continue;
                }
                dataOutputStream.writeByte(-1);
            }
            if (this.msgCompList == null) {
                this.msgCompList = new Vector();
            }
            iterator = this.msgCompList.iterator();
            for (n2 = 0; n2 < 16; ++n2) {
                if (iterator != null && iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    dataOutputStream.writeByte((byte)n);
                    continue;
                }
                iterator = null;
                dataOutputStream.writeByte(-1);
            }
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
            if (this.mqcno != null) {
                MQSSLConfigurationOptions mQSSLConfigurationOptions = this.mqcno.getMQSCO();
                if (mQSSLConfigurationOptions != null) {
                    dataOutputStream.writeInt(mQSSLConfigurationOptions.getKeyResetCount());
                } else {
                    dataOutputStream.writeInt(0);
                }
            } else {
                dataOutputStream.writeInt(0);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "buildInitialData");
        }
    }

    private final void establishChannel() throws MQException {
        block17: {
            if (Trace.isOn) {
                Trace.entry(this, "establishChannel");
            }
            try {
                this.sendBytes = new MQOutputStream();
                this.sendData = new DataOutputStream(this.sendBytes);
                if (this.xaRequired) {
                    if (Trace.isOn) {
                        Trace.trace(this, "setting ICF_XAREQUEST");
                    }
                    this.IDFlags2 |= 0x10;
                    if (MQEnvironment.runningInWS()) {
                        if (Trace.isOn) {
                            Trace.trace(this, "setting ICF_XARUNTIME_APP");
                        }
                        this.IDFlags2 |= 0x20;
                    }
                }
                if (this.requestSPI) {
                    if (Trace.isOn) {
                        Trace.trace(this, "setting ICF_SPI_REQUEST");
                    }
                    this.IDFlags2 |= 0x40;
                }
                this.buildInitialData(this.sendData);
                if (Trace.isOn) {
                    Trace.trace(2, this, "sending TST_INITIAL_DATA");
                }
                this.send(1, 1, this.sendBytes.toByteArray(), null);
                Pint pint = new Pint(0);
                Pint pint2 = new Pint(0);
                Pint pint3 = new Pint(0);
                if (Trace.isOn) {
                    Trace.trace(2, this, "receiving server reply");
                }
                DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
                this.checkControlFlags(pint2, dataInputStream, false);
                if (pint.x == 1) {
                    this.parseInitialDataResponse(dataInputStream);
                    if (Trace.isOn) {
                        Trace.trace(1, this, "Bind to server was successful");
                    }
                    break block17;
                }
                if (Trace.isOn) {
                    Trace.trace(1, this, "Unexpected segment type sent from server: " + pint.x);
                }
                this.close();
                if (Trace.isOn) {
                    Trace.exit(this, "establishChannel (via exception)");
                }
                throw new MQInternalException(2, 2195, 59);
            }
            catch (IOException iOException) {
                this.close();
                if (Trace.isOn) {
                    Trace.exit(this, "establishChannel (via IOException)");
                }
                throw new MQInternalException(2, 2195, 60);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "establishChannel");
        }
    }

    private void checkControlFlags(Pint pint, DataInputStream dataInputStream, boolean bl) throws MQInternalException, IOException {
        if (Trace.isOn) {
            Trace.entry(this, "checkControlFlags");
        }
        int n = 0;
        if ((pint.x & 8) != 0) {
            int n2 = 2;
            int n3 = 2009;
            if ((pint.x & 2) != 0) {
                if (this.transmissionLength > 28) {
                    dataInputStream.skipBytes(4);
                    n = dataInputStream.readInt();
                } else {
                    n = 22;
                }
            }
            if (Trace.isOn) {
                Trace.trace(1, this, "server sent TCF_CLOSE_CHANNEL on connect:err code = " + n);
            }
            this.close();
            if (Trace.isOn) {
                Trace.exit(this, "checkControlFlags (via exception)");
            }
            throw new MQInternalException(n2, n3, 57, "" + n3);
        }
        if (bl && (pint.x & 2) != 0) {
            if (this.transmissionLength > 28) {
                dataInputStream.skipBytes(4);
                n = dataInputStream.readInt();
            } else {
                n = 22;
            }
            if (Trace.isOn) {
                Trace.trace(1, this, "Server sent TCF_ERROR, error code " + n);
            }
            this.close();
            if (Trace.isOn) {
                Trace.exit(this, "checkControlFlags (via exception)");
            }
            throw new MQInternalException(2, 2009, 67, "" + n);
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkControlFlags");
        }
    }

    private final void parseInitialDataResponse(DataInputStream dataInputStream) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "parseInitialDataResponse");
        }
        byte by = 0;
        byte by2 = 0;
        short s = 0;
        int n = 0;
        int n2 = 0;
        byte by3 = 0;
        dataInputStream.skipBytes(4);
        this.fapLevel = dataInputStream.readByte();
        if (this.fapLevel < 8) {
            this.FAP8supported = false;
        }
        this.IDFlags = dataInputStream.readByte();
        by = dataInputStream.readByte();
        by2 = dataInputStream.readByte();
        dataInputStream.skipBytes(2);
        s = dataInputStream.readShort();
        n = dataInputStream.readInt();
        n2 = dataInputStream.readInt();
        dataInputStream.skipBytes(4);
        dataInputStream.skipBytes(20);
        this.IDFlags2 = dataInputStream.readByte();
        by3 = dataInputStream.readByte();
        short s2 = dataInputStream.readShort();
        if ((by2 & 0x10) != 0) {
            this.maxMessageSize = n2;
        }
        if ((by2 & 4) != 0) {
            this.maxTransmissionSize = n;
        }
        if (this.shouldAdoptQMgrCcsid && !this.qmCcsidKnown) {
            if (this.isValidJavaCcsid(s2)) {
                if (this.isCcsidAscii(s2)) {
                    this.ccsid = s2;
                    this.qmCcsidKnown = true;
                    if (Trace.isOn) {
                        Trace.trace(1, this, "Adopting qmgr CCSID of " + this.ccsid);
                    }
                } else {
                    this.shouldAdoptQMgrCcsid = false;
                    if (Trace.isOn) {
                        Trace.trace(1, this, "Failed to adopt qmgr CCSID (" + s2 + ") - not ASCII.");
                    }
                }
            } else {
                this.shouldAdoptQMgrCcsid = false;
                if (Trace.isOn) {
                    Trace.trace(1, this, "Cannot adopt qmgr CCSID (" + s2 + ")");
                }
            }
        }
        dataInputStream.skipBytes(48);
        this.heartbeatInterval = dataInputStream.readInt();
        short s3 = dataInputStream.readShort();
        if (s3 != 0 && Trace.isOn) {
            Trace.trace(1, this, "skipping EFL (length=" + s3 + "bytes )");
        }
        dataInputStream.skipBytes(s3);
        if (this.FAP8supported) {
            Integer n3;
            int n4;
            this.compFlag = dataInputStream.readByte();
            dataInputStream.skipBytes(1);
            boolean bl = false;
            byte by4 = 0;
            if ((this.compFlag & 1) != 0) {
                this.hdrCompList.clear();
                for (n4 = 0; n4 < 2; ++n4) {
                    by4 = dataInputStream.readByte();
                    if (by4 == -1) continue;
                    this.hdrCompList.add(new Integer(by4));
                    if (bl) continue;
                    this.curHdrCompression = by4;
                    bl = true;
                }
            } else {
                Iterator iterator;
                if (this.hdrCompList != null && (iterator = this.hdrCompList.iterator()).hasNext()) {
                    n3 = (Integer)iterator.next();
                    this.curHdrCompression = n3;
                }
                dataInputStream.skipBytes(2);
            }
            bl = false;
            if ((this.compFlag & 2) != 0) {
                this.msgCompList.clear();
                for (n4 = 1; n4 < 16; ++n4) {
                    by4 = dataInputStream.readByte();
                    if (by4 == -1) continue;
                    this.msgCompList.add(new Integer(by4));
                    if (bl) continue;
                    this.curMsgCompression = by4;
                    bl = true;
                }
            } else {
                Iterator iterator;
                if (this.msgCompList != null && (iterator = this.msgCompList.iterator()).hasNext() && (n3 = (Integer)iterator.next()) != null) {
                    this.curMsgCompression = n3;
                }
                dataInputStream.skipBytes(16);
            }
            if (this.curHdrCompression != 0 || this.curMsgCompression != 0) {
                n4 = 0;
                if (this.curMsgCompression == 2) {
                    n4 = 3;
                } else if (this.curMsgCompression == 4) {
                    n4 = 9;
                }
                this.compressor = new MQCompressor(n4);
            }
            if (Trace.isOn) {
                Trace.trace(this, "Current message compression: " + this.curMsgCompression);
                Trace.trace(this, "Current header compression: " + this.curHdrCompression);
            }
        }
        this.checkErrorFlags(by, by3, by2);
        if (Trace.isOn) {
            Trace.exit(this, "parseInitialDataResponse");
        }
    }

    private void checkErrorFlags(int n, int n2, int n3) throws MQException, IOException {
        if (Trace.isOn) {
            Trace.entry(this, "checkErrorFlags");
        }
        if (n != 0 || n2 != 0 || n3 != 0) {
            if (this.xaRequired && (this.IDFlags2 & 0x10) == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "TCF_ERROR flag set, XAREQUEST cleared. Closing.");
                }
                this.close();
                if (Trace.isOn) {
                    Trace.exit(this, "checkErrorFlags (via exception)");
                }
                throw new MQException(2, 2012, (Object)this, 119);
            }
            if ((n2 & 0x10) != 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "server doesn't support XA client");
                }
                this.close();
                if (Trace.isOn) {
                    Trace.exit(this, "checkErrorFlags (via exception)");
                }
                throw new MQException(2, 2012, (Object)this, 119);
            }
            if (MQEnvironment.runningInWS() && ((n2 & 0x20) != 0 || (this.IDFlags2 & 0x20) == 0)) {
                if (Trace.isOn) {
                    Trace.trace(this, "Cannot set ourselves as an XA Runtime app. Attempting XA operations later should fail");
                }
                this.IDFlags2 &= 0xFFFFFFDF;
            }
            if (this.requestSPI && ((n2 & 0x40) != 0 || (this.IDFlags2 & 0x40) == 0)) {
                if (Trace.isOn) {
                    Trace.trace(this, "server does not support SPI");
                }
                this.IDFlags2 &= 0xFFFFFFBF;
                this.requestSPI = false;
            }
            if ((this.IDFlags2 & 1) == 0) {
                if (Trace.isOn) {
                    Trace.trace(4, this, "Server unset IDFlags2 bit one. DistLists unsupported.");
                }
                this.distListCapable = false;
            }
            if ((n2 & 1) != 0) {
                this.IDFlags2 &= 0xFFFFFFFE;
                this.distListCapable = false;
            }
            if ((n & 0x40) != 0) {
                this.serverSecurityExit = true;
            }
            if ((n3 & 1) != 0) {
                if (Trace.isOn) {
                    Trace.trace(1, this, "Remote queue manager cannot support CCSID " + this.ccsid);
                }
                this.close();
                if (Trace.isOn) {
                    Trace.exit(this, "checkErrorFlags (via exception)");
                }
                throw new MQInternalException(2, 2195, 61);
            }
            if ((n3 & 2) != 0) {
                if (Trace.isOn) {
                    Trace.trace(1, this, "Remote queue manager cannot support my encoding");
                }
                this.close();
                if (Trace.isOn) {
                    Trace.exit(this, "checkErrorFlags (via exception)");
                }
                throw new MQInternalException(2, 2195, 62);
            }
            if ((n3 & 0x20) != 0) {
                if (Trace.isOn) {
                    Trace.trace(1, this, "Remote queue manager rejected MaxMsgsPerBatch");
                }
                this.close();
                if (Trace.isOn) {
                    Trace.exit(this, "checkErrorFlags (via exception)");
                }
                throw new MQInternalException(2, 2195, 64);
            }
            if ((n3 & 0x40) != 0) {
                if (Trace.isOn) {
                    Trace.trace(1, this, "Remote queue manager rejected sequence wrap value");
                }
                this.sendStatus(8, 16);
                this.connection.close();
                if (Trace.isOn) {
                    Trace.exit(this, "checkErrorFlags (via exception)");
                }
                throw new MQInternalException(2, 2195, 65);
            }
            if (Trace.isOn) {
                Trace.trace(1, this, "Renegotiating at FAPLevel " + this.fapLevel + ": IDEFlags = " + n + ", IDEFlags2 = " + n2 + ", ErrFlags = " + n3);
            }
            this.renegotiateConnectionParameters();
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkErrorFlags");
        }
    }

    private final void renegotiateConnectionParameters() throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "renegotiateConnectionParameters");
        }
        this.sendBytes = new MQOutputStream();
        this.sendData = new DataOutputStream(this.sendBytes);
        this.buildInitialData(this.sendData);
        this.send(1, 1, this.sendBytes.toByteArray(), null);
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        Pint pint3 = new Pint();
        DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
        if (pint.x == 1) {
            this.checkControlFlags(pint2, dataInputStream, false);
            if ((pint2.x & 2) != 0) {
                this.sendBytes = new MQOutputStream();
                this.sendData = new DataOutputStream(this.sendBytes);
                this.buildInitialData(this.sendData);
                this.send(1, 1, this.sendBytes.toByteArray(), null);
                pint = new Pint();
                pint2 = new Pint();
                pint3 = new Pint();
                dataInputStream = this.receive(pint, pint2, pint3);
                if (pint.x == 1) {
                    this.checkControlFlags(pint2, dataInputStream, true);
                } else {
                    if (Trace.isOn) {
                        Trace.trace(1, this, "Server sent unacceptable segment type on attempt two : " + pint.x);
                    }
                    this.sendStatus(8, 2);
                    this.connection.close();
                    if (Trace.isOn) {
                        Trace.exit(this, "renegotiateConnectionParameters, attempt two (via exception)");
                    }
                    throw new MQInternalException(2, 2195, 98);
                }
            }
            if (Trace.isOn) {
                Trace.trace(1, this, "renegotiation worked ok");
            }
        } else {
            if (Trace.isOn) {
                Trace.trace(1, this, "Server sent unacceptable segment type : " + pint.x);
            }
            this.sendStatus(8, 2);
            this.connection.close();
            if (Trace.isOn) {
                Trace.exit(this, "renegotiateConnectionParameters (via exception)");
            }
            throw new MQInternalException(2, 2195, 98);
        }
        if (Trace.isOn) {
            Trace.exit(this, "renegotiateConnectionParameters");
        }
    }

    private final void buildUserIdData(DataOutputStream dataOutputStream) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "buildUserIdData");
        }
        dataOutputStream.writeBytes("UID ");
        dataOutputStream.writeBytes(this.userID.toUpperCase());
        if (Trace.isOn) {
            Trace.trace(5, this, "UID :" + this.userID.toUpperCase());
        }
        dataOutputStream.writeBytes(this.password);
        dataOutputStream.writeBytes(this.longUserID);
        dataOutputStream.write(this.userSecurityID, 0, this.userSecurityID.length);
    }

    private final void buildConnAuthData(DataOutputStream dataOutputStream) throws IOException {
        MQConnectionSecurityParameters mQConnectionSecurityParameters = this.securityExitParms.getMQCSP();
        dataOutputStream.writeBytes("CAUT");
        dataOutputStream.writeInt(mQConnectionSecurityParameters.getAuthenticationType());
        dataOutputStream.writeInt(mQConnectionSecurityParameters.getCSPUserIdLength());
        dataOutputStream.writeInt(mQConnectionSecurityParameters.getCSPPasswordLength());
        dataOutputStream.writeInt(mQConnectionSecurityParameters.getCSPUserIdLength());
        dataOutputStream.writeInt(mQConnectionSecurityParameters.getCSPPasswordLength());
        dataOutputStream.writeBytes(mQConnectionSecurityParameters.getCSPUserId() != null ? mQConnectionSecurityParameters.getCSPUserId() : "");
        dataOutputStream.writeBytes(mQConnectionSecurityParameters.getCSPPassword() != null ? mQConnectionSecurityParameters.getCSPPassword() : "");
    }

    private final void sendSecurityFlows() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "sendSecurityFlows");
        }
        try {
            if (this.securityExit == null) {
                this.sendBytes = new MQOutputStream();
                this.sendData = new DataOutputStream(this.sendBytes);
                this.buildUserIdData(this.sendData);
                if (Trace.isOn) {
                    Trace.trace(2, this, "No security exit at client, sending id and password");
                }
                byte[] byArray = this.sendBytes.toByteArray();
                Trace.dataTrace(3, this, byArray);
                this.send(8, 0, byArray, null);
                if (this.serverSecurityExit) {
                    boolean bl = false;
                    Pint pint = new Pint(0);
                    Pint pint2 = new Pint(0);
                    Pint pint3 = new Pint(0);
                    block6: while (!bl) {
                        if (Trace.isOn) {
                            Trace.trace(2, this, "Server has a security exit, awaiting reply...");
                        }
                        DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
                        switch (pint.x) {
                            case 6: {
                                if (Trace.isOn) {
                                    Trace.trace(3, this, "Server sent TST_SECURITY_DATA, responding with null security flow.");
                                }
                                this.sendBytes.reset();
                                this.sendData.writeInt(0);
                                this.send(6, 0, this.sendBytes.toByteArray(), null);
                                continue block6;
                            }
                            case 5: {
                                this.checkControlFlags(pint2, dataInputStream, true);
                                bl = true;
                                continue block6;
                            }
                        }
                        if (Trace.isOn) {
                            Trace.trace(1, this, "Unexpected segment type received from server : " + pint.x);
                        }
                        this.close();
                        if (Trace.isOn) {
                            Trace.exit(this, "sendSecurityFlows (via exception)");
                        }
                        throw new MQInternalException(2, 2195, 70);
                    }
                }
            } else {
                this.invokeSecurityExit();
                if (this.FAP8supported) {
                    this.invokeSecurityExitForOAM();
                    if (this.securityExitParms.getMQCSP() != null) {
                        this.flowMQCSP();
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.close();
            if (Trace.isOn) {
                Trace.exit(this, "sendSecurityFlows (via IOException)");
            }
            throw new MQInternalException(2, 2195, 71);
        }
        if (Trace.isOn) {
            Trace.exit(this, "sendSecurityFlows");
        }
    }

    private final void invokeSecurityExitForOAM() throws MQException, IOException {
        if (Trace.isOn) {
            Trace.exit(this, "invokeSecurityExitForOAM");
        }
        this.securityExitParms.exitReason = 29;
        this.securityExitParms.exitResponse = 0;
        this.transmissionData = this.securityExit.securityExit(this.securityExitParms, this.channelDefinition, null);
        if (Trace.isOn && this.transmissionData != null) {
            Trace.trace(2, this, "warning, exit returned unexpected data when called with MQXR_SEC_PARMS:");
            Trace.dataTrace(2, this, this.transmissionData);
        }
        switch (this.securityExitParms.exitResponse) {
            case -4: 
            case -3: 
            case 0: {
                if (!Trace.isOn) break;
                Trace.trace(3, this, "Security exit invoked with MQXR_SEC_PARMS OK");
                Trace.trace(3, this, "exit returned a " + (this.securityExitParms.getMQCSP() == null ? "null" : "non-null") + " MQCSP object");
                break;
            }
            case -6: 
            case -1: {
                this.sendStatus(8, 9);
                this.connection.close();
                if (Trace.isOn) {
                    Trace.trace(2, this, "Client security exit closed the channel.");
                    Trace.exit(this, "invokeSecurityExit (via exception)");
                }
                throw new MQInternalException(2, 2063, 72);
            }
            default: {
                this.sendStatus(8, 9);
                this.connection.close();
                if (Trace.isOn) {
                    Trace.trace(2, this, "unexpected response from client security exit: " + this.securityExitParms.exitResponse);
                    Trace.exit(this, "invokeSecurityExit (via exception)");
                }
                throw new MQInternalException(2, 2063, 72);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "invokeSecurityExitForOAM");
        }
    }

    private void flowMQCSP() throws MQException, IOException {
        if (Trace.isOn) {
            Trace.entry(this, "sendOAMFlows");
        }
        this.sendBytes = new MQOutputStream();
        this.sendData = new DataOutputStream(this.sendBytes);
        this.buildConnAuthData(this.sendData);
        byte[] byArray = this.sendBytes.toByteArray();
        if (Trace.isOn) {
            Trace.trace(2, this, "sending OAM flow");
            Trace.dataTrace(3, this, byArray);
        }
        this.send(10, 1, byArray, null);
        Pint pint = new Pint();
        Pint pint2 = new Pint();
        Pint pint3 = new Pint();
        if (Trace.isOn) {
            Trace.trace(2, this, "Awaiting server reply.");
        }
        DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
        try {
            this.checkControlFlags(pint2, dataInputStream, true);
        }
        catch (Exception exception) {
            throw new MQInternalException(2, 2063, 53, this.hostname);
        }
        if (Trace.isOn) {
            Trace.exit(this, "sendOAMFlows");
        }
    }

    private void buildConnFlow(DataOutputStream dataOutputStream) throws IOException {
        if (Trace.isOn) {
            Trace.entry(this, "buildConnFlow");
        }
        if (dataOutputStream != null) {
            dataOutputStream.writeBytes(this.qManager);
            dataOutputStream.writeBytes(applName);
            dataOutputStream.writeInt(28);
            dataOutputStream.write(MQC.MQACT_NONE);
            if (this.mqcno != null) {
                dataOutputStream.writeInt(3);
                dataOutputStream.writeInt(this.mqcno.getOptions());
                dataOutputStream.writeBytes("FCNO");
                dataOutputStream.writeInt(1);
                dataOutputStream.writeInt(0);
                if (this.mqcno.getVersion() > 2) {
                    dataOutputStream.write(this.mqcno.getConnTag());
                } else {
                    dataOutputStream.write(MQConnectionOptions.MQCT_NONE);
                }
            } else {
                dataOutputStream.writeInt(1);
                dataOutputStream.writeInt(0);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "buildConnFlow");
        }
    }

    private final void connectToQueueManager() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "connectToQueueManager");
        }
        if (this.maxTransmissionSize < 44) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Max transmission size too small to proceed.");
            }
            this.close();
            if (Trace.isOn) {
                Trace.exit(this, "connectToQueueManager (via exception)");
            }
            throw new MQInternalException(2, 2005, 76);
        }
        try {
            byte[] byArray = this.FAP8supported && this.mqcno != null ? this.buildAPIHeader(260, 0, 0, 0) : this.buildAPIHeader(120, 0, 0, 0);
            this.sendBytes = new MQOutputStream();
            this.sendData = new DataOutputStream(this.sendBytes);
            this.buildConnFlow(this.sendData);
            if (Trace.isOn) {
                Trace.trace(2, this, "Sending MQCONN flow.");
            }
            this.send(129, 0, this.sendBytes.toByteArray(), byArray);
            Pint pint = new Pint();
            Pint pint2 = new Pint();
            Pint pint3 = new Pint();
            if (Trace.isOn) {
                Trace.trace(2, this, "Awaiting server reply.");
            }
            DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
            if (pint.x != 145) {
                if (Trace.isOn) {
                    Trace.trace(1, this, "Server sent unexpected segment type: " + pint.x);
                }
                this.close();
                if (Trace.isOn) {
                    Trace.exit(this, "connectToQueueManager (via exception)");
                }
                throw new MQInternalException(2, 2195, 79, "" + pint.x);
            }
            this.parseConnReply(dataInputStream);
        }
        catch (IOException iOException) {
            this.close();
            if (Trace.isOn) {
                Trace.exit(this, "connectToQueueManager (via IOException)");
            }
            throw new MQInternalException(2, 2195, 80);
        }
        if (Trace.isOn) {
            Trace.exit(this, "connectToQueueManager");
        }
    }

    private final void parseConnReply(DataInputStream dataInputStream) throws MQInternalException, IOException {
        if (Trace.isOn) {
            Trace.entry(this, "parseConnReply");
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        dataInputStream.skipBytes(4);
        n = dataInputStream.readInt();
        n2 = dataInputStream.readInt();
        if (n != 0) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Non-zero completion code from MQCONN: " + n + "," + n2);
            }
            this.close();
            if (Trace.isOn) {
                Trace.exit(this, "parseConnReply (via exception)");
            }
            throw new MQInternalException(n, n2, 77);
        }
        if (this.mqcno != null) {
            dataInputStream.skipBytes(4);
            dataInputStream.skipBytes(12);
            byte[] byArray = new byte[24];
            dataInputStream.read(byArray);
            this.mqcno.setConnectionId(byArray);
        }
        if (Trace.isOn) {
            Trace.exit(this, "parseConnReply");
        }
    }
}

