/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQPoolServices;
import com.ibm.mq.MQPoolServicesEvent;
import com.ibm.mq.MQPoolServicesEventListener;
import com.ibm.mq.ManagedConnectionStore;
import com.ibm.mq.PoolScavenger;
import com.ibm.mq.StoredManagedConnection;
import com.ibm.mqservices.Trace;
import java.util.Enumeration;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

public final class MQSimpleConnectionManager
implements MQConnectionManager {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQSimpleConnectionManager.java, java, j600, j600-101-060328 1.23.1.1 05/05/25 15:40:49";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2003, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ManagedConnectionStore mcs = new ManagedConnectionStore();
    private PoolScavenger scavenger = new PoolScavenger();
    private Vector ownedSMCs = new Vector();
    private boolean active = false;
    private int mode = 0;
    private MQPoolServices poolServices = new MQPoolServices();
    private PSAdapter adapter = new PSAdapter();
    private int maxCons = 0;
    private int gestating = 0;
    public static final int MODE_AUTO = 0;
    public static final int MODE_ACTIVE = 1;
    public static final int MODE_INACTIVE = 2;

    public MQSimpleConnectionManager() {
        this.poolServices.addMQPoolServicesEventListener(this.adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocateConnection(MQManagedConnectionFactory mQManagedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        String string = "allocateConnection";
        if (Trace.isOn) {
            Trace.entry(this, string);
        }
        StoredManagedConnection storedManagedConnection = null;
        Object object = null;
        boolean bl = true;
        while (bl) {
            storedManagedConnection = this.mcs.chooseOne(mQManagedConnectionFactory, connectionRequestInfo);
            if (storedManagedConnection != null && storedManagedConnection.mqManCon != null) {
                try {
                    object = storedManagedConnection.mqManCon.getConnection(connectionRequestInfo);
                    break;
                }
                catch (ResourceException resourceException) {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "resource exception: " + (Object)((Object)resourceException));
                    }
                    storedManagedConnection.destroy();
                    continue;
                }
            }
            bl = false;
        }
        if (!bl) {
            int n;
            if (this.maxCons > 0 && (n = 1 + this.currentSize() + this.gestating - this.maxCons) > 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Scavenger asked to lose " + n + " connections");
                }
                this.scavenger.destroyNext(n);
            }
            storedManagedConnection = null;
            if (this.maxCons == 0 || this.maxCons > this.currentSize() + this.gestating) {
                ++this.gestating;
                try {
                    storedManagedConnection = new StoredManagedConnection(mQManagedConnectionFactory, connectionRequestInfo, this.mcs, this.scavenger, this);
                    MQSimpleConnectionManager mQSimpleConnectionManager = this;
                    synchronized (mQSimpleConnectionManager) {
                        storedManagedConnection.initializePoolActive(this.active);
                    }
                    object = storedManagedConnection.mqManCon.getConnection(connectionRequestInfo);
                }
                catch (ResourceException resourceException) {
                    if (storedManagedConnection != null) {
                        storedManagedConnection.destroy();
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, string);
                    }
                    throw resourceException;
                }
                finally {
                    --this.gestating;
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, string);
            }
            throw new ResourceException(string);
        }
        if (Trace.isOn) {
            Trace.exit(this, string);
        }
        return object;
    }

    public Object recycleConnection(MQManagedConnectionFactory mQManagedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) {
        String string = "recycleConnection";
        if (Trace.isOn) {
            Trace.entry(this, string);
        }
        StoredManagedConnection storedManagedConnection = null;
        Object object = null;
        while ((storedManagedConnection = this.mcs.chooseOne(mQManagedConnectionFactory, connectionRequestInfo)) != null && storedManagedConnection.mqManCon != null) {
            try {
                object = storedManagedConnection.mqManCon.getConnection(connectionRequestInfo);
                break;
            }
            catch (ResourceException resourceException) {
                storedManagedConnection.destroy();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, string);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createConnection(MQManagedConnectionFactory mQManagedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        int n;
        String string = "createConnection";
        if (Trace.isOn) {
            Trace.entry(this, string);
        }
        StoredManagedConnection storedManagedConnection = null;
        Object object = null;
        if (this.maxCons > 0 && (n = 1 + this.currentSize() + this.gestating - this.maxCons) > 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Scavenger asked to lose " + n + " connections");
            }
            this.scavenger.destroyNext(n);
        }
        storedManagedConnection = null;
        if (this.maxCons == 0 || this.maxCons > this.currentSize() + this.gestating) {
            ++this.gestating;
            try {
                storedManagedConnection = new StoredManagedConnection(mQManagedConnectionFactory, connectionRequestInfo, this.mcs, this.scavenger, this);
                MQSimpleConnectionManager mQSimpleConnectionManager = this;
                synchronized (mQSimpleConnectionManager) {
                    storedManagedConnection.initializePoolActive(this.active);
                }
                object = storedManagedConnection.mqManCon.getConnection(connectionRequestInfo);
            }
            catch (ResourceException resourceException) {
                if (storedManagedConnection != null) {
                    storedManagedConnection.destroy();
                }
                if (Trace.isOn) {
                    Trace.exit(this, string);
                }
                throw resourceException;
            }
            finally {
                --this.gestating;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, string);
        }
        throw new ResourceException(string);
        if (Trace.isOn) {
            Trace.exit(this, string);
        }
        return object;
    }

    public synchronized void setActive(int n) {
        if (Trace.isOn) {
            Trace.entry(this, "setActive");
        }
        if (n != 0 && n != 1 && n != 2) {
            if (Trace.isOn) {
                Trace.exit(this, "setActive (via exception)");
            }
            throw new IllegalArgumentException();
        }
        this.mode = n;
        switch (n) {
            case 0: {
                if (MQEnvironment.defaultMQCxManager == this && this.poolServices.getTokenCount() > 0) {
                    this._setActive(true);
                } else {
                    this._setActive(false);
                }
                this.poolServices.addMQPoolServicesEventListener(this.adapter);
                break;
            }
            case 1: {
                this._setActive(true);
                this.poolServices.removeMQPoolServicesEventListener(this.adapter);
                break;
            }
            case 2: {
                this._setActive(false);
                this.poolServices.removeMQPoolServicesEventListener(this.adapter);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "setActive");
        }
    }

    public int getActive() {
        return this.mode;
    }

    public void setTimeout(long l) {
        if (l < 0L) {
            if (Trace.isOn) {
                Trace.trace(2, this, "setTimeout called with timeout < 0");
            }
            throw new IllegalArgumentException();
        }
        this.scavenger.setTimeout(l);
    }

    public long getTimeout() {
        return this.scavenger.getTimeout();
    }

    public void setMaxUnusedConnections(int n) {
        if (n < 0) {
            if (Trace.isOn) {
                Trace.trace(2, this, "setHighThreshold called with thresdhold < 0");
            }
            throw new IllegalArgumentException();
        }
        this.scavenger.setMaxUnusedConnections(n);
    }

    public void setHighThreshold(int n) {
        if (n < 0) {
            if (Trace.isOn) {
                Trace.trace(2, this, "setHighThreshold called with thresdhold < 0");
            }
            throw new IllegalArgumentException();
        }
        this.scavenger.setMaxUnusedConnections(n);
    }

    public int getMaxUnusedConnections() {
        return this.scavenger.getMaxUnusedConnections();
    }

    public int getHighThreshold() {
        return this.scavenger.getMaxUnusedConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _setActive(boolean bl) {
        Enumeration enumeration;
        Vector vector;
        if (Trace.isOn) {
            Trace.entry(this, "_setActive");
        }
        Object object = this;
        synchronized (object) {
            this.active = bl;
            boolean bl2 = false;
            vector = (Vector)this.ownedSMCs.clone();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                StoredManagedConnection storedManagedConnection = (StoredManagedConnection)enumeration.nextElement();
                storedManagedConnection.poolActive(bl);
            }
            if (bl) {
                this.scavenger.start();
            } else {
                this.scavenger.quit();
            }
        }
        if (!bl) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (StoredManagedConnection)enumeration.nextElement();
                ((StoredManagedConnection)object).destroyIfMarked();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "_setActive");
        }
    }

    void addStoredManagedConnection(StoredManagedConnection storedManagedConnection) {
        this.ownedSMCs.addElement(storedManagedConnection);
    }

    void removeStoredManagedConnection(StoredManagedConnection storedManagedConnection) {
        this.ownedSMCs.removeElement(storedManagedConnection);
    }

    private int currentSize() {
        return this.ownedSMCs.size();
    }

    private int inPool() {
        return this.scavenger.inPool();
    }

    public void setMaxConnections(int n) throws IllegalArgumentException {
        String string = "setMaxConnections";
        if (Trace.isOn) {
            Trace.entry(this, string);
        }
        if (n < 0) {
            if (Trace.isOn) {
                Trace.exit(this, string);
            }
            throw new IllegalArgumentException();
        }
        int n2 = this.currentSize();
        this.maxCons = n;
        int n3 = this.inPool();
        int n4 = 0;
        if (n < n2 - n3) {
            n4 = n2 - n3;
        } else if (n < n2) {
            n4 = n2 - n;
        }
        this.scavenger.destroyNext(n4);
        if (Trace.isOn) {
            Trace.exit(this, string);
        }
    }

    public int getMaxConnections() {
        return this.maxCons;
    }

    synchronized void _tokenSetChanged(MQPoolServicesEvent mQPoolServicesEvent) {
        if (this.mode == 0) {
            if (MQEnvironment.defaultMQCxManager == this && this.poolServices.getTokenCount() > 0) {
                if (!this.active) {
                    this._setActive(true);
                }
            } else if (this.active) {
                this._setActive(false);
            }
        }
    }

    private class PSAdapter
    implements MQPoolServicesEventListener {
        private PSAdapter() {
        }

        public void tokenAdded(MQPoolServicesEvent mQPoolServicesEvent) {
            MQSimpleConnectionManager.this._tokenSetChanged(mQPoolServicesEvent);
        }

        public void tokenRemoved(MQPoolServicesEvent mQPoolServicesEvent) {
            MQSimpleConnectionManager.this._tokenSetChanged(mQPoolServicesEvent);
        }

        public void defaultConnectionManagerChanged(MQPoolServicesEvent mQPoolServicesEvent) {
            MQSimpleConnectionManager.this._tokenSetChanged(mQPoolServicesEvent);
        }
    }
}

