/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.FWHelper;
import com.ibm.mq.MQCcsidTable;
import com.ibm.mq.MQChannelDefinition;
import com.ibm.mq.MQChannelExit;
import com.ibm.mq.MQCompressor;
import com.ibm.mq.MQException;
import com.ibm.mq.MQExternalReceiveExit;
import com.ibm.mq.MQExternalSecurityExit;
import com.ibm.mq.MQExternalSendExit;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQOutputStream;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQReceiveExitChain;
import com.ibm.mq.MQSESSIONClient;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.MQSendExitChain;
import com.ibm.mq.Pint;
import com.ibm.mq.SSLHelper;
import com.ibm.mqservices.MQInternalException;
import com.ibm.mqservices.Trace;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;
import javax.net.ssl.SSLSocket;

public abstract class MQInternalCommunications {
    private static final String sccsid = "@(#) javabase/com/ibm/mq/MQInternalCommunications.java, java, j600, j600-101-060504 1.134.1.8 06/05/04 15:09:05";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final int TSH_EYECATCHER = 1414744096;
    protected static final int TSH_EBCDIC_EYECATCHER = -471676864;
    protected static final int TST_INITIAL_DATA = 1;
    protected static final int TST_RESYNCH = 2;
    protected static final int TST_RESET = 3;
    protected static final int TST_MESSAGE_DATA = 4;
    protected static final int TST_STATUS_DATA = 5;
    protected static final int TST_SECURITY_DATA = 6;
    protected static final int TST_PING_DATA = 7;
    protected static final int TST_USERID_DATA = 8;
    protected static final int TST_HEARTBEAT = 9;
    protected static final int TST_CONAUTH_DATA = 10;
    protected static final int TST_RENEGOTIATE_DATA = 11;
    protected static final int TST_MQCONN = 129;
    protected static final int TST_MQDISC = 130;
    protected static final int TST_MQOPEN = 131;
    protected static final int TST_MQCLOSE = 132;
    protected static final int TST_MQGET = 133;
    protected static final int TST_MQPUT = 134;
    protected static final int TST_MQPUT1 = 135;
    protected static final int TST_MQSET = 136;
    protected static final int TST_MQINQ = 137;
    protected static final int TST_MQCMIT = 138;
    protected static final int TST_MQBACK = 139;
    protected static final int TST_SPI = 140;
    protected static final int TST_MQCONN_REPLY = 145;
    protected static final int TST_MQDISC_REPLY = 146;
    protected static final int TST_MQOPEN_REPLY = 147;
    protected static final int TST_MQCLOSE_REPLY = 148;
    protected static final int TST_MQGET_REPLY = 149;
    protected static final int TST_MQPUT_REPLY = 150;
    protected static final int TST_MQPUT1_REPLY = 151;
    protected static final int TST_MQSET_REPLY = 152;
    protected static final int TST_MQINQ_REPLY = 153;
    protected static final int TST_MQCMIT_REPLY = 154;
    protected static final int TST_MQBACK_REPLY = 155;
    protected static final int TST_SPI_REPLY = 156;
    protected static final int TST_XA_START = 161;
    protected static final int TST_XA_END = 162;
    protected static final int TST_XA_OPEN = 163;
    protected static final int TST_XA_CLOSE = 164;
    protected static final int TST_XA_PREPARE = 165;
    protected static final int TST_XA_COMMIT = 166;
    protected static final int TST_XA_ROLLBACK = 167;
    protected static final int TST_XA_FORGET = 168;
    protected static final int TST_XA_RECOVER = 169;
    protected static final int TST_XA_COMPLETE = 170;
    protected static final int TST_XA_START_REPLY = 177;
    protected static final int TST_XA_END_REPLY = 178;
    protected static final int TST_XA_OPEN_REPLY = 179;
    protected static final int TST_XA_CLOSE_REPLY = 180;
    protected static final int TST_XA_PREPARE_REPLY = 181;
    protected static final int TST_XA_COMMIT_REPLY = 182;
    protected static final int TST_XA_ROLLBACK_REPLY = 183;
    protected static final int TST_XA_FORGET_REPLY = 184;
    protected static final int TST_XA_RECOVER_REPLY = 185;
    protected static final int TST_XA_COMPLETE_REPLY = 186;
    protected static final int TCF_CONFIRM_REQUEST = 1;
    protected static final int TCF_ERROR = 2;
    protected static final int TCF_REQUEST_CLOSE = 4;
    protected static final int TCF_CLOSE_CHANNEL = 8;
    protected static final int TCF_FIRST = 16;
    protected static final int TCF_LAST = 32;
    protected static final int TCF_REQUEST_ACCEPTED = 64;
    protected static final int TCF_DLQ_USED = 128;
    protected static final int TCF2_HDRCOMP = 1;
    protected static final int TCF2_MSGCOMP = 2;
    protected static final int ICF_MSG_SEQ_NO = 1;
    protected static final int ICF_CONVERSION_CAPABLE = 2;
    protected static final int ICF_SPLIT_MESSAGES = 4;
    protected static final int ICF_REQUEST_INITIATION = 8;
    protected static final int ICF_REQUEST_SECURITY = 16;
    protected static final int ICF_MQREQUEST = 32;
    protected static final int ICF_SVRCONN_SECURITY = 64;
    protected static final int ICF_RUNTIME_APP = 128;
    protected static final int ICF2_UNUSED_BITS = 0;
    protected static final int ICF2_DIST_LIST_CAPABLE = 1;
    protected static final int ICF2_FAST_MESSAGES_REQUIRED = 2;
    protected static final int ICF2_RESPONDER_CONVERSION = 4;
    protected static final int ICF2_XAREQUEST = 16;
    protected static final int ICF2_XARUNTIME_APP = 32;
    protected static final int ICF2_SPIREQUEST = 64;
    protected static final int ICF2_DUAL_UOW = 8;
    protected static final int ICF2_TRACE_ROUTE_CAPABLE = 128;
    protected static final int IEF_CCSID_NOT_SUPPORTED = 1;
    protected static final int IEF_ENCODING_INVALID = 2;
    protected static final int IEF_MAX_TRANSMISSION_SIZE = 4;
    protected static final int IEF_FAP_LEVEL = 8;
    protected static final int IEF_MAX_MSG_SIZE = 16;
    protected static final int IEF_MAX_MSG_PER_BATCH = 32;
    protected static final int IEF_SEQ_WRAP_VALUE = 64;
    protected static final int IEF_HEARTBEAT_INTERVAL = 128;
    protected static final int IEF2_HDRCOMPLIST = 1;
    protected static final int IEF2_MSGCOMPLIST = 2;
    protected static final int OPT_VERSIONS_SUPPORTED = 1;
    protected static final int OPT_MQCONNX = 2;
    protected static final int TST_SPI_CAN_WAIT = 193;
    protected static final int TST_SPI_CAN_WAIT_REPLY = 209;
    protected static final int ICF_CANCEL_WAIT = 64;
    protected static final int ICF_DEFERRED_MQI = 128;
    protected static final int TSH_HEADER_SIZE = 28;
    protected static final int API_HEADER_SIZE = 16;
    protected Socket connection = null;
    protected DataInputStream serverIn = null;
    protected DataOutputStream serverOut = null;
    protected String hostname = null;
    protected String qManager = null;
    protected int handle = 0;
    protected int ccsid = 0;
    protected Thread thread = null;
    protected String channel;
    protected int port;
    protected MQManagedConnectionJ11 mqManCon;
    protected MQSendExit sendExit = null;
    protected MQReceiveExit receiveExit = null;
    protected MQSecurityExit securityExit = null;
    protected String sslCipherSuite = null;
    public String sslPeername = null;
    public Collection sslCertStores = null;
    public Object sslSocketFactory = null;
    boolean sslFipsRequired = false;
    private int byteCount = 0;
    protected int sslKeyResetCount = 0;
    static Boolean inFipsMode = null;
    private boolean heartbeatResetRequired = false;
    protected InetAddress fw_localip = null;
    protected int fw_pstart = 0;
    protected int fw_pend = 0;
    protected boolean requestSPI = false;
    protected boolean xaRequired = false;
    protected boolean ccsidIsAscii = false;
    protected boolean exitsInitialised = false;
    protected boolean suppressSendExit = false;
    protected boolean suppressReceiveExit = false;
    protected boolean suppressSecurityExit = false;
    protected MQChannelDefinition channelDefinition = new MQChannelDefinition();
    protected MQChannelExit securityExitParms = new MQChannelExit();
    protected MQChannelExit sendExitParms = new MQChannelExit();
    protected MQChannelExit receiveExitParms = new MQChannelExit();
    protected Integer communicationsLock = new Integer(0);
    protected int maxMessageSize = 0x6400000;
    protected int maxTransmissionSize = 65532;
    protected int IDFlags = 37;
    protected int sequenceWrapValue = 999999999;
    protected int maxMessagesPerBatch = 50;
    protected boolean serverSecurityExit = false;
    protected int fapLevel = 8;
    protected int IDFlags2 = 1;
    protected int heartbeatInterval = 1;
    protected boolean distListCapable = true;
    protected int transmissionLength = 0;
    protected int socketTimeOutPrimer;
    protected int socketTimeOut = this.socketTimeOutPrimer = 120000;
    protected static final int DEFAULT_SOCKET_GRAIN_TIMEOUT = 10000;
    protected int socketGrainTimeout = 10000;
    protected String userID;
    protected String password;
    protected String longUserID;
    protected byte[] userSecurityID;
    protected int curHdrCompression = 0;
    protected int curMsgCompression = 0;
    protected MQCompressor compressor = null;
    protected MQOutputStream sendBytes = null;
    protected DataOutputStream sendData = null;
    byte[] transmissionData = new byte[this.maxTransmissionSize];
    protected boolean shouldAdoptQMgrCcsid = false;
    protected boolean qmCcsidKnown = false;

    protected final synchronized void close() {
        block10: {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            try {
                block9: {
                    try {
                        if (this.connection != null) {
                            this.sendStatus(8, 0);
                        }
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block9;
                        Trace.trace(1, this, "MQException during sendStatus");
                        Trace.dumpCallStack();
                    }
                }
                if (this.exitsInitialised) {
                    this.terminateExits();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (IOException iOException) {
                if (!Trace.isOn) break block10;
                Trace.trace(1, this, "IOException during close" + iOException);
                Trace.dumpCallStack();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    protected final synchronized void send(int n, int n2, byte[] byArray, byte[] byArray2) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "send");
            Trace.trace(2, this, "TSH type = " + n);
            Trace.trace(3, this, "Control flags = " + n2);
            if (byArray2 != null) {
                Trace.trace(3, this, "API Header follows:");
                Trace.dataTrace(3, this, byArray2);
            }
            if (byArray != null) {
                Trace.trace(4, this, "Message data follows:");
                Trace.dataTrace(4, this, byArray);
            }
        }
        if (this.serverOut == null) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Data could not be sent - output stream was null");
                Trace.exit(this, "send (via exception)");
            }
            throw new MQInternalException(2, 2009, 43);
        }
        boolean bl = n >= 129 && n <= 193;
        try {
            int n3 = byArray == null ? 0 : byArray.length;
            int n4 = 28 + n3;
            if (bl) {
                n4 += 16;
            }
            boolean bl2 = true;
            int n5 = n2 | 0x10;
            int n6 = n3;
            int n7 = 0;
            while (bl2 || n6 > 0) {
                int n8;
                int n9;
                if (Trace.isOn) {
                    Trace.trace(2, this, "Sending data, " + n6 + " bytes of msg data remain");
                }
                this.sendBytes.reset();
                int n10 = 28;
                if (bl && bl2) {
                    n10 += 16;
                }
                if (n7 + (n9 = (n8 = Math.min(n6 + n10, this.maxTransmissionSize)) - n10) >= n3) {
                    n5 |= 0x20;
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Last segment of message");
                    }
                }
                this.sendData = this.writeTSH(this.sendData, n8, n, n5);
                if (bl && bl2) {
                    this.sendData.write(byArray2);
                }
                if (byArray != null) {
                    this.sendData.write(byArray, n7, n9);
                }
                byte[] byArray3 = this.sendBytes.toByteArray();
                if (!(this.curHdrCompression == 0 && this.curMsgCompression == 0 || n != 129 && n != 131 && n != 134 && n != 135 && n != 133)) {
                    if (this.compressor != null && Trace.isOn) {
                        Trace.trace(this, "Invoking compressor");
                    }
                    byArray3 = this.compressor.compressMsgSegment(byArray3, this.curHdrCompression, this.curMsgCompression);
                }
                byArray3 = this.invokeSendExit(byArray3);
                this.writeToServer(byArray3);
                if (bl2) {
                    bl2 = false;
                    n5 -= 16;
                }
                n6 -= n9;
                n7 += n9;
            }
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.trace(1, this, "IOException occured during send.  The socket connection was\nprobably broken by the other party.");
                Trace.trace(this, iOException.toString());
                Trace.exit(this, "send (via exception)");
            }
            throw new MQInternalException(2, 2009, 44);
        }
        if (Trace.isOn) {
            Trace.exit(this, "send");
        }
    }

    protected final synchronized void send(int n, int n2, byte[] byArray, byte[] byArray2, int n3, byte[] byArray3) throws MQException {
        byte[] byArray4 = new byte[]{};
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        boolean bl2 = false;
        if (Trace.isOn) {
            Trace.entry(this, "send");
            Trace.trace(2, this, "TSH type = " + n);
            Trace.trace(3, this, "Control flags = " + n2);
            if (byArray3 != null) {
                Trace.trace(3, this, "API Header follows:");
                Trace.dataTrace(3, this, byArray3);
            }
            if (byArray != null) {
                Trace.trace(4, this, "Message data follows:");
                Trace.dataTrace(4, this, byArray);
            }
            if (byArray2 != null && byArray2.length > 0) {
                if (byArray2.length <= 400) {
                    Trace.trace(4, this, "Message payload follows:");
                    Trace.dataTrace(4, this, byArray2);
                } else {
                    byte[] byArray5 = new byte[400];
                    System.arraycopy(byArray2, 0, byArray5, 0, byArray5.length);
                    Trace.trace(4, this, "First 400 bytes of message payload follows:");
                    Trace.dataTrace(4, this, byArray5);
                }
            }
        }
        if (this.serverOut == null) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Data could not be sent - output stream was null");
                Trace.exit(this, "send (via exception)");
            }
            throw new MQInternalException(2, 2009, 43);
        }
        boolean bl3 = n >= 129 && n <= 193;
        try {
            int n6 = byArray == null ? 0 : byArray.length + n3;
            int n7 = 28 + n6;
            if (bl3) {
                n7 += 16;
            }
            boolean bl4 = true;
            int n8 = n2 | 0x10;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            for (int i = n6; bl4 || i > 0; i -= n4 + n5) {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Sending data, " + i + " bytes of msg data remain");
                }
                this.sendBytes.reset();
                int n12 = 28;
                if (bl3 && bl4) {
                    n12 += 16;
                }
                int n13 = Math.min(i + n12, this.maxTransmissionSize);
                int n14 = n13 - n12;
                if (byArray.length == n9) {
                    bl = false;
                }
                if (n14 < i) {
                    if (bl) {
                        if (n14 <= byArray.length) {
                            n4 = n14;
                            n5 = 0;
                        } else {
                            n4 = byArray.length;
                            n5 = n14 - n4 < n3 ? n14 - n4 : n3 - n10;
                        }
                    } else {
                        n4 = 0;
                        n5 = n14 - n4 < n3 ? n14 - n4 : n3 - n10;
                    }
                } else {
                    n4 = byArray.length - n9;
                    n5 = n3 - n10;
                }
                if (n11 + n13 >= n6 + n12) {
                    n8 |= 0x20;
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Last segment of message");
                    }
                }
                this.sendData = this.writeTSH(this.sendData, n13, n, n8);
                if (bl3 && bl4) {
                    this.sendData.write(byArray3);
                }
                if (this.sendExit != null || this.curHdrCompression != 0 || this.curMsgCompression != 0) {
                    if (byArray != null) {
                        if (byArray2 == null || n3 == 0) {
                            this.sendData.write(byArray, n9, n4);
                        } else {
                            byte[] byArray6 = new byte[n4 + n5];
                            System.arraycopy(byArray, n9, byArray6, 0, n4);
                            System.arraycopy(byArray2, n10, byArray6, n4, n5);
                            this.sendData.write(byArray6, 0, n4 + n5);
                        }
                    }
                    byte[] byArray7 = this.sendBytes.toByteArray();
                    if (!(this.curHdrCompression == 0 && this.curMsgCompression == 0 || n != 129 && n != 131 && n != 134 && n != 135 && n != 133)) {
                        if (this.compressor != null && Trace.isOn) {
                            Trace.trace(this, "Invoking compressor");
                        }
                        byArray7 = this.compressor.compressMsgSegment(byArray7, this.curHdrCompression, this.curMsgCompression);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "--- PRESEND ---");
                        Trace.dataTrace(4, this, byArray7);
                    }
                    byArray7 = this.invokeSendExit(byArray7);
                    if (Trace.isOn) {
                        Trace.trace(this, "--- XMITDATA ---");
                        Trace.dataTrace(4, this, byArray7);
                    }
                    this.writeToServer(byArray7);
                } else {
                    if (byArray != null && bl) {
                        this.sendData.write(byArray, n9, n4);
                    }
                    if (bl4) {
                        byArray4 = this.sendBytes.toByteArray();
                        if (Trace.isOn) {
                            Trace.dataTrace(4, this, byArray4);
                        }
                        this.writeToServer(byArray4);
                        this.writeToServer(byArray2, 0, n5);
                    } else {
                        this.writeToServer(this.sendBytes.toByteArray(), 0, n12);
                        if (bl) {
                            this.writeToServer(byArray, n9, n4);
                        }
                        this.writeToServer(byArray2, n10, n5);
                    }
                }
                if (bl4) {
                    bl4 = false;
                    n8 -= 16;
                }
                n11 = (n9 += n4) + (n10 += n5);
            }
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.trace(1, this, "IOException occured during send.  The socket connection was\nprobably broken by the other party.");
                Trace.trace(this, iOException.toString());
                Trace.exit(this, "send (via exception)");
            }
            throw new MQInternalException(2, 2009, 44);
        }
        if (Trace.isOn) {
            Trace.exit(this, "send");
        }
    }

    protected final synchronized byte[] receiveBytes(Pint pint, Pint pint2, Pint pint3) throws MQException {
        Object object;
        if (this.transmissionData == null) {
            this.transmissionData = new byte[this.maxTransmissionSize];
        }
        boolean bl = false;
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n = 0;
        if (Trace.isOn) {
            Trace.entry(this, "receiveBytes");
        }
        if (this.serverIn == null) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Data could not be received - input stream was null");
            }
            throw new MQInternalException(2, 2009, 45);
        }
        while (!bl) {
            if (Trace.isOn) {
                Trace.trace(2, this, "Waiting for data on input stream.");
            }
            this.serverIn.mark(8);
            try {
                int n2 = this.readIntFromServer();
                if (n2 != 1414744096 && n2 != -471676864) {
                    if (Trace.isOn) {
                        Trace.trace(1, this, "Invalid eyecatcher : " + n2);
                    }
                    throw new MQInternalException(2, 2195, 46, Integer.toString(n2, 16));
                }
            }
            catch (IOException iOException) {
                if (Trace.isOn) {
                    Trace.trace(this, iOException.toString());
                }
                throw new MQInternalException(2, 2195, 48);
            }
            try {
                this.transmissionLength = this.readIntFromServer();
                if (Trace.isOn) {
                    Trace.trace(2, this, "Receiving " + this.transmissionLength + " bytes of data.");
                }
                this.transmissionData = new byte[this.transmissionLength];
                this.serverIn.reset();
                this.readAllFromServer(this.transmissionData, 0, this.transmissionLength);
                if (this.receiveExit != null) {
                    this.transmissionData = this.invokeReceiveExit(this.transmissionData);
                }
                if ((this.transmissionData[11] & 1) != 0 || (this.transmissionData[11] & 2) != 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Invoking decompressor");
                    }
                    if (this.compressor != null) {
                        this.transmissionData = this.compressor.decompressMsgSegment(this.transmissionData, this.curMsgCompression, this.maxTransmissionSize);
                    }
                }
                object = new ByteArrayInputStream(this.transmissionData, 0, this.transmissionData.length);
                DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                dataInputStream = this.readTSH(dataInputStream, pint, pint2, pint3);
                if (pint.x != 9 && pint.x != 11) {
                    linkedList.add(this.transmissionData);
                    n += this.transmissionData.length - 28;
                    bl = true;
                    if (pint.x < 145 || pint.x > 156 || (pint2.x & 0x20) != 0) continue;
                    bl = false;
                    continue;
                }
                if (pint.x == 11) {
                    this.heartbeatResetRequired = false;
                    if (Trace.isOn) {
                        Trace.trace(this, "Renegotiation request received");
                    }
                    this.renegotiateKey();
                    linkedList.clear();
                    n = 0;
                    this.send(11, 0, null, null);
                    bl = false;
                    continue;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "heartbeat received");
                }
                if (this.sslKeyResetCount > 0) {
                    if (this.fapLevel < 8) {
                        if (Trace.isOn) {
                            Trace.trace(this, "QM version 5.3, resetting on heartbeat");
                        }
                        this.renegotiateKey();
                    } else {
                        this.heartbeatResetRequired = true;
                    }
                }
                linkedList.clear();
                n = 0;
                this.send(9, 0, null, null);
                bl = false;
            }
            catch (IOException iOException) {
                if (Trace.isOn) {
                    Trace.trace(this, iOException.toString());
                }
                throw new MQInternalException(2, 2195, 48);
            }
        }
        if (n > 0) {
            int n3 = linkedList.size();
            object = new byte[n];
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                byte[] byArray = (byte[])linkedList.removeFirst();
                System.arraycopy(byArray, 28, object, n4, byArray.length - 28);
                n4 += byArray.length - 28;
            }
        } else {
            object = new byte[]{};
        }
        if (Trace.isOn) {
            Trace.trace(2, this, "Data received.");
            Trace.trace(4, this, "Received message data follows:");
            Trace.dataTrace(4, this, object);
            Trace.exit(this, "receiveBytes");
        }
        return object;
    }

    protected final synchronized DataInputStream receive(Pint pint, Pint pint2, Pint pint3) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "receive");
        }
        byte[] byArray = null;
        try {
            byArray = this.receiveBytesFaster(pint, pint2, pint3);
        }
        catch (MQInternalException mQInternalException) {
            byArray = new byte[]{};
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        if (Trace.isOn) {
            Trace.exit(this, "receive");
        }
        return dataInputStream;
    }

    protected final synchronized void sendStatus(int n, int n2) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "sendStatus");
            Trace.trace(2, this, "status = " + n);
            Trace.trace(2, this, "errCode = " + n2);
        }
        try {
            if (n2 != 0) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(8);
                dataOutputStream.writeInt(n2);
                this.send(5, n, byteArrayOutputStream.toByteArray(), null);
            } else {
                this.send(5, n, null, null);
            }
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.exit(this, "sendStatus (via exception)");
            }
            throw new MQInternalException(2, 2195, 49);
        }
        if (Trace.isOn) {
            Trace.exit(this, "sendStatus");
        }
    }

    protected final DataOutputStream writeTSH(DataOutputStream dataOutputStream, int n, int n2, int n3) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "writeTSH");
        }
        dataOutputStream.writeInt(1414744096);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(n2);
        dataOutputStream.writeByte(n3);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeLong(0L);
        dataOutputStream.writeInt(273);
        dataOutputStream.writeShort(this.ccsid);
        dataOutputStream.writeShort(0);
        if (Trace.isOn) {
            Trace.exit(this, "writeTSH");
        }
        return dataOutputStream;
    }

    protected final DataInputStream readTSH(DataInputStream dataInputStream, Pint pint, Pint pint2, Pint pint3) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "readTSH");
        }
        dataInputStream.skipBytes(8);
        dataInputStream.skipBytes(1);
        pint.x = dataInputStream.readUnsignedByte();
        pint2.x = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(1);
        dataInputStream.skipBytes(8);
        pint3.x = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(2);
        dataInputStream.skipBytes(2);
        if (Trace.isOn) {
            Trace.trace(3, this, "Segment type = " + pint.x);
            Trace.trace(3, this, "Control flags = " + pint2.x);
            Trace.trace(3, this, "Encoding = " + pint3.x);
            Trace.exit(this, "readTSH");
        }
        return dataInputStream;
    }

    protected final byte[] buildAPIHeader(int n, int n2, int n3, int n4) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "buildAPIHeader");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n + 16 + 28);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(n4);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (Trace.isOn) {
                Trace.trace(4, this, "API header follows:");
                Trace.dataTrace(4, this, byArray);
                Trace.exit(this, "buildAPIHeader");
            }
            return byArray;
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.exit(this, "buildAPIHeader (via exception)");
            }
            throw new MQInternalException(2, 2071, 50);
        }
    }

    protected final void initialiseExits() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "initialiseExits");
        }
        this.channelDefinition.channelName = this.channel;
        this.channelDefinition.queueManagerName = this.qManager;
        this.channelDefinition.maxMessageLength = this.maxMessageSize;
        this.channelDefinition.securityUserData = "";
        this.channelDefinition.sendUserData = "";
        this.channelDefinition.receiveUserData = "";
        this.channelDefinition.connectionName = this.hostname;
        this.channelDefinition.remoteUserId = this.fapLevel >= 5 ? this.longUserID : this.userID;
        this.channelDefinition.remotePassword = this.password;
        this.channelDefinition.localAddress = this.connection.getLocalAddress().getHostAddress() + "(" + this.connection.getLocalPort() + ")";
        this.securityExitParms.maxSegmentLength = this.maxTransmissionSize;
        this.securityExitParms.exitID = 11;
        this.securityExitParms.fapLevel = this.fapLevel;
        this.securityExitParms.capabilityFlags = this.IDFlags2;
        this.sendExitParms.maxSegmentLength = this.maxTransmissionSize;
        this.sendExitParms.exitID = 13;
        this.sendExitParms.fapLevel = this.fapLevel;
        this.sendExitParms.capabilityFlags = this.IDFlags2;
        this.receiveExitParms.maxSegmentLength = this.maxTransmissionSize;
        this.receiveExitParms.exitID = 14;
        this.receiveExitParms.fapLevel = this.fapLevel;
        this.receiveExitParms.capabilityFlags = this.IDFlags2;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        Object object = null;
        if (this.securityExit != null && !bl && !bl2) {
            if (Trace.isOn) {
                Trace.trace(2, this, "User security exit provided.");
            }
            this.securityExitParms.exitReason = 11;
            this.securityExit.securityExit(this.securityExitParms, this.channelDefinition, new byte[0]);
            if (this.securityExit instanceof MQExternalSecurityExit && ((n = ((MQExternalSecurityExit)this.securityExit).getReasonCode()) == 2406 || n == 2407)) {
                bl2 = true;
                object = this.securityExit;
            }
            if (this.securityExitParms.exitResponse == -1 || this.securityExitParms.exitResponse == -6) {
                bl = true;
            }
        }
        if (this.sendExit != null) {
            if (Trace.isOn) {
                Trace.trace(2, this, "User send exit provided.");
            }
            this.sendExitParms.exitReason = 11;
            this.sendExit.sendExit(this.sendExitParms, this.channelDefinition, new byte[0]);
            if ((this.sendExit instanceof MQExternalSendExit || this.sendExit instanceof MQSendExitChain) && ((n = this.sendExit instanceof MQExternalSendExit ? ((MQExternalSendExit)this.sendExit).getReasonCode() : ((MQSendExitChain)this.sendExit).getReasonCode()) == 2406 || n == 2407)) {
                bl2 = true;
                object = this.sendExit;
            }
            if (this.sendExitParms.exitResponse == -6) {
                bl = true;
            }
        }
        if (this.receiveExit != null && !bl && !bl2) {
            if (Trace.isOn) {
                Trace.trace(2, this, "User receive exit provided.");
            }
            this.receiveExitParms.exitReason = 11;
            this.receiveExit.receiveExit(this.receiveExitParms, this.channelDefinition, new byte[0]);
            if ((this.receiveExit instanceof MQExternalReceiveExit || this.receiveExit instanceof MQReceiveExitChain) && ((n = this.receiveExit instanceof MQExternalReceiveExit ? ((MQExternalReceiveExit)this.receiveExit).getReasonCode() : ((MQReceiveExitChain)this.receiveExit).getReasonCode()) == 2406 || n == 2407)) {
                bl2 = true;
                object = this.receiveExit;
            }
            if (this.receiveExitParms.exitResponse == -6) {
                bl = true;
            }
        }
        if (bl || bl2) {
            if (Trace.isOn) {
                if (bl) {
                    Trace.trace(1, this, "User exit requested channel be closed.");
                } else {
                    Trace.trace(1, this, "Failure in using non-Java user exit.");
                }
            }
            this.suppressSendExit = true;
            if (Trace.isOn) {
                Trace.trace(1, this, "Sending TCF_CLOSE_CHANNEL");
            }
            this.sendStatus(8, 9);
            if (Trace.isOn) {
                Trace.exit(this, "initialiseExits (via exception)");
            }
            if (bl) {
                throw new MQInternalException(2, 2195, 81);
            }
            throw new MQException(2, n, object);
        }
        this.exitsInitialised = true;
        if (Trace.isOn) {
            Trace.exit(this, "initialiseExits");
        }
    }

    final void terminateExits() {
        if (Trace.isOn) {
            Trace.entry(this, "terminateExits");
        }
        if (this.securityExit != null) {
            if (Trace.isOn) {
                Trace.trace(2, this, "Terminating security exit.");
            }
            this.securityExitParms.exitReason = 12;
            this.securityExit.securityExit(this.securityExitParms, this.channelDefinition, new byte[0]);
        }
        if (this.sendExit != null) {
            if (Trace.isOn) {
                Trace.trace(2, this, "Terminating send exit.");
            }
            this.sendExitParms.exitReason = 12;
            byte[] byArray = this.sendExit.sendExit(this.sendExitParms, this.channelDefinition, new byte[0]);
            if (byArray != null && this.serverOut != null) {
                try {
                    this.serverOut.write(byArray);
                }
                catch (IOException iOException) {
                    Trace.trace(3, this, "exception discarded: " + iOException);
                }
            }
        }
        if (this.receiveExit != null) {
            if (Trace.isOn) {
                Trace.trace(2, this, "Terminating receive exit.");
            }
            this.receiveExitParms.exitReason = 12;
            this.receiveExit.receiveExit(this.receiveExitParms, this.channelDefinition, new byte[0]);
        }
        if (Trace.isOn) {
            Trace.exit(this, "terminateExits");
        }
    }

    protected final void invokeSecurityExit() throws MQException, IOException {
        if (Trace.isOn) {
            Trace.exit(this, "invokeSecurityExit");
        }
        this.securityExitParms.exitReason = 16;
        this.securityExitParms.exitResponse = 0;
        byte[] byArray = new byte[]{};
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        while (!bl) {
            if ((byArray = this.securityExit.securityExit(this.securityExitParms, this.channelDefinition, byArray)) != null && Trace.isOn) {
                Trace.trace(4, this, "Data returned by security exit follows:");
                Trace.dataTrace(4, this, byArray);
            }
            switch (this.securityExitParms.exitResponse) {
                case -6: 
                case -1: {
                    this.sendStatus(8, 9);
                    this.connection.close();
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Client security exit closed the channel.");
                        Trace.exit(this, "invokeSecurityExit (via exception)");
                    }
                    throw new MQInternalException(2, 2063, 72);
                }
                case -3: {
                    bl2 = true;
                }
                case -4: {
                    bl3 = true;
                    break;
                }
                default: {
                    byArray = null;
                }
            }
            if (!bl3 && !bl4) {
                bl = true;
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n = byArray != null ? byArray.length : 0;
                dataOutputStream.writeInt(n);
                if (byArray != null) {
                    dataOutputStream.write(byArray);
                }
                if (Trace.isOn) {
                    Trace.trace(2, this, "Sending security message.");
                }
                this.send(6, 0, byteArrayOutputStream.toByteArray(), null);
                Pint pint = new Pint();
                Pint pint2 = new Pint();
                Pint pint3 = new Pint();
                if (Trace.isOn) {
                    Trace.trace(2, this, "Waiting for server response.");
                }
                DataInputStream dataInputStream = this.receive(pint, pint2, pint3);
                switch (pint.x) {
                    case 5: {
                        int n2;
                        if ((pint2.x & 2) != 0) {
                            n2 = 0;
                            if (this.transmissionLength > 28) {
                                dataInputStream.skipBytes(4);
                                n2 = dataInputStream.readInt();
                            } else {
                                n2 = 22;
                            }
                            if (Trace.isOn) {
                                Trace.trace(1, this, "Server sent TCF_ERROR, code : " + n2);
                            }
                            this.close();
                            if (Trace.isOn) {
                                Trace.exit(this, "invokeSecurityExit (via exception)");
                            }
                            throw new MQInternalException(2, 2063, 73, "" + n2);
                        }
                        if ((pint2.x & 8) != 0) {
                            if (Trace.isOn) {
                                Trace.trace(1, this, "Server sent TCF_CLOSE_CHANNEL");
                            }
                            this.close();
                            if (Trace.isOn) {
                                Trace.exit(this, "invokeSecurityExit (via exception)");
                            }
                            throw new MQInternalException(2, 2009, 99);
                        }
                        if (bl2) {
                            if (Trace.isOn) {
                                Trace.trace(1, this, "Server sent unexpected TST_STATUS_DATA");
                            }
                            this.close();
                            if (Trace.isOn) {
                                Trace.exit(this, "invokeSecurityExit (via exception)");
                            }
                            throw new MQInternalException(2, 2063, 74);
                        }
                        bl = true;
                        break;
                    }
                    case 6: {
                        this.securityExitParms.exitReason = 15;
                        int n2 = dataInputStream.readInt();
                        byArray = new byte[n2];
                        dataInputStream.read(byArray, 0, n2);
                        bl2 = false;
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(1, this, "Server sent unexpected segment type: " + pint.x);
                        }
                        this.close();
                        if (Trace.isOn) {
                            Trace.exit(this, "invokeSecurityExit (via exception)");
                        }
                        throw new MQInternalException(2, 2195, 75);
                    }
                }
            }
            bl4 = false;
        }
        if (Trace.isOn) {
            Trace.exit(this, "invokeSecurityExit");
        }
    }

    final byte[] invokeSendExit(byte[] byArray) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "invokeSendExit");
            Trace.trace(4, this, "Data passed to exit follows:");
            Trace.dataTrace(4, this, byArray);
        }
        byte[] byArray2 = byArray;
        if (!this.suppressSendExit && this.sendExit != null && this.exitsInitialised) {
            this.sendExitParms.exitResponse = 0;
            this.sendExitParms.exitReason = 14;
            if (Trace.isOn) {
                Trace.trace(2, this, "Calling user send exit");
            }
            byArray2 = this.sendExit.sendExit(this.sendExitParms, this.channelDefinition, byArray);
            if (Trace.isOn) {
                if (byArray2 == null) {
                    Trace.trace(1, this, "Warning : User send exit returned a null data buffer.");
                } else {
                    Trace.trace(4, this, "Data returned from user send exit follows:");
                    Trace.dataTrace(4, this, byArray2);
                }
            }
            if (this.sendExitParms.exitResponse == -5) {
                this.suppressSendExit = true;
            } else {
                if (this.sendExitParms.exitResponse == -6) {
                    if (Trace.isOn) {
                        Trace.trace(1, this, "Send exit requested closure of channel.");
                    }
                    this.suppressSendExit = true;
                    this.sendStatus(8, 9);
                    this.connection.close();
                    if (Trace.isOn) {
                        Trace.exit(this, "invokeSenExit (via exception)");
                    }
                    throw new MQInternalException(2, 2195, 81);
                }
                if (this.sendExit instanceof MQExternalSendExit || this.sendExit instanceof MQSendExitChain) {
                    int n = this.sendExit instanceof MQExternalSendExit ? ((MQExternalSendExit)this.sendExit).getReasonCode() : ((MQSendExitChain)this.sendExit).getReasonCode();
                    if (n == 2406 || n == 2407) {
                        if (Trace.isOn) {
                            Trace.trace(1, this, "Failure in using non-Java send exit.");
                        }
                        this.suppressSendExit = true;
                        this.sendStatus(8, 9);
                        this.connection.close();
                        if (Trace.isOn) {
                            Trace.exit(this, "invokeSendExit (via exception)");
                        }
                        throw new MQException(2, n, this.sendExit);
                    }
                } else if (byArray2.length != byArray.length) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.writeInt(byArray2.length);
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    System.arraycopy(byArray3, 0, byArray2, 4, 4);
                }
            }
        } else if (Trace.isOn) {
            Trace.trace(2, this, "No user send exit was invoked");
        }
        if (Trace.isOn) {
            Trace.exit(this, "invokeSendExit");
        }
        return byArray2;
    }

    final byte[] invokeReceiveExit(byte[] byArray) throws IOException, MQException {
        if (Trace.isOn) {
            Trace.entry(this, "invokeReceiveExit");
            Trace.trace(4, this, "Data passed to receive exit follows:");
            Trace.dataTrace(4, this, byArray);
        }
        byte[] byArray2 = byArray;
        if (!this.suppressReceiveExit && this.receiveExit != null && this.exitsInitialised) {
            this.receiveExitParms.exitResponse = 0;
            this.receiveExitParms.exitReason = 14;
            byArray = this.receiveExit.receiveExit(this.receiveExitParms, this.channelDefinition, byArray);
            if (Trace.isOn) {
                if (byArray == null) {
                    Trace.trace(1, this, "Warning: User receive exit returned a null buffer");
                } else {
                    Trace.trace(4, this, "Data returned from user receive exit follows:");
                    Trace.dataTrace(4, this, byArray);
                }
            }
            if (this.receiveExitParms.exitResponse == -5) {
                this.suppressReceiveExit = true;
            } else {
                if (this.receiveExitParms.exitResponse == -6) {
                    if (Trace.isOn) {
                        Trace.trace(1, this, "Receive exit requested closure of channel.");
                    }
                    this.suppressReceiveExit = true;
                    this.sendStatus(8, 9);
                    this.connection.close();
                    if (Trace.isOn) {
                        Trace.exit(this, "invokeReceiveExit (via exception)");
                    }
                    throw new MQInternalException(2, 2195, 81);
                }
                if (this.receiveExit instanceof MQExternalReceiveExit || this.receiveExit instanceof MQReceiveExitChain) {
                    int n = this.receiveExit instanceof MQExternalReceiveExit ? ((MQExternalReceiveExit)this.receiveExit).getReasonCode() : ((MQReceiveExitChain)this.receiveExit).getReasonCode();
                    if (n == 2406 || n == 2407) {
                        if (Trace.isOn) {
                            Trace.trace(1, this, "Failure in using non-Java receive exit.");
                        }
                        this.suppressReceiveExit = true;
                        this.sendStatus(8, 9);
                        this.connection.close();
                        if (Trace.isOn) {
                            Trace.exit(this, "invokeReceiveExit (via exception)");
                        }
                        throw new MQException(2, n, this.receiveExit);
                    }
                } else if (byArray2.length != byArray.length) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    dataOutputStream.writeInt(byArray2.length);
                    byte[] byArray3 = byteArrayOutputStream.toByteArray();
                    System.arraycopy(byArray3, 0, byArray2, 4, 4);
                }
            }
        } else if (Trace.isOn) {
            Trace.trace(2, this, "No user receive exit was invoked");
        }
        if (Trace.isOn) {
            Trace.exit(this, "invokeReceiveExit");
        }
        return byArray;
    }

    protected boolean supportsSPI() {
        return this.requestSPI;
    }

    protected boolean isValidJavaCcsid(int n) {
        boolean bl;
        String string = String.valueOf(n);
        String string2 = MQCcsidTable.lookup(string);
        if (string2 == null) {
            string2 = string;
        }
        String string3 = "X";
        try {
            byte[] byArray = string3.getBytes(string2);
            bl = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bl = false;
        }
        return bl;
    }

    protected boolean isCcsidAscii(int n) throws MQException {
        boolean bl;
        String string = String.valueOf(n);
        String string2 = MQCcsidTable.lookup(string);
        if (string2 == null) {
            string2 = string;
        }
        String string3 = "A";
        try {
            byte[] byArray = string3.getBytes(string2);
            bl = byArray.length == 1 && byArray[0] == 65;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MQInternalException(2, 2195, 87, string);
        }
        return bl;
    }

    protected Socket createExplicitSocketConnection(String string, int n, InetAddress inetAddress, int n2, int n3, int n4) throws MQInternalException, IOException {
        if (Trace.isOn) {
            Trace.entry(this, "createExplicitSocketConnection");
        }
        Socket socket = null;
        for (int i = 0; i <= n3 - n2; ++i) {
            try {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Try to create socket bound locally to " + inetAddress + ", port " + n4);
                    FWHelper.debug("Try to create socket bound locally to " + inetAddress + ", port " + n4);
                }
                if ((socket = new Socket(string, n, inetAddress, n4)) != null) {
                    if (Trace.isOn) {
                        String string2 = "Socket created OK: " + inetAddress + ", local port " + socket.getLocalPort();
                        Trace.trace(2, this, string2);
                        FWHelper.debug(string2);
                    }
                } else if (Trace.isOn) {
                    String string3 = "Socket create failed - null returned.";
                    Trace.trace(2, this, string3);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "createExplicitSocketConnection (success)");
                }
                return socket;
            }
            catch (BindException bindException) {
                if (!Trace.isOn) continue;
                Trace.trace(2, this, "Socket created failed due to bind exception (see below): " + inetAddress + ", port " + n4);
                Trace.trace(2, this, "BindException: " + bindException.getMessage());
                FWHelper.debug("BindException: " + inetAddress + ", port " + n4);
                continue;
            }
            catch (IOException iOException) {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Socket created failed due to IOException (see below): " + inetAddress + ", port " + n4);
                    Trace.trace(2, this, "Exception (rethrowing): " + iOException);
                    FWHelper.debug("Exception: " + inetAddress + ", port " + n4);
                }
                throw iOException;
            }
        }
        if (Trace.isOn) {
            FWHelper.debug("Failed to create socket matching firewall properties.");
        }
        MQInternalException mQInternalException = new MQInternalException(2, 2059, 125);
        if (Trace.isOn) {
            Trace.exit(this, "createExplicitSocketConnection (failed)");
        }
        throw mQInternalException;
    }

    protected final void createSocketConnection() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "createSocketConnection");
            Trace.trace(1, this, "Connecting to " + this.hostname + " on port " + this.port);
        }
        try {
            boolean bl;
            boolean bl2 = bl = this.sslCipherSuite != null && !this.sslCipherSuite.equals("");
            if (inFipsMode == null) {
                inFipsMode = new Boolean(this.sslFipsRequired);
            }
            if (inFipsMode != this.sslFipsRequired) {
                throw new MQException(2, 2400, (Object)this, 52);
            }
            if (this.fw_pstart != 0 || this.fw_localip != null) {
                if (FWHelper.FW_DEBUG_ENABLED) {
                    FWHelper.debug("Creating a firewall socket");
                    FWHelper.debug("fw_localip: " + this.fw_localip);
                    FWHelper.debug("fw_pstart: " + this.fw_pstart);
                    FWHelper.debug("fw_pend: " + this.fw_pend);
                }
                int n = 0;
                n = FWHelper.getLastTried(this.fw_localip, this.fw_pstart, this.fw_pend);
                if (n != 0) {
                    if (++n > this.fw_pend) {
                        n = this.fw_pstart;
                    }
                } else {
                    n = this.fw_pstart;
                }
                int n2 = n > this.fw_pstart && n <= this.fw_pend ? n : this.fw_pstart;
                this.connection = bl ? SSLHelper.createExplicitSSLSocket(this.hostname, this.port, this.sslCipherSuite, this.sslPeername, this.sslCertStores, this.sslSocketFactory, this, this.fw_localip, this.fw_pstart, this.fw_pend, n2) : this.createExplicitSocketConnection(this.hostname, this.port, this.fw_localip, this.fw_pstart, this.fw_pend, n2);
                FWHelper.setLastTried(this.fw_localip, this.fw_pstart, this.fw_pend, this.connection.getLocalPort());
                if (Trace.isOn) {
                    Trace.trace(1, this, "Socket created on local port " + this.connection.getLocalPort());
                }
            } else {
                if (FWHelper.FW_DEBUG_ENABLED) {
                    FWHelper.debug("Creating a standard socket");
                }
                this.connection = bl ? SSLHelper.createSSLSocket(this.hostname, this.port, this.sslCipherSuite, this.sslPeername, this.sslCertStores, this.sslSocketFactory, this) : new Socket(this.hostname, this.port);
            }
            this.connection.setTcpNoDelay(true);
            MQSESSIONClient mQSESSIONClient = (MQSESSIONClient)this.mqManCon.getMQSESSION();
            this.sslKeyResetCount = mQSESSIONClient.getSSLResetCount();
            try {
                this.connection.setSendBufferSize(32768);
                this.connection.setReceiveBufferSize(32768);
            }
            catch (Exception exception) {
                if (Trace.isOn) {
                    Trace.trace(this, "failed to increase socket buffer sizes: " + exception);
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Hostname invalid!");
                Trace.exit(this, "createSocketConnection (via exception)");
            }
            throw new MQInternalException(2, 2059, 51, this.hostname);
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Exception creating socket " + iOException);
                Trace.exit(this, "createSocketConnection (via exception)");
            }
            throw new MQInternalException(2, 2059, 52);
        }
        catch (SecurityException securityException) {
            if (Trace.isOn) {
                Trace.trace(1, this, "SecurityException " + securityException + "\nConsult user guide for information on host access rules.");
                Trace.exit(this, "createSocketConnection (via exception)");
            }
            throw new MQInternalException(2, 2059, 53, this.hostname);
        }
        try {
            this.serverIn = new DataInputStream(new BufferedInputStream(this.connection.getInputStream()));
            this.serverOut = new DataOutputStream(this.connection.getOutputStream());
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.trace(1, this, "Exception accessing socket streams " + iOException);
                Trace.exit(this, "createSocketConnection (via exception)");
            }
            throw new MQInternalException(2, 2059, 54);
        }
        if (Trace.isOn) {
            Trace.exit(this, "createSocketConnection");
        }
    }

    protected InetAddress getLocalInetAddress() {
        if (this.connection != null) {
            return this.connection.getLocalAddress();
        }
        return null;
    }

    protected int getLocalBoundPort() {
        if (this.connection != null) {
            return this.connection.getLocalPort();
        }
        return 0;
    }

    protected void writeToServer(byte[] byArray) throws MQException, IOException {
        this.byteCount += byArray.length;
        this.serverOut.write(byArray);
    }

    protected void writeToServer(byte[] byArray, int n, int n2) throws MQException, IOException {
        this.byteCount += n2;
        this.serverOut.write(byArray, n, n2);
    }

    protected int readIntFromServer() throws IOException {
        this.byteCount += 4;
        return this.timedReadInt(this.socketTimeOut);
    }

    protected void readAllFromServer(byte[] byArray, int n, int n2) throws IOException {
        this.timedReadFully(byArray, n, n2);
        this.byteCount += n2;
    }

    protected synchronized void renegotiateKey() throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "renegotiateKey");
        }
        this.heartbeatResetRequired = false;
        this.byteCount = 0;
        SSLHelper.renegotiateKey((SSLSocket)this.connection);
        if (Trace.isOn) {
            Trace.exit(this, "renegotiateKey");
        }
    }

    protected void checkSSLResetCount(int n) throws MQException {
        if (this.sslKeyResetCount > 0 && this.connection instanceof SSLSocket) {
            boolean bl;
            if (Trace.isOn) {
                Trace.entry(this, "checkSSLResetCount");
            }
            boolean bl2 = bl = this.byteCount + n >= this.sslKeyResetCount;
            if (bl || this.heartbeatResetRequired) {
                if (Trace.isOn) {
                    if (this.heartbeatResetRequired) {
                        Trace.trace(this, "Resetting key due to heartbeats");
                    } else if (n > 0) {
                        Trace.trace(this, "SSLResetCount will be exceeded, we will reset the key");
                    } else {
                        Trace.trace(this, "SSLResetCount has been exceeded, we will reset the key");
                    }
                }
                this.renegotiateKey();
            }
            if (Trace.isOn) {
                Trace.exit(this, "checkSSLResetCount");
            }
        }
    }

    void timedReadFully(byte[] byArray) throws IOException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "timedReadFully (buffer only)");
            }
            this.timedReadFully(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.trace(5, this, "leaving via IOException");
            }
            throw iOException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "timedReadFully (buffer only)");
            }
        }
    }

    void timedReadFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "timedReadFully");
                Trace.trace(5, this, "off = " + n + ", len = " + n2 + ", grain timeout = " + this.socketGrainTimeout);
            }
            n5 = this.socketTimeOut;
            bl = false;
            do {
                try {
                    this.serverIn.readFully(byArray, n, n2);
                    bl = false;
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (Trace.isOn) {
                        Trace.trace(5, this, "serverIn.readFully() failed. Assuming socket timeout");
                    }
                    if ((n5 -= this.socketGrainTimeout) > 0) {
                        if (Trace.isOn) {
                            Trace.trace(5, this, "tempTimeout = " + n5 + ", retrying");
                        }
                        bl = true;
                        continue;
                    }
                    if (Trace.isOn) {
                        Trace.trace(5, this, "timed out. Not retrying, delivering InterruptedIOException instead:");
                        Trace.exceptionTrace(5, this, interruptedIOException);
                    }
                    throw interruptedIOException;
                }
            } while (n5 >= 0 && bl);
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.exceptionTrace(5, this, iOException);
                Trace.trace(5, this, "leaving via IOException");
            }
            throw iOException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "timedReadFully");
            }
        }
    }

    int timedReadInt() throws IOException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            if (Trace.isOn) {
                Trace.entry(this, "timedReadInt");
                Trace.trace(5, this, "grain timeout = " + this.socketGrainTimeout);
            }
            byte[] byArray = new byte[4];
            this.timedReadFully(byArray, 0, 4);
            int n5 = byArray[0] << 24;
            if (n5 < 0) {
                n5 &= 0xFF;
            }
            if ((n4 = byArray[1] << 16) < 0) {
                n4 &= 0xFF;
            }
            if ((n3 = byArray[2] << 8) < 0) {
                n3 &= 0xFF;
            }
            if ((n2 = byArray[3] << 0) < 0) {
                n2 &= 0xFF;
            }
            int n6 = n5 + n4 + n3 + n2;
            if (Trace.isOn) {
                for (n = 0; n < byArray.length; ++n) {
                    Trace.trace(5, this, "b[" + n + "] = " + byArray[n]);
                }
                Trace.trace(5, this, "ch1 =    " + n5);
                Trace.trace(5, this, "ch2 =    " + n4);
                Trace.trace(5, this, "ch3 =    " + n3);
                Trace.trace(5, this, "ch4 =    " + n2);
                Trace.trace(5, this, "result = " + n6);
            }
            n = n6;
            return n;
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.exceptionTrace(5, this, iOException);
                Trace.trace(5, this, "leaving via IOException");
            }
            throw iOException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "timedReadInt");
            }
        }
    }

    int timedReadInt(int n) throws IOException {
        int n2 = -1;
        boolean bl = false;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "timedReadInt");
                Trace.trace(5, this, "timeout = " + n);
            }
            int n3 = 0;
            n2 = this.socketTimeOut;
            bl = false;
            do {
                try {
                    n3 = this.serverIn.readInt();
                    bl = false;
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (Trace.isOn) {
                        Trace.trace(5, this, "Caught InterruptedIOException. Assuming socket timeout");
                    }
                    if ((n2 -= this.socketGrainTimeout) > 0) {
                        if (Trace.isOn) {
                            Trace.trace(5, this, "tempTimeout = " + n2 + ", retrying");
                        }
                        bl = true;
                        continue;
                    }
                    if (Trace.isOn) {
                        Trace.trace(5, this, "timed out. Not retrying, throwing Exception instead:");
                        Trace.exceptionTrace(5, this, interruptedIOException);
                    }
                    throw interruptedIOException;
                }
            } while (n2 >= 0 && bl);
            int n4 = n3;
            return n4;
        }
        catch (IOException iOException) {
            if (Trace.isOn) {
                Trace.exceptionTrace(5, this, iOException);
                Trace.trace(5, this, "leaving via IOException");
            }
            throw iOException;
        }
        finally {
            if (Trace.isOn) {
                Trace.exit(this, "timedReadInt");
            }
        }
    }

    protected final synchronized byte[] receiveBytesFaster(Pint pint, Pint pint2, Pint pint3) throws MQException {
        byte[] byArray;
        boolean bl = false;
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n = 0;
        if (Trace.isOn()) {
            Trace.entry(this, "receiveBytesFaster");
        }
        if (this.serverIn == null) {
            Trace.trace(1, this, "Data could not be received - input stream was null");
            throw new MQInternalException(2, 2009, 45);
        }
        if (this.transmissionData == null) {
            this.transmissionData = new byte[this.maxTransmissionSize];
        }
        while (!bl) {
            int n2;
            if (Trace.isOn()) {
                Trace.trace(2, this, "Waiting for data on input stream.");
            }
            try {
                n2 = this.timedReadInt(this.socketTimeOut);
                if (n2 != 1414744096 && n2 != -471676864) {
                    if (Trace.isOn()) {
                        Trace.trace(1, this, "Invalid eyecatcher : " + n2);
                    }
                    throw new MQInternalException(2, 2195, 46, Integer.toString(n2, 16));
                }
            }
            catch (IOException iOException) {
                if (Trace.isOn()) {
                    Trace.trace(this, iOException.toString());
                }
                throw new MQInternalException(2, 2195, 48);
            }
            try {
                this.transmissionLength = this.readIntFromServer();
                if (Trace.isOn()) {
                    Trace.trace(2, this, "Receiving " + this.transmissionLength + " bytes of data.");
                }
                this.transmissionData = new byte[this.transmissionLength];
                this.transmissionData[0] = (byte)(n2 >>> 24 & 0xFF);
                this.transmissionData[1] = (byte)(n2 >>> 16 & 0xFF);
                this.transmissionData[2] = (byte)(n2 >>> 8 & 0xFF);
                this.transmissionData[3] = (byte)(n2 >>> 0 & 0xFF);
                this.transmissionData[4] = (byte)(this.transmissionLength >>> 24 & 0xFF);
                this.transmissionData[5] = (byte)(this.transmissionLength >>> 16 & 0xFF);
                this.transmissionData[6] = (byte)(this.transmissionLength >>> 8 & 0xFF);
                this.transmissionData[7] = (byte)(this.transmissionLength >>> 0 & 0xFF);
                this.byteCount += this.transmissionLength;
                this.timedReadFully(this.transmissionData, 8, this.transmissionLength - 8);
                if (this.receiveExit != null) {
                    this.transmissionData = this.invokeReceiveExit(this.transmissionData);
                }
                if ((this.transmissionData[11] & 1) != 0 || (this.transmissionData[11] & 2) != 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Invoking decompressor");
                    }
                    if (this.compressor != null) {
                        this.transmissionData = this.compressor.decompressMsgSegment(this.transmissionData, this.curMsgCompression, this.maxTransmissionSize);
                    }
                }
                pint.x = this.transmissionData[9] & 0xFF;
                pint2.x = this.transmissionData[10] & 0xFF;
                pint3.x = this.transmissionData[20] & 0xFF;
                if (Trace.isOn) {
                    Trace.trace(3, this, "Segment type = " + pint.x);
                    Trace.trace(3, this, "Control flags = " + pint2.x);
                    Trace.trace(3, this, "Encoding = " + pint3.x);
                    Trace.exit(this, "readTSH");
                }
                if (pint.x != 9 && pint.x != 11) {
                    linkedList.add(this.transmissionData);
                    n += this.transmissionData.length - 28;
                    bl = true;
                    if (pint.x < 145 || pint.x > 156 || (pint2.x & 0x20) != 0) continue;
                    bl = false;
                    continue;
                }
                if (pint.x == 11) {
                    this.heartbeatResetRequired = false;
                    if (Trace.isOn) {
                        Trace.trace(this, "Renegotiation request received");
                    }
                    this.renegotiateKey();
                    linkedList.clear();
                    n = 0;
                    this.send(11, 0, null, null);
                    bl = false;
                    continue;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "heartbeat received");
                }
                if (this.sslKeyResetCount > 0) {
                    if (this.fapLevel < 8) {
                        if (Trace.isOn) {
                            Trace.trace(this, "QM version 5.3, resetting on heartbeat");
                        }
                        this.renegotiateKey();
                    } else {
                        this.heartbeatResetRequired = true;
                    }
                }
                linkedList.clear();
                n = 0;
                this.send(9, 0, null, null);
                bl = false;
            }
            catch (IOException iOException) {
                if (Trace.isOn()) {
                    Trace.trace(this, iOException.toString());
                }
                throw new MQInternalException(2, 2195, 48);
            }
        }
        if (n > 0) {
            int n3 = linkedList.size();
            byArray = new byte[n];
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                byte[] byArray2 = (byte[])linkedList.removeFirst();
                System.arraycopy(byArray2, 28, byArray, n4, byArray2.length - 28);
                n4 += byArray2.length - 28;
            }
        } else {
            byArray = new byte[]{};
        }
        if (Trace.isOn()) {
            Trace.trace(2, this, "Data received.");
            Trace.trace(4, this, "Received message data follows:");
            Trace.dataTrace(4, this, byArray);
        }
        if (Trace.isOn()) {
            Trace.exit(this, "receiveBytesFaster");
        }
        return byArray;
    }
}

