/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQDistributionListItem;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mqservices.Trace;

public class MQDistributionList
extends MQManagedObject {
    private static final String sccsid = "@(#)  javabase/com/ibm/mq/MQDistributionList.java, java, j600, j600-101-060328 1.28.1.2 05/09/13 18:16:30";
    private static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-L82, 5724-L26     (c) Copyright IBM Corp. 2000, 2005 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MQSESSION osession = null;
    private int knownDestCount;
    private int unknownDestCount;
    private int invalidDestCount;
    private MQQueueManager mgr = null;
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    private int distributionListLength = 0;
    private MQDistributionListItem[] items = null;

    public MQDistributionList(MQQueueManager mQQueueManager, MQDistributionListItem[] mQDistributionListItemArray, int n, String string) throws MQException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "MQDistributionList constructor");
            Trace.trace(2, this, sccsid);
        }
        if (mQQueueManager == null) {
            if (Trace.isOn) {
                Trace.exit(this, "MQDistributionList constructor (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 1);
        }
        this.osession = mQQueueManager.getSession();
        if (!mQQueueManager.connected) {
            if (Trace.isOn) {
                Trace.exit(this, "MQDistributionList constructor (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        if (!mQQueueManager.getDistributionListCapable()) {
            if (Trace.isOn) {
                Trace.exit(this, "MQDistributionList constructor (via exception)");
            }
            throw new MQException(2, 2044, (Object)this, 32);
        }
        if (mQDistributionListItemArray == null) {
            if (Trace.isOn) {
                Trace.exit(this, "MQDistributionList constructor (via exception)");
            }
            throw new MQException(2, 2155, (Object)this, 3);
        }
        for (int i = 0; i < mQDistributionListItemArray.length; ++i) {
            if (mQDistributionListItemArray[i] == null) {
                if (Trace.isOn) {
                    Trace.exit(this, "MQDistributionList constructor (via exception)");
                }
                throw new MQException(2, 2154, (Object)this, 6);
            }
            if (i > 0) {
                mQDistributionListItemArray[i].setPreviousDistributedItem(mQDistributionListItemArray[i - 1]);
            }
            if (i >= mQDistributionListItemArray.length - 1) continue;
            mQDistributionListItemArray[i].setNextDistributedItem(mQDistributionListItemArray[i + 1]);
        }
        this.items = mQDistributionListItemArray;
        MQOD mQOD = new MQOD(this.items);
        if (string != null && string.length() > 0) {
            mQOD.AlternateUserId = string;
        }
        this.Hconn = mQQueueManager.Hconn;
        this.connected = mQQueueManager.connected;
        if (Trace.isOn()) {
            if (Trace.isOn) {
                Trace.trace(2, this, "DistributionList:");
            }
            for (int i = 0; i < mQDistributionListItemArray.length; ++i) {
                object = mQDistributionListItemArray[i].queueManagerName;
                String string2 = mQDistributionListItemArray[i].queueName;
                if (object == null) {
                    object = "<null>";
                }
                if (string2 == null) {
                    string2 = "<null>";
                }
                if (!Trace.isOn) continue;
                Trace.trace(2, this, "  '" + (String)object + "' '" + string2);
            }
        }
        this.osession.MQOPEN(this.Hconn.x, mQOD, n, this.Hobj, this.completionCode, this.reason);
        if (this.completionCode.x == 2) {
            this.resourceOpen = false;
            this.isOpen = false;
            this.openStatus = false;
            object = new MQException(this.completionCode.x, this.reason.x, this);
            mQQueueManager.errorOccurred((MQException)object);
            if (Trace.isOn) {
                Trace.exit(this, "MQDistributionList constructor (via exception)");
            }
            throw object;
        }
        this.resourceOpen = true;
        this.isOpen = true;
        this.openStatus = true;
        this.mgr = mQQueueManager;
        this.openOptions = n;
        this.parentQmgr = mQQueueManager;
        this.connectionReference = mQQueueManager;
        if (string != null) {
            this.alternateUserId = string;
        }
        mQQueueManager.registerDistributionList(this);
        this.knownDestCount = mQOD.KnownDestCount;
        this.unknownDestCount = mQOD.UnknownDestCount;
        this.invalidDestCount = mQOD.InvalidDestCount;
        this.distributionListLength = mQDistributionListItemArray.length;
        if (Trace.isOn) {
            Trace.exit(this, "MQDistributionList constructor");
        }
    }

    public synchronized void put(MQMessage mQMessage, MQPutMessageOptions mQPutMessageOptions) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "put");
        }
        MQMessage mQMessage2 = mQMessage;
        if (mQMessage == null) {
            if (Trace.isOn) {
                Trace.exit(this, "put (via exception)");
            }
            throw new MQException(2, 2026, (Object)this, 8);
        }
        if (mQPutMessageOptions == null) {
            if (Trace.isOn) {
                Trace.exit(this, "put (via exception)");
            }
            throw new MQException(2, 2173, (Object)this, 9);
        }
        if (!this.connected) {
            if (Trace.isOn) {
                Trace.exit(this, "put (via exception)");
            }
            throw new MQException(2, 2018, (Object)this, 2);
        }
        if (!this.openStatus) {
            if (Trace.isOn) {
                Trace.exit(this, "put (via exception)");
            }
            throw new MQException(2, 2019, (Object)this, 11);
        }
        byte[] byArray = mQMessage.toByteArray();
        if (Trace.isOn()) {
            Trace.trace(2, this, "Message length = " + byArray.length + " bytes.");
            Trace.trace(3, this, "put options = " + mQPutMessageOptions.options + "\nmessage type = " + mQMessage.messageType + "\nencoding = " + mQMessage.encoding + "\ncharacter set = " + mQMessage.characterSet + "\nformat = " + mQMessage.format + "\nmessage id, correlation id, groupId  follow:");
            Trace.dataTrace(3, this, mQMessage.messageId);
            Trace.dataTrace(3, this, mQMessage.correlationId);
            Trace.dataTrace(3, this, mQMessage.groupId);
        }
        if ((mQPutMessageOptions.options & 0x300) != 0) {
            if (Trace.isOn) {
                Trace.trace(2, this, "Checking Context Reference");
            }
            if (mQPutMessageOptions.contextReference != null) {
                mQPutMessageOptions.contextReferenceHandle = mQPutMessageOptions.contextReference.getHandle();
                if (mQPutMessageOptions.contextReferenceHandle == -1) {
                    if (Trace.isOn) {
                        Trace.exit(this, "put (via exception)");
                    }
                    throw new MQException(2, 2097, this);
                }
                if (this.mgr != mQPutMessageOptions.contextReference.mgr) {
                    if (Trace.isOn) {
                        Trace.trace(2, this, "Connection references do not match");
                        Trace.exit(this, "put (via exception)");
                    }
                    throw new MQException(2, 2097, this);
                }
                if (Trace.isOn) {
                    Trace.trace(2, this, "Obtained context reference handle:" + mQPutMessageOptions.contextReferenceHandle);
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(2, this, "Context reference queue is null");
                    Trace.exit(this, "put (via exception)");
                }
                throw new MQException(2, 2097, this);
            }
        }
        mQPutMessageOptions.version2(this.items);
        this.osession.MQPUT(this.Hconn.x, this.Hobj.x, mQMessage2, mQPutMessageOptions, byArray.length, byArray, this.completionCode, this.reason);
        if (Trace.isOn) {
            Trace.trace(3, this, "Returned message id follows:");
            Trace.dataTrace(3, this, mQMessage.messageId);
        }
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mQException = new MQException(this.completionCode.x, this.reason.x, this);
            this.parentQmgr.errorOccurred(mQException);
            if (Trace.isOn) {
                Trace.exit(this, "put (via exception)");
            }
            throw mQException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "put");
        }
    }

    public synchronized void close() throws MQException {
        super.close();
        if (this.mgr != null) {
            this.mgr.unregisterDistributionList(this);
        }
        this.isOpen = false;
        this.openStatus = false;
        this.mgr = null;
        this.connectionReference = null;
    }

    public int getValidDestinationCount() {
        return this.knownDestCount + this.unknownDestCount;
    }

    public int getInvalidDestinationCount() {
        return this.invalidDestCount;
    }

    public MQDistributionListItem getFirstDistributionListItem() {
        if (this.items == null || this.items.length == 0) {
            return null;
        }
        return this.items[0];
    }

    protected void finalize() {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        if (this.openStatus) {
            try {
                this.close();
            }
            catch (MQException mQException) {
                // empty catch block
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }
}

